/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.messages;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;

public class MessageSeverityCollector
implements MessageCollector {
    private final MessageCollector delegate;
    private final Set<CompilerMessageSeverity> reportedSeverities = Sets.newHashSet();

    public MessageSeverityCollector(@NotNull MessageCollector delegate) {
        this.delegate = delegate;
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
        this.delegate.report(severity, message, location);
        this.reportedSeverities.add(severity);
    }

    public boolean anyReported(CompilerMessageSeverity ... severities) {
        return this.reportedSeverities.containsAll(Arrays.asList(severities));
    }
}

