/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.messages;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.CoreJarVirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;

public class MessageUtil {
    private MessageUtil() {
    }

    @NotNull
    public static CompilerMessageLocation psiElementToMessageLocation(@NotNull PsiElement element) {
        PsiFile file = element.getContainingFile();
        DiagnosticUtils.LineAndColumn lineAndColumn = DiagnosticUtils.getLineAndColumnInPsiFile(file, element.getTextRange());
        return MessageUtil.psiFileToMessageLocation(file, "<no path>", lineAndColumn.getLine(), lineAndColumn.getColumn());
    }

    @NotNull
    public static CompilerMessageLocation psiFileToMessageLocation(@NotNull PsiFile file, @Nullable String defaultValue, int line, int column) {
        String path;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            path = defaultValue;
        } else {
            path = virtualFile.getPath();
            if (virtualFile instanceof CoreLocalVirtualFile || virtualFile instanceof CoreJarVirtualFile) {
                path = FileUtil.toSystemDependentName(path);
            }
        }
        return CompilerMessageLocation.create(path, line, column);
    }
}

