/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.modules;

import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface ModuleDescription {
    @NotNull
    public String getModuleName();

    @NotNull
    public List<String> getSourceFiles();

    @NotNull
    public List<String> getClasspathRoots();

    @NotNull
    public List<String> getAnnotationsRoots();

    public static class Impl
    implements ModuleDescription {
        private String name;
        private final List<String> sources = new SmartList<String>();
        private final List<String> classpath = new SmartList<String>();
        private final List<String> annotations = new SmartList<String>();

        public void setName(String name) {
            this.name = name;
        }

        public void addSourcePath(String path) {
            this.sources.add(path);
        }

        public void addClassPath(String path) {
            this.classpath.add(path);
        }

        public void addAnnotationPath(String path) {
            this.annotations.add(path);
        }

        @Override
        @NotNull
        public String getModuleName() {
            return this.name;
        }

        @Override
        @NotNull
        public List<String> getSourceFiles() {
            return this.sources;
        }

        @Override
        @NotNull
        public List<String> getClasspathRoots() {
            return this.classpath;
        }

        @Override
        @NotNull
        public List<String> getAnnotationsRoots() {
            return this.annotations;
        }

        public String toString() {
            return this.name + "\n\tsources=" + this.sources + "\n\tclasspath=" + this.classpath + "\n\tannotations=" + this.annotations;
        }
    }
}

