/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jet.Function0;
import jet.modules.AllModules;
import jet.modules.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.cli.common.CLIConfigurationKeys;
import org.jetbrains.jet.cli.common.CompilerPlugin;
import org.jetbrains.jet.cli.common.CompilerPluginContext;
import org.jetbrains.jet.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.jet.cli.common.messages.MessageRenderer;
import org.jetbrains.jet.cli.common.messages.MessageUtil;
import org.jetbrains.jet.cli.common.messages.OutputMessageUtil;
import org.jetbrains.jet.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.jet.cli.jvm.JVMConfigurationKeys;
import org.jetbrains.jet.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.codegen.BuiltinToJavaTypesMapping;
import org.jetbrains.jet.codegen.ClassBuilderFactories;
import org.jetbrains.jet.codegen.ClassFileFactory;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.GeneratedClassLoader;
import org.jetbrains.jet.codegen.KotlinCodegenFacade;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.Progress;
import org.jetbrains.jet.config.CommonConfigurationKeys;
import org.jetbrains.jet.config.CompilerConfiguration;
import org.jetbrains.jet.lang.parsing.JetScriptDefinition;
import org.jetbrains.jet.lang.parsing.JetScriptDefinitionProvider;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.ScriptNameUtil;
import org.jetbrains.jet.lang.resolve.java.AnalyzerFacadeForJVM;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.plugin.JetMainDetector;
import org.jetbrains.jet.utils.ExceptionUtils;
import org.jetbrains.jet.utils.KotlinPaths;
import org.jetbrains.jet.utils.PathUtil;

public class KotlinToJVMBytecodeCompiler {
    private KotlinToJVMBytecodeCompiler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ClassFileFactory compileModule(CompilerConfiguration configuration, Module moduleBuilder, File directory) {
        if (moduleBuilder.getSourceFiles().isEmpty()) {
            throw new CompileEnvironmentException("No source files where defined in module " + moduleBuilder.getModuleName());
        }
        CompilerConfiguration compilerConfiguration = configuration.copy();
        for (String sourceFile : moduleBuilder.getSourceFiles()) {
            File source = new File(sourceFile);
            if (!source.isAbsolute()) {
                source = new File(directory, sourceFile);
            }
            if (!source.exists()) {
                throw new CompileEnvironmentException("'" + source + "' does not exist in module " + moduleBuilder.getModuleName());
            }
            compilerConfiguration.add(CommonConfigurationKeys.SOURCE_ROOTS_KEY, source.getPath());
        }
        for (String classpathRoot : moduleBuilder.getClasspathRoots()) {
            compilerConfiguration.add(JVMConfigurationKeys.CLASSPATH_KEY, new File(classpathRoot));
        }
        for (String annotationsRoot : moduleBuilder.getAnnotationsRoots()) {
            compilerConfiguration.add(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY, new File(annotationsRoot));
        }
        Disposable parentDisposable = CompileEnvironmentUtil.createMockDisposable();
        JetCoreEnvironment moduleEnvironment = null;
        try {
            moduleEnvironment = new JetCoreEnvironment(parentDisposable, compilerConfiguration);
            GenerationState generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(moduleEnvironment);
            if (generationState == null) {
                ClassFileFactory classFileFactory = null;
                return classFileFactory;
            }
            ClassFileFactory classFileFactory = generationState.getFactory();
            return classFileFactory;
        }
        finally {
            if (moduleEnvironment != null) {
                Disposer.dispose(parentDisposable);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compileModules(CompilerConfiguration configuration, @NotNull List<Module> modules, @NotNull File directory, @Nullable File jarPath, @Nullable File outputDir, boolean jarRuntime) {
        Iterator<Module> i$ = modules.iterator();
        while (i$.hasNext()) {
            Module moduleBuilder = i$.next();
            ClassFileFactory moduleFactory = KotlinToJVMBytecodeCompiler.compileModule(configuration, moduleBuilder, directory);
            if (moduleFactory == null) {
                return false;
            }
            if (outputDir != null) {
                CompileEnvironmentUtil.writeToOutputDirectory(moduleFactory, outputDir);
                continue;
            }
            File path = jarPath != null ? jarPath : new File(directory, moduleBuilder.getModuleName() + ".jar");
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(path);
                CompileEnvironmentUtil.writeToJar(moduleFactory, outputStream, null, jarRuntime);
                outputStream.close();
            }
            catch (FileNotFoundException e) {
                try {
                    throw new CompileEnvironmentException("Invalid jar path " + path, e);
                    catch (IOException e2) {
                        throw ExceptionUtils.rethrow(e2);
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.closeQuietly(outputStream);
                    throw throwable;
                }
            }
            ExceptionUtils.closeQuietly(outputStream);
        }
        return true;
    }

    @Nullable
    private static FqName findMainClass(@NotNull List<JetFile> files) {
        FqName mainClass = null;
        for (JetFile file : files) {
            if (!JetMainDetector.hasMain(file.getDeclarations())) continue;
            if (mainClass != null) {
                return null;
            }
            FqName fqName = JetPsiUtil.getFQName(file);
            mainClass = PackageClassUtils.getPackageClassFqName(fqName);
        }
        return mainClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compileBunchOfSources(JetCoreEnvironment environment, @Nullable File jar, @Nullable File outputDir, boolean includeRuntime) {
        FqName mainClass = KotlinToJVMBytecodeCompiler.findMainClass(environment.getSourceFiles());
        GenerationState generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(environment);
        if (generationState == null) {
            return false;
        }
        try {
            ClassFileFactory factory = generationState.getFactory();
            if (jar != null) {
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(jar);
                    CompileEnvironmentUtil.writeToJar(factory, new FileOutputStream(jar), mainClass, includeRuntime);
                    os.close();
                }
                catch (FileNotFoundException e) {
                    try {
                        throw new CompileEnvironmentException("Invalid jar path " + jar, e);
                        catch (IOException e2) {
                            throw ExceptionUtils.rethrow(e2);
                        }
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.closeQuietly(os);
                        throw throwable;
                    }
                }
                ExceptionUtils.closeQuietly(os);
            } else {
                if (outputDir == null) throw new CompileEnvironmentException("Output directory or jar file is not specified - no files will be saved to the disk");
                CompileEnvironmentUtil.writeToOutputDirectory(factory, outputDir);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            generationState.destroy();
        }
    }

    public static boolean compileAndExecuteScript(@NotNull KotlinPaths paths, @NotNull JetCoreEnvironment environment, @NotNull List<String> scriptArgs) {
        Class<?> scriptClass = KotlinToJVMBytecodeCompiler.compileScript(paths, environment, null);
        if (scriptClass == null) {
            return false;
        }
        try {
            scriptClass.getConstructor(String[].class).newInstance(new Object[]{scriptArgs.toArray(new String[0])});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to evaluate script: " + e, e);
        }
        return true;
    }

    private static Class<?> compileScript(@NotNull KotlinPaths paths, @NotNull JetCoreEnvironment environment, @Nullable ClassLoader parentLoader) {
        GenerationState generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(environment);
        if (generationState == null) {
            return null;
        }
        GeneratedClassLoader classLoader = null;
        try {
            ClassFileFactory factory = generationState.getFactory();
            classLoader = new GeneratedClassLoader(factory, (ClassLoader)new URLClassLoader(new URL[]{paths.getRuntimePath().toURI().toURL()}, parentLoader == null ? AllModules.class.getClassLoader() : parentLoader), new URL[0]);
            JetFile scriptFile = environment.getSourceFiles().get(0);
            Class<?> clazz = classLoader.loadClass(ScriptNameUtil.classNameForScript(scriptFile));
            return clazz;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to evaluate script: " + e, e);
        }
        finally {
            if (classLoader != null) {
                classLoader.dispose();
            }
            generationState.destroy();
        }
    }

    @Nullable
    public static GenerationState analyzeAndGenerate(JetCoreEnvironment environment) {
        return KotlinToJVMBytecodeCompiler.analyzeAndGenerate(environment, environment.getConfiguration().get(JVMConfigurationKeys.STUBS, false), environment.getConfiguration().getList(JVMConfigurationKeys.SCRIPT_PARAMETERS));
    }

    @Nullable
    public static GenerationState analyzeAndGenerate(JetCoreEnvironment environment, boolean stubs) {
        return KotlinToJVMBytecodeCompiler.analyzeAndGenerate(environment, stubs, environment.getConfiguration().getList(JVMConfigurationKeys.SCRIPT_PARAMETERS));
    }

    @Nullable
    public static GenerationState analyzeAndGenerate(JetCoreEnvironment environment, boolean stubs, List<AnalyzerScriptParameter> scriptParameters) {
        AnalyzeExhaust exhaust = KotlinToJVMBytecodeCompiler.analyze(environment, scriptParameters, stubs);
        if (exhaust == null) {
            return null;
        }
        exhaust.throwIfError();
        return KotlinToJVMBytecodeCompiler.generate(environment, exhaust, stubs);
    }

    @Nullable
    private static AnalyzeExhaust analyze(final JetCoreEnvironment environment, final List<AnalyzerScriptParameter> scriptParameters, boolean stubs) {
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(environment.getConfiguration().get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY));
        final Predicate filesToAnalyzeCompletely = stubs ? Predicates.alwaysFalse() : Predicates.alwaysTrue();
        analyzerWithCompilerReport.analyzeAndReport(new Function0<AnalyzeExhaust>(){

            @Override
            @NotNull
            public AnalyzeExhaust invoke() {
                BindingTrace sharedTrace = CliLightClassGenerationSupport.getInstanceForCli(environment.getProject()).getTrace();
                return AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(environment.getProject(), environment.getSourceFiles(), sharedTrace, scriptParameters, filesToAnalyzeCompletely, false);
            }
        }, environment.getSourceFiles());
        return analyzerWithCompilerReport.hasErrors() ? null : analyzerWithCompilerReport.getAnalyzeExhaust();
    }

    @NotNull
    private static GenerationState generate(JetCoreEnvironment environment, AnalyzeExhaust exhaust, boolean stubs) {
        Project project = environment.getProject();
        final CompilerConfiguration configuration = environment.getConfiguration();
        Progress backendProgress = new Progress(){

            @Override
            public void reportOutput(@NotNull Collection<File> sourceFiles, @Nullable File outputFile) {
                if (outputFile == null) {
                    return;
                }
                MessageCollector messageCollector = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
                if (messageCollector == null) {
                    return;
                }
                messageCollector.report(CompilerMessageSeverity.OUTPUT, OutputMessageUtil.formatOutputMessage(sourceFiles, outputFile), CompilerMessageLocation.NO_LOCATION);
            }
        };
        GenerationState generationState = new GenerationState(project, ClassBuilderFactories.binaries(stubs), backendProgress, exhaust.getBindingContext(), environment.getSourceFiles(), configuration.get(JVMConfigurationKeys.BUILTIN_TO_JAVA_TYPES_MAPPING_KEY, BuiltinToJavaTypesMapping.ENABLED), configuration.get(JVMConfigurationKeys.GENERATE_NOT_NULL_ASSERTIONS, false), configuration.get(JVMConfigurationKeys.GENERATE_NOT_NULL_PARAMETER_ASSERTIONS, false), true);
        KotlinCodegenFacade.compileCorrectFiles(generationState, CompilationErrorHandler.THROW_EXCEPTION);
        CompilerPluginContext context = new CompilerPluginContext(project, exhaust.getBindingContext(), environment.getSourceFiles());
        for (CompilerPlugin plugin : configuration.getList(CLIConfigurationKeys.COMPILER_PLUGINS)) {
            plugin.processFiles(context);
        }
        return generationState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Class compileScript(@NotNull ClassLoader parentLoader, @NotNull KotlinPaths paths, @NotNull String scriptPath, @Nullable List<AnalyzerScriptParameter> scriptParameters, @Nullable List<JetScriptDefinition> scriptDefinitions) {
        MessageRenderer messageRenderer = MessageRenderer.PLAIN;
        GroupingMessageCollector messageCollector = new GroupingMessageCollector(new PrintingMessageCollector(System.err, messageRenderer, false));
        Disposable rootDisposable = CompileEnvironmentUtil.createMockDisposable();
        try {
            CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
            compilerConfiguration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, messageCollector);
            compilerConfiguration.addAll(JVMConfigurationKeys.CLASSPATH_KEY, KotlinToJVMBytecodeCompiler.getClasspath(parentLoader));
            compilerConfiguration.add(JVMConfigurationKeys.CLASSPATH_KEY, PathUtil.findRtJar());
            compilerConfiguration.addAll(JVMConfigurationKeys.ANNOTATIONS_PATH_KEY, Collections.singletonList(paths.getJdkAnnotationsPath()));
            compilerConfiguration.add(CommonConfigurationKeys.SOURCE_ROOTS_KEY, scriptPath);
            compilerConfiguration.addAll(CommonConfigurationKeys.SCRIPT_DEFINITIONS_KEY, scriptDefinitions != null ? scriptDefinitions : Collections.emptyList());
            compilerConfiguration.put(JVMConfigurationKeys.SCRIPT_PARAMETERS, scriptParameters);
            JetCoreEnvironment environment = new JetCoreEnvironment(rootDisposable, compilerConfiguration);
            try {
                JetScriptDefinitionProvider.getInstance(environment.getProject()).markFileAsScript(environment.getSourceFiles().get(0));
                Class<?> clazz = KotlinToJVMBytecodeCompiler.compileScript(paths, environment, parentLoader);
                return clazz;
            }
            catch (CompilationException e) {
                messageCollector.report(CompilerMessageSeverity.EXCEPTION, MessageRenderer.PLAIN.renderException(e), MessageUtil.psiElementToMessageLocation(e.getElement()));
                Class clazz = null;
                messageCollector.flush();
                Disposer.dispose(rootDisposable);
                return clazz;
            }
            catch (Throwable t) {
                MessageCollectorUtil.reportException(messageCollector, t);
                Class clazz = null;
                messageCollector.flush();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                Disposer.dispose(rootDisposable);
                return clazz;
            }
        }
        finally {
            messageCollector.flush();
            Disposer.dispose(rootDisposable);
        }
    }

    private static Collection<File> getClasspath(ClassLoader loader) {
        return KotlinToJVMBytecodeCompiler.getClasspath(loader, new LinkedList<File>());
    }

    private static Collection<File> getClasspath(ClassLoader loader, LinkedList<File> files) {
        ClassLoader parent = loader.getParent();
        if (parent != null) {
            KotlinToJVMBytecodeCompiler.getClasspath(parent, files);
        }
        if (loader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                File file;
                String urlFile = url.getFile();
                if (urlFile.contains("%")) {
                    try {
                        urlFile = url.toURI().getPath();
                    }
                    catch (URISyntaxException e) {
                        throw ExceptionUtils.rethrow(e);
                    }
                }
                if (!(file = new File(urlFile)).exists() || !file.isDirectory() && !file.getName().endsWith(".jar")) continue;
                files.add(file);
            }
        }
        return files;
    }
}

