/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.signature.kotlin;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.AnnotationVisitor;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;

public class JetMethodAnnotationWriter {
    private final AnnotationVisitor av;

    private JetMethodAnnotationWriter(AnnotationVisitor av) {
        this.av = av;
    }

    public void writeFlags(int flags) {
        if (flags != 0) {
            this.av.visit("flags", flags);
        }
    }

    public void writeTypeParameters(@NotNull String typeParameters) {
        if (typeParameters.length() > 0) {
            this.av.visit("typeParameters", typeParameters);
        }
    }

    public void writeReturnType(@NotNull String returnType) {
        if (returnType.length() > 0) {
            this.av.visit("returnType", returnType);
        }
    }

    public void writePropertyType(@NotNull String propertyType) {
        if (propertyType.length() > 0) {
            this.av.visit("propertyType", propertyType);
        }
    }

    public void visitEnd() {
        this.av.visitEnd();
    }

    public static JetMethodAnnotationWriter visitAnnotation(MethodVisitor mv) {
        return new JetMethodAnnotationWriter(mv.visitAnnotation(JvmStdlibNames.JET_METHOD.getDescriptor(), true));
    }
}

