/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ReceiverParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ScriptCodeDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.ScriptNameUtil;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ScriptReceiver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class ScriptDescriptor
extends DeclarationDescriptorNonRootImpl {
    private static final Name NAME = Name.special("<script>");
    private final int priority;
    private JetType returnType;
    private List<ValueParameterDescriptor> valueParameters;
    private final ScriptCodeDescriptor scriptCodeDescriptor = new ScriptCodeDescriptor(this);
    private final ReceiverParameterDescriptor implicitReceiver = new ReceiverParameterDescriptorImpl(this, KotlinBuiltIns.getInstance().getAnyType(), new ScriptReceiver(this));
    private final ClassDescriptorImpl classDescriptor;
    private final WritableScopeImpl classScope;

    public ScriptDescriptor(@Nullable DeclarationDescriptor containingDeclaration, int priority, JetScript script, JetScope scriptScope) {
        super(containingDeclaration, Collections.<AnnotationDescriptor>emptyList(), NAME);
        this.priority = priority;
        String className = ScriptNameUtil.classNameForScript((JetFile)script.getContainingFile()).replace('/', '.');
        this.classDescriptor = new ClassDescriptorImpl(containingDeclaration, Collections.<AnnotationDescriptor>emptyList(), Modality.FINAL, new FqName(className).shortName());
        this.classScope = new WritableScopeImpl(scriptScope, containingDeclaration, RedeclarationHandler.DO_NOTHING, "script members");
        this.classScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        this.classDescriptor.initialize(false, Collections.emptyList(), Collections.singletonList(KotlinBuiltIns.getInstance().getAnyType()), this.classScope, new HashSet<ConstructorDescriptor>(), null, false);
    }

    public void initialize(@NotNull JetType returnType, JetScript declaration, BindingContext bindingContext) {
        this.returnType = returnType;
        this.scriptCodeDescriptor.initialize(this.implicitReceiver, this.valueParameters, returnType);
        PropertyDescriptorImpl propertyDescriptor = new PropertyDescriptorImpl(this.classDescriptor, Collections.<AnnotationDescriptor>emptyList(), Modality.FINAL, Visibilities.PUBLIC, false, Name.identifier("rv"), CallableMemberDescriptor.Kind.DECLARATION);
        propertyDescriptor.setType(returnType, Collections.emptyList(), this.classDescriptor.getThisAsReceiverParameter(), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
        propertyDescriptor.initialize(null, null);
        this.classScope.addPropertyDescriptor(propertyDescriptor);
        for (JetDeclaration jetDeclaration : declaration.getDeclarations()) {
            CallableDescriptor descriptor;
            if (jetDeclaration instanceof JetProperty) {
                descriptor = bindingContext.get(BindingContext.VARIABLE, jetDeclaration);
                assert (descriptor != null);
                ScriptDescriptor.initializeWithDefaultGetterSetter((PropertyDescriptorImpl)descriptor);
                this.classScope.addPropertyDescriptor((VariableDescriptor)descriptor);
                continue;
            }
            if (!(jetDeclaration instanceof JetNamedFunction)) continue;
            descriptor = bindingContext.get(BindingContext.FUNCTION, jetDeclaration);
            assert (descriptor != null);
            SimpleFunctionDescriptor copy = descriptor.copy(this.classDescriptor, descriptor.getModality(), descriptor.getVisibility(), CallableMemberDescriptor.Kind.DECLARATION, false);
            this.classScope.addFunctionDescriptor(copy);
        }
    }

    public static void initializeWithDefaultGetterSetter(PropertyDescriptorImpl propertyDescriptor) {
        PropertySetterDescriptor setter;
        PropertyGetterDescriptorImpl getter = propertyDescriptor.getGetter();
        if (getter == null) {
            PropertyGetterDescriptorImpl propertyGetterDescriptorImpl = getter = propertyDescriptor.getVisibility() != Visibilities.PRIVATE ? DescriptorResolver.createDefaultGetter(propertyDescriptor) : null;
            if (getter != null) {
                getter.initialize(propertyDescriptor.getType());
            }
        }
        if ((setter = propertyDescriptor.getSetter()) == null) {
            setter = propertyDescriptor.isVar() ? DescriptorResolver.createDefaultSetter(propertyDescriptor) : null;
        }
        propertyDescriptor.initialize(getter, setter);
    }

    public int getPriority() {
        return this.priority;
    }

    @NotNull
    public JetType getReturnType() {
        return this.returnType;
    }

    @NotNull
    public List<ValueParameterDescriptor> getValueParameters() {
        return this.valueParameters;
    }

    @NotNull
    public ScriptCodeDescriptor getScriptCodeDescriptor() {
        return this.scriptCodeDescriptor;
    }

    @NotNull
    public ReceiverParameterDescriptor getThisAsReceiverParameter() {
        return this.implicitReceiver;
    }

    @Override
    public DeclarationDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        throw new IllegalStateException("nothing to substitute in script");
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitScriptDescriptor(this, data);
    }

    public void setValueParameters(@NotNull List<ValueParameterDescriptor> valueParameters) {
        this.valueParameters = valueParameters;
        ConstructorDescriptorImpl constructorDescriptor = new ConstructorDescriptorImpl(this.classDescriptor, Collections.<AnnotationDescriptor>emptyList(), true).initialize(Collections.<TypeParameterDescriptor>emptyList(), valueParameters, Visibilities.PUBLIC);
        constructorDescriptor.setReturnType(this.classDescriptor.getDefaultType());
        this.classDescriptor.getConstructors().add(constructorDescriptor);
        this.classDescriptor.setPrimaryConstructor(constructorDescriptor);
        for (ValueParameterDescriptor parameter : valueParameters) {
            PropertyDescriptorImpl propertyDescriptor = new PropertyDescriptorImpl(this.classDescriptor, Collections.<AnnotationDescriptor>emptyList(), Modality.FINAL, Visibilities.PUBLIC, false, parameter.getName(), CallableMemberDescriptor.Kind.DECLARATION);
            propertyDescriptor.setType(parameter.getType(), Collections.emptyList(), this.classDescriptor.getThisAsReceiverParameter(), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
            propertyDescriptor.initialize(null, null);
            this.classScope.addPropertyDescriptor(propertyDescriptor);
        }
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }
}

