/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionImpl;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;

public class JetBinaryExpression
extends JetExpressionImpl
implements JetOperationExpression {
    public JetBinaryExpression(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitBinaryExpression(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitBinaryExpression(this, data);
    }

    @IfNotParsed
    @Nullable
    public JetExpression getLeft() {
        for (ASTNode node = this.getOperationReference().getNode().getTreePrev(); node != null; node = node.getTreePrev()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof JetExpression)) continue;
            return (JetExpression)psi;
        }
        return null;
    }

    @IfNotParsed
    @Nullable
    public JetExpression getRight() {
        for (ASTNode node = this.getOperationReference().getNode().getTreeNext(); node != null; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof JetExpression)) continue;
            return (JetExpression)psi;
        }
        return null;
    }

    @Override
    @NotNull
    public JetSimpleNameExpression getOperationReference() {
        return (JetSimpleNameExpression)this.findChildByType(JetNodeTypes.OPERATION_REFERENCE);
    }

    public IElementType getOperationToken() {
        return this.getOperationReference().getReferencedNameElementType();
    }
}

