/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.stubs.PsiJetAnnotationStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementType;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.psi.stubs.elements.StubIndexServiceFactory;
import org.jetbrains.jet.lang.psi.stubs.impl.PsiJetAnnotationStubImpl;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JetAnnotationElementType
extends JetStubElementType<PsiJetAnnotationStub, JetAnnotationEntry> {
    public JetAnnotationElementType(@NotNull @NonNls String debugName) {
        super(debugName);
    }

    @Override
    public JetAnnotationEntry createPsiFromAst(@NotNull ASTNode node) {
        return new JetAnnotationEntry(node);
    }

    @Override
    public JetAnnotationEntry createPsi(@NotNull PsiJetAnnotationStub stub) {
        return new JetAnnotationEntry(stub);
    }

    @Override
    public PsiJetAnnotationStub createStub(@NotNull JetAnnotationEntry psi, StubElement parentStub) {
        Name shortName = JetPsiUtil.getShortName(psi);
        String resultName = shortName != null ? shortName.asString() : psi.getText();
        return new PsiJetAnnotationStubImpl(parentStub, (IStubElementType)JetStubElementTypes.ANNOTATION_ENTRY, resultName);
    }

    @Override
    public void serialize(PsiJetAnnotationStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getShortName());
    }

    @Override
    public PsiJetAnnotationStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef text = dataStream.readName();
        return new PsiJetAnnotationStubImpl(parentStub, (IStubElementType)JetStubElementTypes.ANNOTATION_ENTRY, text);
    }

    @Override
    public void indexStub(PsiJetAnnotationStub stub, IndexSink sink) {
        StubIndexServiceFactory.getInstance().indexAnnotation(stub, sink);
    }
}

