/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceLikeBuilder;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclarationContainer;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifierList;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedDeclarationStub;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetTypedef;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ImportsResolver;
import org.jetbrains.jet.lang.resolve.ModifiersChecker;
import org.jetbrains.jet.lang.resolve.NamespaceFactoryImpl;
import org.jetbrains.jet.lang.resolve.ScriptHeaderResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WriteThroughScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.utils.DFS;

public class TypeHierarchyResolver {
    @NotNull
    private TopDownAnalysisContext context;
    @NotNull
    private ImportsResolver importsResolver;
    @NotNull
    private DescriptorResolver descriptorResolver;
    @NotNull
    private ScriptHeaderResolver scriptHeaderResolver;
    @NotNull
    private NamespaceFactoryImpl namespaceFactory;
    @NotNull
    private BindingTrace trace;

    public void setContext(@NotNull TopDownAnalysisContext context) {
        this.context = context;
    }

    public void setImportsResolver(@NotNull ImportsResolver importsResolver) {
        this.importsResolver = importsResolver;
    }

    public void setDescriptorResolver(@NotNull DescriptorResolver descriptorResolver) {
        this.descriptorResolver = descriptorResolver;
    }

    public void setScriptHeaderResolver(@NotNull ScriptHeaderResolver scriptHeaderResolver) {
        this.scriptHeaderResolver = scriptHeaderResolver;
    }

    public void setNamespaceFactory(@NotNull NamespaceFactoryImpl namespaceFactory) {
        this.namespaceFactory = namespaceFactory;
    }

    public void setTrace(@NotNull BindingTrace trace) {
        this.trace = trace;
    }

    public void process(@NotNull JetScope outerScope, @NotNull NamespaceLikeBuilder owner, @NotNull Collection<? extends PsiElement> declarations) {
        LinkedList<JetDeclarationContainer> forDeferredResolve = new LinkedList<JetDeclarationContainer>();
        forDeferredResolve.addAll(this.collectNamespacesAndClassifiers(outerScope, owner, declarations));
        while (!forDeferredResolve.isEmpty()) {
            JetDeclarationContainer declarationContainer = (JetDeclarationContainer)forDeferredResolve.poll();
            assert (declarationContainer != null);
            DeclarationDescriptor descriptorForDeferredResolve = this.context.forDeferredResolver.get(declarationContainer);
            JetScope scope = this.context.normalScope.get(declarationContainer);
            if (descriptorForDeferredResolve instanceof MutableClassDescriptorLite) {
                forDeferredResolve.addAll(this.collectNamespacesAndClassifiers(scope, ((MutableClassDescriptorLite)descriptorForDeferredResolve).getBuilder(), declarationContainer.getDeclarations()));
                continue;
            }
            if (descriptorForDeferredResolve instanceof NamespaceDescriptorImpl) {
                forDeferredResolve.addAll(this.collectNamespacesAndClassifiers(scope, ((NamespaceDescriptorImpl)descriptorForDeferredResolve).getBuilder(), declarationContainer.getDeclarations()));
                continue;
            }
            assert (false);
        }
        this.importsResolver.processTypeImports(outerScope);
        this.createTypeConstructors();
        this.resolveTypesInClassHeaders();
        this.context.setClassesTopologicalOrder(this.topologicallySortClassesAndObjects());
        this.detectAndDisconnectLoops();
        this.checkSupertypesForConsistency();
        this.checkTypesInClassHeaders();
    }

    @Nullable
    private Collection<JetDeclarationContainer> collectNamespacesAndClassifiers(@NotNull JetScope outerScope, @NotNull NamespaceLikeBuilder owner, @NotNull Iterable<? extends PsiElement> declarations) {
        ArrayList<JetDeclarationContainer> forDeferredResolve = new ArrayList<JetDeclarationContainer>();
        ClassifierCollector collector = new ClassifierCollector(outerScope, owner, forDeferredResolve);
        for (PsiElement psiElement : declarations) {
            psiElement.accept(collector);
        }
        return forDeferredResolve;
    }

    @NotNull
    private static ClassKind getClassKind(@NotNull JetClass jetClass) {
        if (jetClass.isTrait()) {
            return ClassKind.TRAIT;
        }
        if (jetClass.isAnnotation()) {
            return ClassKind.ANNOTATION_CLASS;
        }
        if (jetClass.isEnum()) {
            return ClassKind.ENUM_CLASS;
        }
        return ClassKind.CLASS;
    }

    private void createTypeConstructors() {
        MutableClassDescriptor descriptor;
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetClass jetClass = entry.getKey();
            descriptor = entry.getValue();
            this.descriptorResolver.resolveMutableClassDescriptor(jetClass, descriptor, this.trace);
            descriptor.createTypeConstructor();
        }
        for (Map.Entry<JetNamedDeclarationStub, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            JetObjectDeclaration objectDeclaration = (JetObjectDeclaration)entry.getKey();
            descriptor = entry.getValue();
            descriptor.setModality(Modality.FINAL);
            descriptor.setVisibility(ModifiersChecker.resolveVisibilityFromModifiers(objectDeclaration));
            descriptor.setTypeParameterDescriptors(new ArrayList<TypeParameterDescriptor>(0));
            descriptor.createTypeConstructor();
        }
    }

    private void resolveTypesInClassHeaders() {
        MutableClassDescriptor descriptor;
        JetClassOrObject jetClass;
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            jetClass = entry.getKey();
            descriptor = entry.getValue();
            this.descriptorResolver.resolveGenericBounds((JetTypeParameterListOwner)((Object)jetClass), descriptor.getScopeForSupertypeResolution(), (List<TypeParameterDescriptorImpl>)descriptor.getTypeConstructor().getParameters(), this.trace);
            this.descriptorResolver.resolveSupertypesForMutableClassDescriptor(jetClass, descriptor, this.trace);
        }
        for (Map.Entry<JetNamedDeclarationStub, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            jetClass = (JetClassOrObject)((Object)entry.getKey());
            descriptor = entry.getValue();
            this.descriptorResolver.resolveSupertypesForMutableClassDescriptor(jetClass, descriptor, this.trace);
        }
    }

    private List<MutableClassDescriptorLite> topologicallySortClassesAndObjects() {
        return DFS.topologicalOrder(ContainerUtil.concat(this.context.getClasses().values(), this.context.getObjects().values()), new DFS.Neighbors<MutableClassDescriptorLite>(){

            @Override
            @NotNull
            public Iterable<MutableClassDescriptorLite> getNeighbors(MutableClassDescriptorLite current) {
                ArrayList<MutableClassDescriptorLite> result = Lists.newArrayList();
                for (JetType supertype : current.getSupertypes()) {
                    ClassifierDescriptor declarationDescriptor = supertype.getConstructor().getDeclarationDescriptor();
                    if (!(declarationDescriptor instanceof MutableClassDescriptorLite)) continue;
                    MutableClassDescriptorLite classDescriptor = (MutableClassDescriptorLite)declarationDescriptor;
                    result.add(classDescriptor);
                }
                return result;
            }
        });
    }

    private void detectAndDisconnectLoops() {
        HashSet<ClassDescriptor> visited = Sets.newHashSet();
        HashSet<ClassDescriptor> beingProcessed = Sets.newHashSet();
        ArrayList<ClassDescriptor> currentPath = Lists.newArrayList();
        for (MutableClassDescriptorLite klass : this.context.getClassesTopologicalOrder()) {
            this.traverseTypeHierarchy(klass, visited, beingProcessed, currentPath);
        }
    }

    private void traverseTypeHierarchy(MutableClassDescriptorLite currentClass, Set<ClassDescriptor> visited, Set<ClassDescriptor> beingProcessed, List<ClassDescriptor> currentPath) {
        if (!visited.add(currentClass)) {
            if (beingProcessed.contains(currentClass)) {
                this.markCycleErrors(currentPath, currentClass);
                assert (!currentPath.isEmpty()) : "Cycle cannot be found on an empty currentPath";
                ClassDescriptor subclassOfCurrent = currentPath.get(currentPath.size() - 1);
                assert (subclassOfCurrent instanceof MutableClassDescriptor);
                Iterator<JetType> iterator = ((MutableClassDescriptor)subclassOfCurrent).getSupertypes().iterator();
                while (iterator.hasNext()) {
                    JetType type = iterator.next();
                    if (type.getConstructor() != currentClass.getTypeConstructor()) continue;
                    iterator.remove();
                    break;
                }
            }
            return;
        }
        beingProcessed.add(currentClass);
        currentPath.add(currentClass);
        for (JetType supertype : Lists.newArrayList(currentClass.getSupertypes())) {
            ClassifierDescriptor declarationDescriptor = supertype.getConstructor().getDeclarationDescriptor();
            if (!(declarationDescriptor instanceof MutableClassDescriptor)) continue;
            MutableClassDescriptor mutableClassDescriptor = (MutableClassDescriptor)declarationDescriptor;
            this.traverseTypeHierarchy(mutableClassDescriptor, visited, beingProcessed, currentPath);
        }
        beingProcessed.remove(currentClass);
        currentPath.remove(currentPath.size() - 1);
    }

    private void markCycleErrors(List<ClassDescriptor> currentPath, @NotNull ClassDescriptor current) {
        int size = currentPath.size();
        for (int i = size - 1; i >= 0; --i) {
            PsiNameIdentifierOwner namedElement;
            PsiElement nameIdentifier;
            ClassDescriptor classDescriptor = currentPath.get(i);
            ClassDescriptor superclass = i < size - 1 ? currentPath.get(i + 1) : current;
            PsiElement psiElement = BindingContextUtils.classDescriptorToDeclaration(this.trace.getBindingContext(), classDescriptor);
            PsiElement elementToMark = null;
            if (psiElement instanceof JetClassOrObject) {
                JetClassOrObject classOrObject = (JetClassOrObject)psiElement;
                for (JetDelegationSpecifier delegationSpecifier : classOrObject.getDelegationSpecifiers()) {
                    JetType supertype;
                    JetTypeReference typeReference = delegationSpecifier.getTypeReference();
                    if (typeReference == null || (supertype = this.trace.get(BindingContext.TYPE, typeReference)) == null || supertype.getConstructor() != superclass.getTypeConstructor()) continue;
                    elementToMark = typeReference;
                }
            }
            if (elementToMark == null && psiElement instanceof PsiNameIdentifierOwner && (nameIdentifier = (namedElement = (PsiNameIdentifierOwner)psiElement).getNameIdentifier()) != null) {
                elementToMark = nameIdentifier;
            }
            if (elementToMark != null) {
                this.trace.report(Errors.CYCLIC_INHERITANCE_HIERARCHY.on(elementToMark));
            }
            if (classDescriptor == current) break;
        }
    }

    private void checkSupertypesForConsistency() {
        for (MutableClassDescriptorLite mutableClassDescriptor : this.context.getClassesTopologicalOrder()) {
            Multimap<TypeConstructor, TypeProjection> multimap = SubstitutionUtils.buildDeepSubstitutionMultimap(mutableClassDescriptor.getDefaultType());
            for (Map.Entry<TypeConstructor, Collection<TypeProjection>> entry : multimap.asMap().entrySet()) {
                Collection<TypeProjection> projections = entry.getValue();
                if (projections.size() <= 1) continue;
                TypeConstructor typeConstructor = entry.getKey();
                ClassifierDescriptor declarationDescriptor = typeConstructor.getDeclarationDescriptor();
                assert (declarationDescriptor instanceof TypeParameterDescriptor) : declarationDescriptor;
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)declarationDescriptor;
                LinkedHashSet<JetType> conflictingTypes = Sets.newLinkedHashSet();
                for (TypeProjection projection : projections) {
                    conflictingTypes.add(projection.getType());
                }
                switch (typeParameterDescriptor.getVariance()) {
                    case INVARIANT: {
                        break;
                    }
                    case IN_VARIANCE: {
                        Filter.REMOVE_IF_SUPERTYPE_IN_THE_SET.proceed(conflictingTypes);
                        break;
                    }
                    case OUT_VARIANCE: {
                        Filter.REMOVE_IF_SUBTYPE_IN_THE_SET.proceed(conflictingTypes);
                    }
                }
                if (conflictingTypes.size() <= 1) continue;
                DeclarationDescriptor containingDeclaration = typeParameterDescriptor.getContainingDeclaration();
                assert (containingDeclaration instanceof ClassDescriptor) : containingDeclaration;
                JetClassOrObject psiElement = (JetClassOrObject)BindingContextUtils.classDescriptorToDeclaration(this.trace.getBindingContext(), mutableClassDescriptor);
                JetDelegationSpecifierList delegationSpecifierList = psiElement.getDelegationSpecifierList();
                assert (delegationSpecifierList != null);
                this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on(delegationSpecifierList, typeParameterDescriptor, (ClassDescriptor)containingDeclaration, conflictingTypes));
            }
        }
    }

    private void checkTypesInClassHeaders() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetTypeReference extendsBound;
            JetType type;
            JetClass jetClass = entry.getKey();
            for (JetDelegationSpecifier delegationSpecifier : jetClass.getDelegationSpecifiers()) {
                JetTypeReference typeReference = delegationSpecifier.getTypeReference();
                if (typeReference == null || (type = this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)) == null) continue;
                DescriptorResolver.checkBounds(typeReference, type, this.trace);
            }
            for (JetTypeParameter jetTypeParameter : jetClass.getTypeParameters()) {
                extendsBound = jetTypeParameter.getExtendsBound();
                if (extendsBound == null || (type = this.trace.getBindingContext().get(BindingContext.TYPE, extendsBound)) == null) continue;
                DescriptorResolver.checkBounds(extendsBound, type, this.trace);
            }
            for (JetTypeConstraint constraint : jetClass.getTypeConstraints()) {
                extendsBound = constraint.getBoundTypeReference();
                if (extendsBound == null || (type = this.trace.getBindingContext().get(BindingContext.TYPE, extendsBound)) == null) continue;
                DescriptorResolver.checkBounds(extendsBound, type, this.trace);
            }
        }
    }

    private class ClassifierCollector
    extends JetVisitorVoid {
        private final JetScope outerScope;
        private final NamespaceLikeBuilder owner;
        private final Collection<JetDeclarationContainer> forDeferredResolve;

        public ClassifierCollector(@NotNull JetScope outerScope, @NotNull NamespaceLikeBuilder owner, @NotNull Collection<JetDeclarationContainer> forDeferredResolve) {
            this.outerScope = outerScope;
            this.owner = owner;
            this.forDeferredResolve = forDeferredResolve;
        }

        @Override
        public void visitJetFile(JetFile file) {
            NamespaceDescriptorImpl namespaceDescriptor = TypeHierarchyResolver.this.namespaceFactory.createNamespaceDescriptorPathIfNeeded(file, this.outerScope, RedeclarationHandler.DO_NOTHING);
            TypeHierarchyResolver.this.context.getNamespaceDescriptors().put(file, namespaceDescriptor);
            WriteThroughScope namespaceScope = new WriteThroughScope(this.outerScope, namespaceDescriptor.getMemberScope(), new TraceBasedRedeclarationHandler(TypeHierarchyResolver.this.trace), "namespace");
            namespaceScope.changeLockLevel(WritableScope.LockLevel.BOTH);
            TypeHierarchyResolver.this.context.getNamespaceScopes().put(file, namespaceScope);
            if (file.isScript()) {
                TypeHierarchyResolver.this.scriptHeaderResolver.processScriptHierarchy(file.getScript(), namespaceScope);
            }
            this.prepareForDeferredCall(namespaceScope, namespaceDescriptor, file);
        }

        @Override
        public void visitClass(JetClass klass) {
            MutableClassDescriptor mutableClassDescriptor = this.createClassDescriptorForClass(klass, this.owner.getOwnerForChildren());
            this.owner.addClassifierDescriptor(mutableClassDescriptor);
        }

        @Override
        public void visitObjectDeclaration(JetObjectDeclaration declaration) {
            MutableClassDescriptor objectDescriptor = this.createClassDescriptorForObject(declaration, this.owner, this.outerScope, JetPsiUtil.safeName(declaration.getName()), ClassKind.OBJECT);
            this.owner.addObjectDescriptor(objectDescriptor);
            TypeHierarchyResolver.this.trace.record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, JetPsiUtil.getFQName(declaration), objectDescriptor);
        }

        @Override
        public void visitEnumEntry(JetEnumEntry enumEntry) {
            MutableClassDescriptorLite ownerClassDescriptor = (MutableClassDescriptorLite)this.owner.getOwnerForChildren();
            MutableClassDescriptorLite classObjectDescriptor = ownerClassDescriptor.getClassObjectDescriptor();
            assert (classObjectDescriptor != null) : enumEntry.getParent().getText();
            this.createClassDescriptorForEnumEntry(enumEntry, classObjectDescriptor);
        }

        @Override
        public void visitTypedef(JetTypedef typedef) {
            TypeHierarchyResolver.this.trace.report(Errors.UNSUPPORTED.on(typedef, "TypeHierarchyResolver"));
        }

        @Override
        public void visitClassObject(JetClassObject classObject) {
            JetObjectDeclaration objectDeclaration = classObject.getObjectDeclaration();
            if (objectDeclaration != null) {
                Name classObjectName = DescriptorUtils.getClassObjectName(this.owner.getOwnerForChildren().getName());
                MutableClassDescriptor classObjectDescriptor = this.createClassDescriptorForObject(objectDeclaration, this.owner, this.outerScope, classObjectName, ClassKind.CLASS_OBJECT);
                NamespaceLikeBuilder.ClassObjectStatus status = this.owner.setClassObjectDescriptor(classObjectDescriptor);
                switch (status) {
                    case DUPLICATE: {
                        TypeHierarchyResolver.this.trace.report(Errors.MANY_CLASS_OBJECTS.on(classObject));
                        break;
                    }
                    case NOT_ALLOWED: {
                        TypeHierarchyResolver.this.trace.report(Errors.CLASS_OBJECT_NOT_ALLOWED.on(classObject));
                        break;
                    }
                }
            }
        }

        private void createClassObjectForEnumClass(JetClass klass, MutableClassDescriptor mutableClassDescriptor) {
            if (mutableClassDescriptor.getKind() == ClassKind.ENUM_CLASS) {
                MutableClassDescriptor classObjectDescriptor = this.createClassObjectDescriptor(mutableClassDescriptor, ModifiersChecker.resolveVisibilityFromModifiers(klass));
                mutableClassDescriptor.getBuilder().setClassObjectDescriptor(classObjectDescriptor);
                classObjectDescriptor.getBuilder().addFunctionDescriptor(DescriptorResolver.createEnumClassObjectValuesMethod(classObjectDescriptor, TypeHierarchyResolver.this.trace));
                classObjectDescriptor.getBuilder().addFunctionDescriptor(DescriptorResolver.createEnumClassObjectValueOfMethod(classObjectDescriptor, TypeHierarchyResolver.this.trace));
            }
        }

        @NotNull
        private MutableClassDescriptor createClassObjectDescriptor(@NotNull ClassDescriptor classDescriptor, @NotNull Visibility visibility) {
            MutableClassDescriptor classObjectDescriptor = new MutableClassDescriptor(classDescriptor, this.outerScope, ClassKind.CLASS_OBJECT, false, DescriptorUtils.getClassObjectName(classDescriptor.getName()));
            classObjectDescriptor.setModality(Modality.FINAL);
            classObjectDescriptor.setVisibility(visibility);
            classObjectDescriptor.setTypeParameterDescriptors(new ArrayList<TypeParameterDescriptor>(0));
            classObjectDescriptor.createTypeConstructor();
            ConstructorDescriptorImpl primaryConstructorForObject = this.createPrimaryConstructorForObject(null, classObjectDescriptor);
            primaryConstructorForObject.setReturnType(classObjectDescriptor.getDefaultType());
            return classObjectDescriptor;
        }

        @NotNull
        private MutableClassDescriptor createClassDescriptorForClass(@NotNull JetClass klass, @NotNull DeclarationDescriptor containingDeclaration) {
            ClassKind kind = TypeHierarchyResolver.getClassKind(klass);
            boolean isInner = kind == ClassKind.CLASS && klass.isInner();
            MutableClassDescriptor mutableClassDescriptor = new MutableClassDescriptor(containingDeclaration, this.outerScope, kind, isInner, JetPsiUtil.safeName(klass.getName()));
            TypeHierarchyResolver.this.context.getClasses().put(klass, mutableClassDescriptor);
            TypeHierarchyResolver.this.trace.record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, JetPsiUtil.getFQName(klass), mutableClassDescriptor);
            this.createClassObjectForEnumClass(klass, mutableClassDescriptor);
            JetScope classScope = mutableClassDescriptor.getScopeForMemberResolution();
            this.prepareForDeferredCall(classScope, mutableClassDescriptor, klass);
            return mutableClassDescriptor;
        }

        @NotNull
        private MutableClassDescriptor createClassDescriptorForObject(@NotNull JetObjectDeclaration declaration, @NotNull NamespaceLikeBuilder owner, @NotNull JetScope scope, @NotNull Name name, @NotNull ClassKind kind) {
            MutableClassDescriptor mutableClassDescriptor = new MutableClassDescriptor(owner.getOwnerForChildren(), scope, kind, false, name);
            TypeHierarchyResolver.this.context.getObjects().put(declaration, mutableClassDescriptor);
            JetScope classScope = mutableClassDescriptor.getScopeForMemberResolution();
            this.prepareForDeferredCall(classScope, mutableClassDescriptor, declaration);
            this.createPrimaryConstructorForObject(declaration, mutableClassDescriptor);
            TypeHierarchyResolver.this.trace.record(BindingContext.CLASS, declaration, mutableClassDescriptor);
            return mutableClassDescriptor;
        }

        private MutableClassDescriptor createClassDescriptorForEnumEntry(@NotNull JetEnumEntry declaration, @NotNull MutableClassDescriptorLite classObjectDescriptor) {
            NamespaceLikeBuilder owner = classObjectDescriptor.getBuilder();
            MutableClassDescriptor mutableClassObjectDescriptor = (MutableClassDescriptor)classObjectDescriptor;
            MutableClassDescriptor mutableClassDescriptor = new MutableClassDescriptor(owner.getOwnerForChildren(), mutableClassObjectDescriptor.getScopeForMemberResolution(), ClassKind.ENUM_ENTRY, false, JetPsiUtil.safeName(declaration.getName()));
            TypeHierarchyResolver.this.context.getClasses().put(declaration, mutableClassDescriptor);
            this.prepareForDeferredCall(mutableClassDescriptor.getScopeForMemberResolution(), mutableClassDescriptor, declaration);
            this.createPrimaryConstructorForObject(declaration, mutableClassDescriptor);
            owner.addObjectDescriptor(mutableClassDescriptor);
            TypeHierarchyResolver.this.trace.record(BindingContext.CLASS, declaration, mutableClassDescriptor);
            return mutableClassDescriptor;
        }

        private ConstructorDescriptorImpl createPrimaryConstructorForObject(@Nullable PsiElement object, MutableClassDescriptor mutableClassDescriptor) {
            ConstructorDescriptorImpl constructorDescriptor = DescriptorResolver.createAndRecordPrimaryConstructorForObject(object, mutableClassDescriptor, TypeHierarchyResolver.this.trace);
            mutableClassDescriptor.setPrimaryConstructor(constructorDescriptor, TypeHierarchyResolver.this.trace);
            return constructorDescriptor;
        }

        private void prepareForDeferredCall(@NotNull JetScope outerScope, @NotNull DeclarationDescriptor descriptorForDeferredResolve, @NotNull JetDeclarationContainer container) {
            this.forDeferredResolve.add(container);
            ((TypeHierarchyResolver)TypeHierarchyResolver.this).context.normalScope.put(container, outerScope);
            ((TypeHierarchyResolver)TypeHierarchyResolver.this).context.forDeferredResolver.put(container, descriptorForDeferredResolve);
        }
    }

    private static enum Filter {
        REMOVE_IF_SUBTYPE_IN_THE_SET{

            @Override
            public boolean removeNeeded(JetType subject, JetType other) {
                return JetTypeChecker.INSTANCE.isSubtypeOf(other, subject);
            }
        }
        ,
        REMOVE_IF_SUPERTYPE_IN_THE_SET{

            @Override
            public boolean removeNeeded(JetType subject, JetType other) {
                return JetTypeChecker.INSTANCE.isSubtypeOf(subject, other);
            }
        };


        private void proceed(Set<JetType> conflictingTypes) {
            Iterator<JetType> iterator = conflictingTypes.iterator();
            block0: while (iterator.hasNext()) {
                JetType type = iterator.next();
                for (JetType otherType : conflictingTypes) {
                    boolean subtypeOf = this.removeNeeded(type, otherType);
                    if (type == otherType || !subtypeOf) continue;
                    iterator.remove();
                    continue block0;
                }
            }
        }

        public abstract boolean removeNeeded(JetType var1, JetType var2);
    }
}

