/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class EnumValue
implements CompileTimeConstant<PropertyDescriptor> {
    private final PropertyDescriptor value;

    public EnumValue(@NotNull PropertyDescriptor value) {
        this.value = value;
    }

    @Override
    @NotNull
    public PropertyDescriptor getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
        return this.value.getType();
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data) {
        return visitor.visitEnumValue(this, data);
    }

    public String toString() {
        return this.value.getType() + "." + this.value.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumValue enumValue = (EnumValue)o;
        return this.value.equals(enumValue.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

