/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetFunctionType;
import org.jetbrains.jet.lang.psi.JetNullableType;
import org.jetbrains.jet.lang.psi.JetProjectionKind;
import org.jetbrains.jet.lang.psi.JetSelfType;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.java.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.KotlinToJavaTypesMap;
import org.jetbrains.jet.lang.resolve.java.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.AlternativeSignatureMismatchException;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public class TypeTransformingVisitor
extends JetVisitor<JetType, Void> {
    private static boolean strictMode = false;
    private final JetType originalType;
    private final Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters;
    private final TypeUsage typeUsage;

    private TypeTransformingVisitor(JetType originalType, Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters, TypeUsage typeUsage) {
        this.originalType = originalType;
        this.typeUsage = typeUsage;
        this.originalToAltTypeParameters = Collections.unmodifiableMap(originalToAltTypeParameters);
    }

    @NotNull
    public static JetType computeType(@NotNull JetTypeElement alternativeTypeElement, @NotNull JetType originalType, @NotNull Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> originalToAltTypeParameters, @NotNull TypeUsage typeUsage) {
        JetType computedType = alternativeTypeElement.accept(new TypeTransformingVisitor(originalType, originalToAltTypeParameters, typeUsage), null);
        assert (computedType != null);
        return computedType;
    }

    @Override
    public JetType visitNullableType(JetNullableType nullableType, Void aVoid) {
        if (!this.originalType.isNullable() && this.typeUsage != TypeUsage.TYPE_ARGUMENT) {
            throw new AlternativeSignatureMismatchException("Auto type '%s' is not-null, while type in alternative signature is nullable: '%s'", DescriptorRenderer.TEXT.renderType(this.originalType), nullableType.getText());
        }
        return TypeUtils.makeNullable(TypeTransformingVisitor.computeType(nullableType.getInnerType(), this.originalType, this.originalToAltTypeParameters, this.typeUsage));
    }

    @Override
    public JetType visitFunctionType(JetFunctionType type, Void data) {
        return this.visitCommonType(type.getReceiverTypeRef() == null ? KotlinBuiltIns.getInstance().getFunction(type.getParameters().size()) : KotlinBuiltIns.getInstance().getExtensionFunction(type.getParameters().size()), (JetTypeElement)type);
    }

    @Override
    public JetType visitUserType(JetUserType type, Void data) {
        JetUserType qualifier = type.getQualifier();
        String shortName = type.getReferenceExpression().getReferencedName();
        String longName = (qualifier == null ? "" : qualifier.getText() + ".") + shortName;
        return this.visitCommonType(longName, (JetTypeElement)type);
    }

    private JetType visitCommonType(@NotNull ClassDescriptor classDescriptor, @NotNull JetTypeElement type) {
        return this.visitCommonType(DescriptorUtils.getFQName(classDescriptor).toSafe().asString(), type);
    }

    private JetType visitCommonType(@NotNull String qualifiedName, @NotNull JetTypeElement type) {
        JetScope memberScope;
        List<TypeProjection> arguments;
        TypeConstructor originalTypeConstructor = this.originalType.getConstructor();
        ClassifierDescriptor declarationDescriptor = originalTypeConstructor.getDeclarationDescriptor();
        assert (declarationDescriptor != null);
        String fqName = DescriptorUtils.getFQName(declarationDescriptor).toSafe().asString();
        ClassDescriptor classFromLibrary = this.getAutoTypeAnalogWithinBuiltins(qualifiedName);
        if (!TypeTransformingVisitor.isSameName(qualifiedName, fqName) && classFromLibrary == null) {
            throw new AlternativeSignatureMismatchException("Alternative signature type mismatch, expected: %s, actual: %s", qualifiedName, fqName);
        }
        TypeConstructor typeConstructor = classFromLibrary != null ? classFromLibrary.getTypeConstructor() : originalTypeConstructor;
        ClassifierDescriptor typeConstructorClassifier = typeConstructor.getDeclarationDescriptor();
        if (typeConstructorClassifier instanceof TypeParameterDescriptor && this.originalToAltTypeParameters.containsKey(typeConstructorClassifier)) {
            typeConstructor = this.originalToAltTypeParameters.get(typeConstructorClassifier).getTypeConstructor();
        }
        if ((arguments = this.originalType.getArguments()).size() != type.getTypeArgumentsAsTypes().size()) {
            throw new AlternativeSignatureMismatchException("'%s' type in method signature has %d type arguments, while '%s' in alternative signature has %d of them", DescriptorRenderer.TEXT.renderType(this.originalType), arguments.size(), type.getText(), type.getTypeArgumentsAsTypes().size());
        }
        ArrayList<TypeProjection> altArguments = new ArrayList<TypeProjection>();
        int size = arguments.size();
        for (int i = 0; i < size; ++i) {
            altArguments.add(this.getAltArgument(type, typeConstructor, i, arguments.get(i)));
        }
        if (typeConstructorClassifier instanceof TypeParameterDescriptor) {
            memberScope = ((TypeParameterDescriptor)typeConstructorClassifier).getUpperBoundsAsType().getMemberScope();
        } else if (typeConstructorClassifier instanceof ClassDescriptor) {
            memberScope = ((ClassDescriptor)typeConstructorClassifier).getMemberScope(altArguments);
        } else {
            throw new AssertionError((Object)("Unexpected class of type constructor classifier " + (typeConstructorClassifier == null ? "null" : typeConstructorClassifier.getClass().getName())));
        }
        return new JetTypeImpl(this.originalType.getAnnotations(), typeConstructor, false, altArguments, memberScope);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private TypeProjection getAltArgument(@NotNull JetTypeElement type, @NotNull TypeConstructor typeConstructor, int i, @NotNull TypeProjection originalArgument) {
        Variance altProjectionKind;
        JetTypeReference typeReference = type.getTypeArgumentsAsTypes().get(i);
        if (typeReference == null) {
            assert (type instanceof JetUserType && ((JetUserType)type).getTypeArguments().get(i).getProjectionKind() == JetProjectionKind.STAR);
            return originalArgument;
        }
        JetTypeElement argumentAlternativeTypeElement = typeReference.getTypeElement();
        assert (argumentAlternativeTypeElement != null);
        TypeParameterDescriptor parameter = typeConstructor.getParameters().get(i);
        JetType alternativeArgumentType = TypeTransformingVisitor.computeType(argumentAlternativeTypeElement, originalArgument.getType(), this.originalToAltTypeParameters, TypeUsage.TYPE_ARGUMENT);
        Variance projectionKind = originalArgument.getProjectionKind();
        if (type instanceof JetUserType) {
            JetTypeProjection typeProjection = ((JetUserType)type).getTypeArguments().get(i);
            altProjectionKind = TypeResolver.resolveProjectionKind(typeProjection.getProjectionKind());
            if (altProjectionKind != projectionKind && projectionKind != Variance.INVARIANT) {
                throw new AlternativeSignatureMismatchException("Projection kind mismatch, actual: %s, in alternative signature: %s", new Object[]{projectionKind, altProjectionKind});
            }
            if (altProjectionKind == Variance.INVARIANT || parameter.getVariance() == Variance.INVARIANT) return new TypeProjection(altProjectionKind, alternativeArgumentType);
            if (altProjectionKind != parameter.getVariance()) throw new AlternativeSignatureMismatchException("Projection kind '%s' is conflicting with variance of %s", new Object[]{altProjectionKind, DescriptorUtils.getFQName(typeConstructor.getDeclarationDescriptor())});
            if (strictMode) {
                throw new AlternativeSignatureMismatchException("Projection kind '%s' is redundant", new Object[]{altProjectionKind, DescriptorUtils.getFQName(typeConstructor.getDeclarationDescriptor())});
            }
            altProjectionKind = projectionKind;
            return new TypeProjection(altProjectionKind, alternativeArgumentType);
        } else {
            altProjectionKind = projectionKind;
        }
        return new TypeProjection(altProjectionKind, alternativeArgumentType);
    }

    @Nullable
    private ClassDescriptor getAutoTypeAnalogWithinBuiltins(String qualifiedName) {
        Type javaAnalog = KotlinToJavaTypesMap.getInstance().getJavaAnalog(this.originalType);
        if (javaAnalog == null || javaAnalog.getSort() != 10) {
            return null;
        }
        Collection<ClassDescriptor> descriptors = JavaToKotlinClassMap.getInstance().mapPlatformClass(JvmClassName.byType(javaAnalog).getFqName());
        for (ClassDescriptor descriptor : descriptors) {
            String fqName = DescriptorUtils.getFQName(descriptor).asString();
            if (!TypeTransformingVisitor.isSameName(qualifiedName, fqName)) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public JetType visitSelfType(JetSelfType type, Void data) {
        throw new UnsupportedOperationException("Self-types are not supported yet");
    }

    private static boolean isSameName(String qualifiedName, String fullyQualifiedName) {
        return fullyQualifiedName.equals(qualifiedName) || fullyQualifiedName.endsWith("." + qualifiedName);
    }

    public static void setStrictMode(boolean strictMode) {
        TypeTransformingVisitor.strictMode = strictMode;
    }
}

