/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kt;

import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;

public class DescriptorKindUtils {
    private DescriptorKindUtils() {
    }

    public static int kindToFlags(CallableMemberDescriptor.Kind kind) {
        switch (kind) {
            case DECLARATION: {
                return 0;
            }
            case FAKE_OVERRIDE: {
                return 64;
            }
            case DELEGATION: {
                return 128;
            }
            case SYNTHESIZED: {
                return 192;
            }
        }
        throw new IllegalArgumentException("Unknown kind: " + (Object)((Object)kind));
    }

    public static CallableMemberDescriptor.Kind flagsToKind(int value) {
        switch (value & 0x1C0) {
            case 0: {
                return CallableMemberDescriptor.Kind.DECLARATION;
            }
            case 64: {
                return CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
            }
            case 128: {
                return CallableMemberDescriptor.Kind.DELEGATION;
            }
            case 192: {
                return CallableMemberDescriptor.Kind.SYNTHESIZED;
            }
        }
        throw new IllegalArgumentException("Unknown int value of kind: " + value);
    }
}

