/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class JavaMethodSignatureUtil {
    static boolean isMethodReturnTypeCompatible(@NotNull PsiMethod method) {
        if (method.hasModifierProperty("static")) {
            return true;
        }
        HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
        List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
        PsiType returnType = methodSignature.getSubstitutor().substitute(method.getReturnType());
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        for (HierarchicalMethodSignature superMethodSignature : superSignatures) {
            PsiClass superClass;
            PsiType declaredReturnType;
            PsiMethod superMethod = superMethodSignature.getMethod();
            PsiType superReturnType = declaredReturnType = superMethod.getReturnType();
            if (superMethodSignature.isRaw()) {
                superReturnType = TypeConversionUtil.erasure(declaredReturnType);
            }
            if (returnType == null || superReturnType == null || method == superMethod || (superClass = superMethod.getContainingClass()) == null || JavaMethodSignatureUtil.areMethodsReturnTypesCompatible(superMethodSignature, superReturnType, method, methodSignature, returnType)) continue;
            return false;
        }
        return true;
    }

    private static boolean areMethodsReturnTypesCompatible(MethodSignatureBackedByPsiMethod superMethodSignature, PsiType superReturnType, PsiMethod method, MethodSignatureBackedByPsiMethod methodSignature, PsiType returnType) {
        PsiSubstitutor unifyingSubstitutor;
        if (superReturnType == null) {
            return false;
        }
        boolean isJdk15 = PsiUtil.isLanguageLevel5OrHigher(method);
        PsiType substitutedSuperReturnType = isJdk15 && !superMethodSignature.isRaw() && superMethodSignature.equals(methodSignature) ? ((unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(methodSignature, superMethodSignature)) == null ? superReturnType : unifyingSubstitutor.substitute(superReturnType)) : TypeConversionUtil.erasure(superMethodSignature.getSubstitutor().substitute(superReturnType));
        if (returnType.equals(substitutedSuperReturnType)) {
            return true;
        }
        return !(returnType instanceof PsiPrimitiveType) && substitutedSuperReturnType.getDeepComponentType() instanceof PsiClassType && isJdk15 && TypeConversionUtil.isAssignable(substitutedSuperReturnType, returnType);
    }

    private JavaMethodSignatureUtil() {
    }
}

