/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicates;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.di.InjectorForBodyResolve;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifierList;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.BodyResolver;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.jet.lang.resolve.lazy.LazyDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.ScopeProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.NameUtils;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.TypeConstructor;

class ResolveElementCache {
    private static final BodyResolveContextForLazy EMPTY_CONTEXT = new BodyResolveContextForLazy(Functions.constant(null));
    private final ResolveSession resolveSession;
    private final MemoizedFunctionToNotNull<JetElement, BindingContext> resolveElementCache;

    ResolveElementCache(ResolveSession resolveSession) {
        this.resolveSession = resolveSession;
        this.resolveElementCache = resolveSession.getStorageManager().createMemoizedFunction(new com.intellij.util.Function<JetElement, BindingContext>(){

            @Override
            public BindingContext fun(JetElement namedFunction) {
                return ResolveElementCache.this.computeResolveElement(namedFunction);
            }
        }, StorageManager.ReferenceKind.WEAK);
    }

    @NotNull
    BindingContext resolveElement(@NotNull JetElement jetElement) {
        return this.resolveElementCache.fun(jetElement);
    }

    @NotNull
    private BindingContext computeResolveElement(@NotNull JetElement jetElement) {
        PsiElement resolveElement = JetPsiUtil.getTopmostParentOfTypes(jetElement, JetNamedFunction.class, JetClassInitializer.class, JetProperty.class, JetDelegationSpecifierList.class, JetImportDirective.class, JetAnnotationEntry.class, JetTypeParameter.class, JetTypeConstraint.class, JetNamespaceHeader.class);
        if (resolveElement != null) {
            BindingTrace trace = this.resolveSession.getStorageManager().createSafeTrace(new DelegatingBindingTrace(this.resolveSession.getBindingContext(), "trace to resolve element", jetElement));
            JetFile file = (JetFile)jetElement.getContainingFile();
            if (resolveElement instanceof JetNamedFunction) {
                ResolveElementCache.functionAdditionalResolve(this.resolveSession, (JetNamedFunction)resolveElement, trace, file);
            } else if (resolveElement instanceof JetClassInitializer) {
                ResolveElementCache.initializerAdditionalResolve(this.resolveSession, (JetClassInitializer)resolveElement, trace, file);
            } else if (resolveElement instanceof JetProperty) {
                ResolveElementCache.propertyAdditionalResolve(this.resolveSession, (JetProperty)resolveElement, trace, file);
            } else if (resolveElement instanceof JetDelegationSpecifierList) {
                ResolveElementCache.delegationSpecifierAdditionalResolve(this.resolveSession, (JetDelegationSpecifierList)resolveElement, trace, file);
            } else if (resolveElement instanceof JetImportDirective) {
                JetImportDirective importDirective = (JetImportDirective)resolveElement;
                JetScope scope = this.resolveSession.getInjector().getScopeProvider().getFileScope((JetFile)importDirective.getContainingFile());
                scope.getAllDescriptors();
            } else if (resolveElement instanceof JetAnnotationEntry) {
                ResolveElementCache.annotationAdditionalResolve(this.resolveSession, (JetAnnotationEntry)resolveElement);
            } else if (resolveElement instanceof JetTypeParameter) {
                ResolveElementCache.typeParameterAdditionalResolve(this.resolveSession, (JetTypeParameter)resolveElement);
            } else if (resolveElement instanceof JetTypeConstraint) {
                ResolveElementCache.typeConstraintAdditionalResolve(this.resolveSession, jetElement);
            } else if (resolveElement instanceof JetNamespaceHeader) {
                ResolveElementCache.namespaceRefAdditionalResolve(this.resolveSession, (JetNamespaceHeader)resolveElement, trace, jetElement);
            } else assert (false) : "Invalid type of the topmost parent";
            return trace.getBindingContext();
        }
        JetDeclaration declaration = PsiTreeUtil.getParentOfType((PsiElement)jetElement, JetDeclaration.class, false);
        if (declaration != null) {
            this.resolveSession.resolveToDescriptor(declaration);
        }
        return this.resolveSession.getBindingContext();
    }

    private static void namespaceRefAdditionalResolve(ResolveSession resolveSession, JetNamespaceHeader header, BindingTrace trace, JetElement jetElement) {
        if (jetElement instanceof JetSimpleNameExpression) {
            Name name;
            JetScope scope;
            JetSimpleNameExpression packageNameExpression = (JetSimpleNameExpression)jetElement;
            if (trace.getBindingContext().get(BindingContext.RESOLUTION_SCOPE, packageNameExpression) == null && (scope = ResolveElementCache.getExpressionMemberScope(resolveSession, packageNameExpression)) != null) {
                trace.record(BindingContext.RESOLUTION_SCOPE, packageNameExpression, scope);
            }
            if (NameUtils.isValidIdentified((name = packageNameExpression.getReferencedNameAsName()).asString()) && trace.getBindingContext().get(BindingContext.REFERENCE_TARGET, packageNameExpression) == null) {
                FqName fqName = header.getParentFqName(packageNameExpression).child(name);
                NamespaceDescriptor packageDescriptor = resolveSession.getPackageDescriptorByFqName(fqName);
                assert (packageDescriptor != null) : "Package descriptor should be present in session for " + fqName;
                trace.record(BindingContext.REFERENCE_TARGET, packageNameExpression, packageDescriptor);
            }
        }
    }

    private static void typeConstraintAdditionalResolve(KotlinCodeAnalyzer analyzer, JetElement jetElement) {
        JetDeclaration declaration = PsiTreeUtil.getParentOfType((PsiElement)jetElement, JetDeclaration.class);
        DeclarationDescriptor descriptor = analyzer.resolveToDescriptor(declaration);
        assert (descriptor instanceof ClassDescriptor);
        TypeConstructor constructor = ((ClassDescriptor)descriptor).getTypeConstructor();
        for (TypeParameterDescriptor parameterDescriptor : constructor.getParameters()) {
            LazyDescriptor lazyDescriptor = (LazyDescriptor)((Object)parameterDescriptor);
            lazyDescriptor.forceResolveAllContents();
        }
    }

    private static void annotationAdditionalResolve(KotlinCodeAnalyzer analyzer, JetAnnotationEntry jetAnnotationEntry) {
        JetDeclaration declaration = PsiTreeUtil.getParentOfType((PsiElement)jetAnnotationEntry, JetDeclaration.class);
        if (declaration != null) {
            DeclarationDescriptor descriptor = analyzer.resolveToDescriptor(declaration);
            descriptor.getAnnotations();
        }
    }

    private static void typeParameterAdditionalResolve(KotlinCodeAnalyzer analyzer, JetTypeParameter typeParameter) {
        DeclarationDescriptor descriptor = analyzer.resolveToDescriptor(typeParameter);
        assert (descriptor instanceof LazyDescriptor);
        LazyDescriptor parameterDescriptor = (LazyDescriptor)((Object)descriptor);
        parameterDescriptor.forceResolveAllContents();
    }

    private static void delegationSpecifierAdditionalResolve(KotlinCodeAnalyzer analyzer, JetDelegationSpecifierList specifier, BindingTrace trace, JetFile file) {
        BodyResolver bodyResolver = ResolveElementCache.createBodyResolverWithEmptyContext(trace, file, analyzer.getRootModuleDescriptor());
        JetClassOrObject classOrObject = (JetClassOrObject)specifier.getParent();
        LazyClassDescriptor descriptor = (LazyClassDescriptor)analyzer.resolveToDescriptor(classOrObject);
        descriptor.getTypeConstructor().getSupertypes();
        bodyResolver.resolveDelegationSpecifierList(classOrObject, descriptor, descriptor.getUnsubstitutedPrimaryConstructor(), descriptor.getScopeForClassHeaderResolution(), descriptor.getScopeForMemberDeclarationResolution());
    }

    private static void propertyAdditionalResolve(ResolveSession resolveSession, final JetProperty jetProperty, BindingTrace trace, JetFile file) {
        JetExpression propertyDelegate;
        final JetScope propertyResolutionScope = resolveSession.getInjector().getScopeProvider().getResolutionScopeForDeclaration(jetProperty);
        BodyResolveContextForLazy bodyResolveContext = new BodyResolveContextForLazy(new Function<JetDeclaration, JetScope>(){

            @Override
            public JetScope apply(JetDeclaration declaration) {
                assert (declaration.getParent() == jetProperty) : "Must be called only for property accessors, but called for " + declaration;
                return propertyResolutionScope;
            }
        });
        BodyResolver bodyResolver = ResolveElementCache.createBodyResolver(trace, file, bodyResolveContext, resolveSession.getRootModuleDescriptor());
        PropertyDescriptor descriptor = (PropertyDescriptor)resolveSession.resolveToDescriptor(jetProperty);
        JetExpression propertyInitializer = jetProperty.getInitializer();
        if (propertyInitializer != null) {
            bodyResolver.resolvePropertyInitializer(jetProperty, descriptor, propertyInitializer, propertyResolutionScope);
        }
        if ((propertyDelegate = jetProperty.getDelegateExpression()) != null) {
            bodyResolver.resolvePropertyDelegate(jetProperty, descriptor, propertyDelegate, propertyResolutionScope, propertyResolutionScope);
        }
        bodyResolver.resolvePropertyAccessors(jetProperty, descriptor);
    }

    private static void functionAdditionalResolve(ResolveSession resolveSession, JetNamedFunction namedFunction, BindingTrace trace, JetFile file) {
        BodyResolver bodyResolver = ResolveElementCache.createBodyResolverWithEmptyContext(trace, file, resolveSession.getRootModuleDescriptor());
        JetScope scope = resolveSession.getInjector().getScopeProvider().getResolutionScopeForDeclaration(namedFunction);
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)resolveSession.resolveToDescriptor(namedFunction);
        bodyResolver.resolveFunctionBody(trace, namedFunction, functionDescriptor, scope);
    }

    private static boolean initializerAdditionalResolve(KotlinCodeAnalyzer analyzer, JetClassInitializer classInitializer, BindingTrace trace, JetFile file) {
        BodyResolver bodyResolver = ResolveElementCache.createBodyResolverWithEmptyContext(trace, file, analyzer.getRootModuleDescriptor());
        JetClassOrObject classOrObject = PsiTreeUtil.getParentOfType((PsiElement)classInitializer, JetClassOrObject.class);
        LazyClassDescriptor classOrObjectDescriptor = (LazyClassDescriptor)analyzer.resolveToDescriptor(classOrObject);
        bodyResolver.resolveAnonymousInitializers(classOrObject, classOrObjectDescriptor.getUnsubstitutedPrimaryConstructor(), classOrObjectDescriptor.getScopeForPropertyInitializerResolution());
        return true;
    }

    private static BodyResolver createBodyResolver(BindingTrace trace, JetFile file, BodyResolveContextForLazy bodyResolveContext, ModuleDescriptor module) {
        TopDownAnalysisParameters parameters = new TopDownAnalysisParameters(Predicates.<PsiFile>alwaysTrue(), false, true, Collections.<AnalyzerScriptParameter>emptyList());
        InjectorForBodyResolve bodyResolve = new InjectorForBodyResolve(file.getProject(), parameters, trace, bodyResolveContext, module);
        return bodyResolve.getBodyResolver();
    }

    private static BodyResolver createBodyResolverWithEmptyContext(BindingTrace trace, JetFile file, ModuleDescriptor module) {
        return ResolveElementCache.createBodyResolver(trace, file, EMPTY_CONTEXT, module);
    }

    private static JetScope getExpressionResolutionScope(@NotNull ResolveSession resolveSession, @NotNull JetExpression expression) {
        ScopeProvider provider = resolveSession.getInjector().getScopeProvider();
        JetDeclaration parentDeclaration = PsiTreeUtil.getParentOfType((PsiElement)expression, JetDeclaration.class);
        if (parentDeclaration == null) {
            return provider.getFileScope((JetFile)expression.getContainingFile());
        }
        return provider.getResolutionScopeForDeclaration(parentDeclaration);
    }

    public static JetScope getExpressionMemberScope(@NotNull ResolveSession resolveSession, @NotNull JetExpression expression) {
        BindingTrace trace = resolveSession.getStorageManager().createSafeTrace(new DelegatingBindingTrace(resolveSession.getBindingContext(), "trace to resolve a member scope of expression", expression));
        if (BindingContextUtils.isExpressionWithValidReference(expression, resolveSession.getBindingContext())) {
            NamespaceDescriptor packageDescriptor;
            JetNamespaceHeader namespaceHeader;
            JetUserType qualifier;
            QualifiedExpressionResolver qualifiedExpressionResolver = resolveSession.getInjector().getQualifiedExpressionResolver();
            if (expression.getParent() instanceof JetUserType && (qualifier = ((JetUserType)expression.getParent()).getQualifier()) != null) {
                Collection<? extends DeclarationDescriptor> descriptors = qualifiedExpressionResolver.lookupDescriptorsForUserType(qualifier, ResolveElementCache.getExpressionResolutionScope(resolveSession, expression), trace);
                for (DeclarationDescriptor declarationDescriptor : descriptors) {
                    if (!(declarationDescriptor instanceof LazyPackageDescriptor)) continue;
                    return ((LazyPackageDescriptor)declarationDescriptor).getMemberScope();
                }
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)expression, JetImportDirective.class, false) != null) {
                NamespaceDescriptor rootPackage = resolveSession.getPackageDescriptorByFqName(FqName.ROOT);
                assert (rootPackage != null);
                if (expression.getParent() instanceof JetDotQualifiedExpression) {
                    NamespaceDescriptor namespaceDescriptor;
                    JetExpression element = ((JetDotQualifiedExpression)expression.getParent()).getReceiverExpression();
                    String name = ((JetFile)expression.getContainingFile()).getPackageName();
                    NamespaceDescriptor namespaceDescriptor2 = namespaceDescriptor = name != null ? resolveSession.getPackageDescriptorByFqName(new FqName(name)) : rootPackage;
                    assert (namespaceDescriptor != null) : "File package should be already resolved and be found";
                    JetScope scope = namespaceDescriptor.getMemberScope();
                    Collection<? extends DeclarationDescriptor> descriptors = element instanceof JetDotQualifiedExpression ? qualifiedExpressionResolver.lookupDescriptorsForQualifiedExpression((JetDotQualifiedExpression)element, rootPackage.getMemberScope(), scope, trace, QualifiedExpressionResolver.LookupMode.EVERYTHING, false) : qualifiedExpressionResolver.lookupDescriptorsForSimpleNameReference((JetSimpleNameExpression)element, rootPackage.getMemberScope(), scope, trace, QualifiedExpressionResolver.LookupMode.EVERYTHING, false, false);
                    for (DeclarationDescriptor declarationDescriptor : descriptors) {
                        if (!(declarationDescriptor instanceof NamespaceDescriptor)) continue;
                        return ((NamespaceDescriptor)declarationDescriptor).getMemberScope();
                    }
                } else {
                    return rootPackage.getMemberScope();
                }
            }
            if ((namespaceHeader = PsiTreeUtil.getParentOfType((PsiElement)expression, JetNamespaceHeader.class, false)) != null && (packageDescriptor = resolveSession.getPackageDescriptorByFqName(namespaceHeader.getParentFqName((JetReferenceExpression)expression))) != null) {
                return packageDescriptor.getMemberScope();
            }
        }
        return null;
    }

    private static class BodyResolveContextForLazy
    implements BodiesResolveContext {
        private final Function<JetDeclaration, JetScope> declaringScopes;

        private BodyResolveContextForLazy(@NotNull Function<JetDeclaration, JetScope> declaringScopes) {
            this.declaringScopes = declaringScopes;
        }

        @Override
        public Collection<JetFile> getFiles() {
            return Collections.emptySet();
        }

        @Override
        public Map<JetClass, MutableClassDescriptor> getClasses() {
            return Collections.emptyMap();
        }

        @Override
        public Map<JetObjectDeclaration, MutableClassDescriptor> getObjects() {
            return Collections.emptyMap();
        }

        @Override
        public Map<JetProperty, PropertyDescriptor> getProperties() {
            return Collections.emptyMap();
        }

        @Override
        public Map<JetNamedFunction, SimpleFunctionDescriptor> getFunctions() {
            return Collections.emptyMap();
        }

        @Override
        public Function<JetDeclaration, JetScope> getDeclaringScopes() {
            return this.declaringScopes;
        }

        @Override
        public Map<JetScript, ScriptDescriptor> getScripts() {
            return Collections.emptyMap();
        }

        @Override
        public Map<JetScript, WritableScope> getScriptScopes() {
            return Collections.emptyMap();
        }

        @Override
        public void setTopDownAnalysisParameters(TopDownAnalysisParameters parameters) {
        }

        @Override
        public boolean completeAnalysisNeeded(@NotNull PsiElement element) {
            return true;
        }
    }
}

