/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DelegationResolver;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.jet.lang.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.AbstractLazyMemberScope;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.NullableLazyValue;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.util.lazy.RecursionIntolerantLazyValue;

public class LazyClassMemberScope
extends AbstractLazyMemberScope<LazyClassDescriptor, ClassMemberDeclarationProvider> {
    @NotNull
    private static final Set<ClassKind> GENERATE_CONSTRUCTORS_FOR = ImmutableSet.of(ClassKind.CLASS, ClassKind.ANNOTATION_CLASS, ClassKind.OBJECT, ClassKind.ENUM_CLASS, ClassKind.ENUM_ENTRY, ClassKind.CLASS_OBJECT, new ClassKind[0]);
    private final NullableLazyValue<ConstructorDescriptor> primaryConstructor;

    public LazyClassMemberScope(@NotNull ResolveSession resolveSession, @NotNull ClassMemberDeclarationProvider declarationProvider, @NotNull LazyClassDescriptor thisClass) {
        super(resolveSession, declarationProvider, thisClass);
        this.primaryConstructor = resolveSession.getStorageManager().createNullableLazyValue(new Computable<ConstructorDescriptor>(){

            @Override
            public ConstructorDescriptor compute() {
                return LazyClassMemberScope.this.resolvePrimaryConstructor();
            }
        });
    }

    @Override
    @NotNull
    protected JetScope getScopeForMemberDeclarationResolution(JetDeclaration declaration) {
        if (declaration instanceof JetProperty) {
            return ((LazyClassDescriptor)this.thisDescriptor).getScopeForPropertyInitializerResolution();
        }
        return ((LazyClassDescriptor)this.thisDescriptor).getScopeForMemberDeclarationResolution();
    }

    private <D extends CallableMemberDescriptor> void generateFakeOverrides(@NotNull Name name, @NotNull Collection<D> fromSupertypes, final @NotNull Collection<D> result, final @NotNull Class<? extends D> exactDescriptorClass) {
        OverrideResolver.generateOverridesInFunctionGroup(name, fromSupertypes, Lists.newArrayList(result), (ClassDescriptor)this.thisDescriptor, new OverrideResolver.DescriptorSink(){

            @Override
            public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                assert (exactDescriptorClass.isInstance(fakeOverride)) : "Wrong descriptor type in an override: " + fakeOverride + " while expecting " + exactDescriptorClass.getSimpleName();
                result.add(fakeOverride);
            }

            @Override
            public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                BindingTrace trace = LazyClassMemberScope.this.resolveSession.getTrace();
                JetDeclaration declaration = (JetDeclaration)BindingContextUtils.descriptorToDeclaration(trace.getBindingContext(), fromCurrent);
                assert (declaration != null) : "fromCurrent can not be a fake override";
                trace.report(Errors.CONFLICTING_OVERLOADS.on(declaration, fromCurrent, fromCurrent.getContainingDeclaration().getName().asString()));
            }
        });
        OverrideResolver.resolveUnknownVisibilities(result, this.resolveSession.getTrace());
    }

    @Override
    @NotNull
    public Set<FunctionDescriptor> getFunctions(@NotNull Name name) {
        Collection functions = super.getFunctions(name);
        for (FunctionDescriptor functionDescriptor : functions) {
            if (functionDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) continue;
            PsiElement element = BindingContextUtils.callableDescriptorToDeclaration(this.resolveSession.getTrace().getBindingContext(), functionDescriptor);
            OverrideResolver.resolveUnknownVisibilityForMember((JetDeclaration)element, functionDescriptor, this.resolveSession.getTrace());
        }
        return functions;
    }

    @Override
    protected void getNonDeclaredFunctions(@NotNull Name name, @NotNull Set<FunctionDescriptor> result) {
        ArrayList<FunctionDescriptor> fromSupertypes = Lists.newArrayList();
        for (JetType supertype : ((LazyClassDescriptor)this.thisDescriptor).getTypeConstructor().getSupertypes()) {
            fromSupertypes.addAll(supertype.getMemberScope().getFunctions(name));
        }
        this.generateDelegatingDescriptors(name, MemberExtractor.EXTRACT_FUNCTIONS, result);
        this.generateEnumClassObjectMethods(result, name);
        this.generateDataClassMethods(result, name);
        this.generateFakeOverrides(name, fromSupertypes, result, FunctionDescriptor.class);
    }

    private void generateDataClassMethods(@NotNull Collection<FunctionDescriptor> result, @NotNull Name name) {
        if (!KotlinBuiltIns.getInstance().isData((ClassDescriptor)this.thisDescriptor)) {
            return;
        }
        ConstructorDescriptor constructor = this.getPrimaryConstructor();
        if (constructor == null) {
            return;
        }
        int parameterIndex = 0;
        for (ValueParameterDescriptor parameter : constructor.getValueParameters()) {
            Collection properties;
            if (ErrorUtils.isErrorType(parameter.getType()) || (properties = this.getProperties(parameter.getName())).isEmpty()) continue;
            assert (properties.size() == 1) : "A constructor parameter is resolved to more than one (" + properties.size() + ") property: " + parameter;
            PropertyDescriptor property = (PropertyDescriptor)properties.iterator().next();
            if (property == null || !name.equals(Name.identifier("component" + ++parameterIndex))) continue;
            SimpleFunctionDescriptor functionDescriptor = DescriptorResolver.createComponentFunctionDescriptor(parameterIndex, property, parameter, (ClassDescriptor)this.thisDescriptor, this.resolveSession.getTrace());
            result.add(functionDescriptor);
            break;
        }
        if (!constructor.getValueParameters().isEmpty() && name.equals(DescriptorResolver.COPY_METHOD_NAME)) {
            SimpleFunctionDescriptor copyFunctionDescriptor = DescriptorResolver.createCopyFunctionDescriptor(constructor.getValueParameters(), (ClassDescriptor)this.thisDescriptor, this.resolveSession.getTrace());
            result.add(copyFunctionDescriptor);
        }
    }

    private void generateEnumClassObjectMethods(@NotNull Collection<? super FunctionDescriptor> result, @NotNull Name name) {
        if (!DescriptorUtils.isEnumClassObject(this.thisDescriptor)) {
            return;
        }
        if (name.equals(DescriptorResolver.VALUES_METHOD_NAME)) {
            SimpleFunctionDescriptor valuesMethod = DescriptorResolver.createEnumClassObjectValuesMethod((ClassDescriptor)this.thisDescriptor, this.resolveSession.getTrace());
            result.add(valuesMethod);
        } else if (name.equals(DescriptorResolver.VALUE_OF_METHOD_NAME)) {
            SimpleFunctionDescriptor valueOfMethod = DescriptorResolver.createEnumClassObjectValueOfMethod((ClassDescriptor)this.thisDescriptor, this.resolveSession.getTrace());
            result.add(valueOfMethod);
        }
    }

    @Override
    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull Name name) {
        Collection properties = super.getProperties(name);
        for (VariableDescriptor variableDescriptor : properties) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
            if (propertyDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) continue;
            PsiElement element = BindingContextUtils.callableDescriptorToDeclaration(this.resolveSession.getTrace().getBindingContext(), propertyDescriptor);
            OverrideResolver.resolveUnknownVisibilityForMember((JetDeclaration)element, propertyDescriptor, this.resolveSession.getTrace());
        }
        return properties;
    }

    @Override
    protected void getNonDeclaredProperties(@NotNull Name name, @NotNull Set<VariableDescriptor> result) {
        JetClassLikeInfo classInfo = ((ClassMemberDeclarationProvider)this.declarationProvider).getOwnerInfo();
        ConstructorDescriptor primaryConstructor = this.getPrimaryConstructor();
        if (primaryConstructor != null) {
            List<ValueParameterDescriptor> valueParameterDescriptors = primaryConstructor.getValueParameters();
            List<? extends JetParameter> primaryConstructorParameters = classInfo.getPrimaryConstructorParameters();
            assert (valueParameterDescriptors.size() == primaryConstructorParameters.size()) : "From descriptor: " + valueParameterDescriptors.size() + " but from PSI: " + primaryConstructorParameters.size();
            for (ValueParameterDescriptor valueParameterDescriptor : valueParameterDescriptors) {
                JetParameter parameter = primaryConstructorParameters.get(valueParameterDescriptor.getIndex());
                if (parameter.getValOrVarNode() == null || !name.equals(parameter.getNameAsName())) continue;
                PropertyDescriptor propertyDescriptor = this.resolveSession.getInjector().getDescriptorResolver().resolvePrimaryConstructorParameterToAProperty((ClassDescriptor)this.thisDescriptor, valueParameterDescriptor, ((LazyClassDescriptor)this.thisDescriptor).getScopeForClassHeaderResolution(), parameter, this.resolveSession.getTrace());
                result.add(propertyDescriptor);
            }
        }
        ArrayList fromSupertypes = Lists.newArrayList();
        for (JetType supertype : ((LazyClassDescriptor)this.thisDescriptor).getTypeConstructor().getSupertypes()) {
            fromSupertypes.addAll((Set)supertype.getMemberScope().getProperties(name));
        }
        this.generateDelegatingDescriptors(name, MemberExtractor.EXTRACT_PROPERTIES, result);
        this.generateFakeOverrides(name, fromSupertypes, result, PropertyDescriptor.class);
    }

    private <T extends CallableMemberDescriptor> void generateDelegatingDescriptors(@NotNull Name name, @NotNull MemberExtractor<T> extractor, @NotNull Set<? super T> result) {
        for (JetDelegationSpecifier delegationSpecifier : ((ClassMemberDeclarationProvider)this.declarationProvider).getOwnerInfo().getDelegationSpecifiers()) {
            JetDelegatorByExpressionSpecifier specifier;
            JetTypeReference typeReference;
            if (!(delegationSpecifier instanceof JetDelegatorByExpressionSpecifier) || (typeReference = (specifier = (JetDelegatorByExpressionSpecifier)delegationSpecifier).getTypeReference()) == null) continue;
            JetType supertype = this.resolveSession.getInjector().getTypeResolver().resolveType(((LazyClassDescriptor)this.thisDescriptor).getScopeForClassHeaderResolution(), typeReference, this.resolveSession.getTrace(), false);
            Collection<T> descriptors = DelegationResolver.generateDelegatedMembers(this.thisDescriptor, extractor.extract(supertype, name));
            result.addAll(descriptors);
        }
    }

    @Override
    protected void addExtraDescriptors(@NotNull Collection<DeclarationDescriptor> result) {
        for (JetType supertype : ((LazyClassDescriptor)this.thisDescriptor).getTypeConstructor().getSupertypes()) {
            for (DeclarationDescriptor descriptor : supertype.getMemberScope().getAllDescriptors()) {
                if (descriptor instanceof FunctionDescriptor) {
                    result.addAll(this.getFunctions(descriptor.getName()));
                    continue;
                }
                if (!(descriptor instanceof PropertyDescriptor)) continue;
                result.addAll(this.getProperties(descriptor.getName()));
            }
        }
        result.addAll(this.getFunctions(DescriptorResolver.VALUES_METHOD_NAME));
        result.addAll(this.getFunctions(DescriptorResolver.VALUE_OF_METHOD_NAME));
        this.addDataClassMethods(result);
    }

    private void addDataClassMethods(@NotNull Collection<DeclarationDescriptor> result) {
        Name componentName;
        Collection functions;
        if (!KotlinBuiltIns.getInstance().isData((ClassDescriptor)this.thisDescriptor)) {
            return;
        }
        ConstructorDescriptor constructor = this.getPrimaryConstructor();
        if (constructor == null) {
            return;
        }
        int n = 1;
        while (!(functions = this.getFunctions(componentName = Name.identifier("component" + n))).isEmpty()) {
            result.addAll(functions);
            ++n;
        }
        result.addAll(this.getFunctions(Name.identifier("copy")));
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        return null;
    }

    @Override
    @NotNull
    protected ReceiverParameterDescriptor getImplicitReceiver() {
        return ((LazyClassDescriptor)this.thisDescriptor).getThisAsReceiverParameter();
    }

    @NotNull
    public Set<ConstructorDescriptor> getConstructors() {
        ConstructorDescriptor constructor = this.getPrimaryConstructor();
        return constructor == null ? Collections.emptySet() : Collections.singleton(constructor);
    }

    @Nullable
    public ConstructorDescriptor getPrimaryConstructor() {
        return this.primaryConstructor.compute();
    }

    @Nullable
    private ConstructorDescriptor resolvePrimaryConstructor() {
        ConstructorDescriptorImpl primaryConstructor = null;
        if (GENERATE_CONSTRUCTORS_FOR.contains((Object)((LazyClassDescriptor)this.thisDescriptor).getKind())) {
            JetClassOrObject classOrObject = ((ClassMemberDeclarationProvider)this.declarationProvider).getOwnerInfo().getCorrespondingClassOrObject();
            if (!((LazyClassDescriptor)this.thisDescriptor).getKind().isObject()) {
                ConstructorDescriptorImpl constructor;
                JetClass jetClass = (JetClass)classOrObject;
                primaryConstructor = constructor = this.resolveSession.getInjector().getDescriptorResolver().resolvePrimaryConstructorDescriptor(((LazyClassDescriptor)this.thisDescriptor).getScopeForClassHeaderResolution(), (ClassDescriptor)this.thisDescriptor, jetClass, this.resolveSession.getTrace());
                this.setDeferredReturnType(constructor);
            } else {
                ConstructorDescriptorImpl constructor = DescriptorResolver.createAndRecordPrimaryConstructorForObject(classOrObject, (ClassDescriptor)this.thisDescriptor, this.resolveSession.getTrace());
                this.setDeferredReturnType(constructor);
                primaryConstructor = constructor;
            }
        }
        return primaryConstructor;
    }

    private void setDeferredReturnType(@NotNull ConstructorDescriptorImpl descriptor) {
        descriptor.setReturnType(DeferredType.create(this.resolveSession.getTrace(), new RecursionIntolerantLazyValue<JetType>(){

            @Override
            protected JetType compute() {
                return ((LazyClassDescriptor)LazyClassMemberScope.this.thisDescriptor).getDefaultType();
            }
        }));
    }

    @Override
    public String toString() {
        return "lazy scope for class " + ((LazyClassDescriptor)this.thisDescriptor).getName();
    }

    private static interface MemberExtractor<T extends CallableMemberDescriptor> {
        public static final MemberExtractor<FunctionDescriptor> EXTRACT_FUNCTIONS = new MemberExtractor<FunctionDescriptor>(){

            @Override
            @NotNull
            public Collection<FunctionDescriptor> extract(@NotNull JetType extractFrom, @NotNull Name name) {
                return extractFrom.getMemberScope().getFunctions(name);
            }
        };
        public static final MemberExtractor<PropertyDescriptor> EXTRACT_PROPERTIES = new MemberExtractor<PropertyDescriptor>(){

            @Override
            @NotNull
            public Collection<PropertyDescriptor> extract(@NotNull JetType extractFrom, @NotNull Name name) {
                return extractFrom.getMemberScope().getProperties(name);
            }
        };

        @NotNull
        public Collection<T> extract(@NotNull JetType var1, @NotNull Name var2);
    }
}

