/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import com.google.common.collect.Iterables;
import com.intellij.psi.NavigatablePsiElement;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.AbstractNamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceDescriptorParent;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.lazy.ForceResolveUtil;
import org.jetbrains.jet.lang.resolve.lazy.LazyDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyPackageMemberScope;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.ChainedScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;

public class LazyPackageDescriptor
extends AbstractNamespaceDescriptorImpl
implements NamespaceDescriptor,
LazyDescriptor {
    private final JetScope memberScope;
    private final JetScope lazyScope;

    public LazyPackageDescriptor(@NotNull NamespaceDescriptorParent containingDeclaration, @NotNull Name name, @NotNull ResolveSession resolveSession, @NotNull PackageMemberDeclarationProvider declarationProvider) {
        super(containingDeclaration, Collections.<AnnotationDescriptor>emptyList(), name);
        WritableScopeImpl scope = new WritableScopeImpl(JetScope.EMPTY, this, RedeclarationHandler.DO_NOTHING, "Package scope");
        resolveSession.getRootModuleDescriptor().getModuleConfiguration().extendNamespaceScope(resolveSession.getTrace(), this, scope);
        scope.changeLockLevel(WritableScope.LockLevel.READING);
        this.lazyScope = new LazyPackageMemberScope(resolveSession, declarationProvider, this);
        this.memberScope = new ChainedScope((DeclarationDescriptor)this, "Lazy package members scope: " + name, this.lazyScope, scope);
        NavigatablePsiElement declaration = Iterables.getFirst(declarationProvider.getPackageDeclarations(this.getFqName()), null);
        if (declaration != null) {
            resolveSession.getTrace().record(BindingContext.NAMESPACE, declaration, this);
        }
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        return this.memberScope;
    }

    @Override
    @NotNull
    public FqName getFqName() {
        return DescriptorUtils.getFQName(this).toSafe();
    }

    @Override
    public void addNamespace(@NotNull NamespaceDescriptor namespaceDescriptor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forceResolveAllContents() {
        ForceResolveUtil.forceResolveAllContents(this.lazyScope);
    }
}

