/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotatedImpl;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public final class JetTypeImpl
extends AnnotatedImpl
implements JetType {
    private final TypeConstructor constructor;
    private final List<TypeProjection> arguments;
    private final boolean nullable;
    private final JetScope memberScope;

    public JetTypeImpl(List<AnnotationDescriptor> annotations, TypeConstructor constructor, boolean nullable, @NotNull List<TypeProjection> arguments, JetScope memberScope) {
        super(annotations);
        if (memberScope instanceof ErrorUtils.ErrorScope) {
            throw new IllegalStateException();
        }
        this.constructor = constructor;
        this.nullable = nullable;
        this.arguments = arguments;
        this.memberScope = memberScope;
    }

    public JetTypeImpl(TypeConstructor constructor, JetScope memberScope) {
        this(Collections.emptyList(), constructor, false, Collections.emptyList(), memberScope);
    }

    public JetTypeImpl(@NotNull ClassDescriptor classDescriptor) {
        this(Collections.emptyList(), classDescriptor.getTypeConstructor(), false, Collections.emptyList(), classDescriptor.getMemberScope(Collections.<TypeProjection>emptyList()));
    }

    @Override
    @NotNull
    public TypeConstructor getConstructor() {
        return this.constructor;
    }

    @Override
    @NotNull
    public List<TypeProjection> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        return this.memberScope;
    }

    public String toString() {
        return this.constructor + (this.arguments.isEmpty() ? "" : "<" + this.argumentsToString() + ">") + (this.isNullable() ? "?" : "");
    }

    private StringBuilder argumentsToString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<TypeProjection> iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            TypeProjection argument = iterator.next();
            stringBuilder.append(argument);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JetType)) {
            return false;
        }
        JetType type = (JetType)o;
        return this.nullable == type.isNullable() && JetTypeChecker.INSTANCE.equalTypes(this, type);
    }

    public int hashCode() {
        int result = this.constructor != null ? this.constructor.hashCode() : 0;
        result = 31 * result + ((Object)this.arguments).hashCode();
        result = 31 * result + (this.nullable ? 1 : 0);
        return result;
    }
}

