/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetLabelQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;

public class LabelResolver {
    private final Map<LabelName, Stack<JetElement>> labeledElements = new HashMap<LabelName, Stack<JetElement>>();

    public void enterLabeledElement(@NotNull LabelName labelName, @NotNull JetExpression labeledExpression) {
        JetExpression cacheExpression = this.getCachingExpression(labeledExpression);
        if (cacheExpression != null) {
            Stack<JetElement> stack = this.labeledElements.get(labelName);
            if (stack == null) {
                stack = new Stack();
                this.labeledElements.put(labelName, stack);
            }
            stack.push(cacheExpression);
        }
    }

    public void exitLabeledElement(@NotNull JetExpression expression) {
        JetExpression cacheExpression = this.getCachingExpression(expression);
        Iterator<Map.Entry<LabelName, Stack<JetElement>>> mapIter = this.labeledElements.entrySet().iterator();
        while (mapIter.hasNext()) {
            Map.Entry<LabelName, Stack<JetElement>> entry = mapIter.next();
            Stack<JetElement> stack = entry.getValue();
            Iterator stackIter = stack.iterator();
            while (stackIter.hasNext()) {
                JetElement recorded = (JetElement)stackIter.next();
                if (recorded != cacheExpression) continue;
                stackIter.remove();
            }
            if (!stack.isEmpty()) continue;
            mapIter.remove();
        }
    }

    @NotNull
    private JetExpression getCachingExpression(@NotNull JetExpression labeledExpression) {
        JetExpression expression = JetPsiUtil.deparenthesizeWithNoTypeResolution(labeledExpression);
        if (expression instanceof JetFunctionLiteralExpression) {
            expression = ((JetFunctionLiteralExpression)expression).getFunctionLiteral();
        }
        return expression;
    }

    @Nullable
    private JetElement resolveControlLabel(@NotNull LabelName labelName, @NotNull JetSimpleNameExpression labelExpression, boolean reportUnresolved, ExpressionTypingContext context) {
        Collection<DeclarationDescriptor> declarationsByLabel = context.scope.getDeclarationsByLabel(labelName);
        int size = declarationsByLabel.size();
        if (size == 1) {
            DeclarationDescriptor declarationDescriptor = declarationsByLabel.iterator().next();
            if (!(declarationDescriptor instanceof FunctionDescriptor) && !(declarationDescriptor instanceof ClassDescriptor)) {
                throw new UnsupportedOperationException(declarationDescriptor.getClass().toString());
            }
            JetElement element = (JetElement)BindingContextUtils.descriptorToDeclaration(context.trace.getBindingContext(), declarationDescriptor);
            context.trace.record(BindingContext.LABEL_TARGET, labelExpression, element);
            return element;
        }
        if (size == 0) {
            return this.resolveNamedLabel(labelName, labelExpression, reportUnresolved, context);
        }
        BindingContextUtils.reportAmbiguousLabel(context.trace, labelExpression, declarationsByLabel);
        return null;
    }

    @Nullable
    public JetElement resolveLabel(JetLabelQualifiedExpression expression, ExpressionTypingContext context) {
        JetSimpleNameExpression labelElement = expression.getTargetLabel();
        if (labelElement != null) {
            LabelName labelName = new LabelName(expression.getLabelName());
            return this.resolveControlLabel(labelName, labelElement, true, context);
        }
        return null;
    }

    private JetElement resolveNamedLabel(@NotNull LabelName labelName, @NotNull JetSimpleNameExpression labelExpression, boolean reportUnresolved, ExpressionTypingContext context) {
        Stack<JetElement> stack = this.labeledElements.get(labelName);
        if (stack == null || stack.isEmpty()) {
            if (reportUnresolved) {
                context.trace.report(Errors.UNRESOLVED_REFERENCE.on(labelExpression, labelExpression));
            }
            return null;
        }
        if (stack.size() > 1) {
            context.trace.report(Errors.LABEL_NAME_CLASH.on(labelExpression));
        }
        JetElement result = stack.peek();
        context.trace.record(BindingContext.LABEL_TARGET, labelExpression, result);
        return result;
    }

    public LabeledReceiverResolutionResult resolveThisLabel(JetReferenceExpression thisReference, JetSimpleNameExpression targetLabel, ExpressionTypingContext context, LabelName labelName) {
        Collection<DeclarationDescriptor> declarationsByLabel = context.scope.getDeclarationsByLabel(labelName);
        int size = declarationsByLabel.size();
        assert (targetLabel != null);
        if (size == 1) {
            ClassDescriptor classDescriptor;
            ReceiverParameterDescriptor thisReceiver;
            DeclarationDescriptor declarationDescriptor = declarationsByLabel.iterator().next();
            if (declarationDescriptor instanceof ClassDescriptor) {
                ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
                thisReceiver = classDescriptor2.getThisAsReceiverParameter();
            } else if (declarationDescriptor instanceof FunctionDescriptor) {
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
                thisReceiver = functionDescriptor.getReceiverParameter();
            } else if (declarationDescriptor instanceof PropertyDescriptor) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
                thisReceiver = propertyDescriptor.getReceiverParameter();
            } else {
                throw new UnsupportedOperationException("Unsupported descriptor: " + declarationDescriptor);
            }
            PsiElement element = BindingContextUtils.descriptorToDeclaration(context.trace.getBindingContext(), declarationDescriptor);
            assert (element != null) : "No PSI element for descriptor: " + declarationDescriptor;
            context.trace.record(BindingContext.LABEL_TARGET, targetLabel, element);
            context.trace.record(BindingContext.REFERENCE_TARGET, thisReference, declarationDescriptor);
            if (declarationDescriptor instanceof ClassDescriptor && !DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, targetLabel, classDescriptor = (ClassDescriptor)declarationDescriptor)) {
                return LabeledReceiverResolutionResult.labelResolutionFailed();
            }
            return LabeledReceiverResolutionResult.labelResolutionSuccess(thisReceiver);
        }
        if (size == 0) {
            JetElement element = this.resolveNamedLabel(labelName, targetLabel, false, context);
            if (element instanceof JetFunctionLiteral) {
                DeclarationDescriptor declarationDescriptor = context.trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
                if (declarationDescriptor instanceof FunctionDescriptor) {
                    ReceiverParameterDescriptor thisReceiver = ((FunctionDescriptor)declarationDescriptor).getReceiverParameter();
                    if (thisReceiver != null) {
                        context.trace.record(BindingContext.LABEL_TARGET, targetLabel, element);
                        context.trace.record(BindingContext.REFERENCE_TARGET, thisReference, declarationDescriptor);
                    }
                    return LabeledReceiverResolutionResult.labelResolutionSuccess(thisReceiver);
                }
                context.trace.report(Errors.UNRESOLVED_REFERENCE.on(targetLabel, targetLabel));
            } else {
                context.trace.report(Errors.UNRESOLVED_REFERENCE.on(targetLabel, targetLabel));
            }
        } else {
            BindingContextUtils.reportAmbiguousLabel(context.trace, targetLabel, declarationsByLabel);
        }
        return LabeledReceiverResolutionResult.labelResolutionFailed();
    }

    public static final class LabeledReceiverResolutionResult {
        private final Code code;
        private final ReceiverParameterDescriptor receiverParameterDescriptor;

        public static LabeledReceiverResolutionResult labelResolutionSuccess(@Nullable ReceiverParameterDescriptor receiverParameterDescriptor) {
            if (receiverParameterDescriptor == null) {
                return new LabeledReceiverResolutionResult(Code.NO_THIS, null);
            }
            return new LabeledReceiverResolutionResult(Code.SUCCESS, receiverParameterDescriptor);
        }

        public static LabeledReceiverResolutionResult labelResolutionFailed() {
            return new LabeledReceiverResolutionResult(Code.LABEL_RESOLUTION_ERROR, null);
        }

        private LabeledReceiverResolutionResult(Code code, ReceiverParameterDescriptor receiverParameterDescriptor) {
            this.code = code;
            this.receiverParameterDescriptor = receiverParameterDescriptor;
        }

        public Code getCode() {
            return this.code;
        }

        public boolean success() {
            return this.code == Code.SUCCESS;
        }

        public ReceiverParameterDescriptor getReceiverParameterDescriptor() {
            assert (this.success()) : "Don't try to obtain the receiver when resolution failed with " + (Object)((Object)this.code);
            return this.receiverParameterDescriptor;
        }

        public static enum Code {
            LABEL_RESOLUTION_ERROR,
            NO_THIS,
            SUCCESS;

        }
    }
}

