/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.lang;

import com.google.common.collect.ImmutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public enum PrimitiveType {
    BOOLEAN("Boolean"),
    CHAR("Char"),
    BYTE("Byte"),
    SHORT("Short"),
    INT("Int"),
    FLOAT("Float"),
    LONG("Long"),
    DOUBLE("Double");

    public static final ImmutableSet<PrimitiveType> NUMBER_TYPES;
    private final Name typeName;
    private final Name arrayTypeName;
    private final Name rangeTypeName;
    private final FqName className;
    private final FqName arrayClassName;
    private final FqName rangeClassName;
    private final FqName progressionClassName;

    private PrimitiveType(String typeName) {
        this.typeName = Name.identifier(typeName);
        this.arrayTypeName = Name.identifier(typeName + "Array");
        this.rangeTypeName = Name.identifier(typeName + "Range");
        FqName builtInsPackageFqName = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME;
        this.className = builtInsPackageFqName.child(this.typeName);
        this.arrayClassName = builtInsPackageFqName.child(this.arrayTypeName);
        this.rangeClassName = builtInsPackageFqName.child(this.rangeTypeName);
        this.progressionClassName = builtInsPackageFqName.child(Name.identifier(typeName + "Progression"));
    }

    @NotNull
    public Name getTypeName() {
        return this.typeName;
    }

    @NotNull
    public Name getArrayTypeName() {
        return this.arrayTypeName;
    }

    @NotNull
    public Name getRangeTypeName() {
        return this.rangeTypeName;
    }

    @NotNull
    public FqName getClassName() {
        return this.className;
    }

    @NotNull
    public FqName getArrayClassName() {
        return this.arrayClassName;
    }

    @NotNull
    public FqName getRangeClassName() {
        return this.rangeClassName;
    }

    @NotNull
    public FqName getProgressionClassName() {
        return this.progressionClassName;
    }

    static {
        NUMBER_TYPES = ImmutableSet.of(CHAR, BYTE, SHORT, INT, FLOAT, LONG, new PrimitiveType[]{DOUBLE});
    }
}

