/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.ref;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.ref.JetTypeNameParser;

public class JetTypeName {
    private final FqName className;
    private final List<JetTypeName> arguments;

    public JetTypeName(@NotNull FqName className, @NotNull List<JetTypeName> arguments) {
        this.className = className;
        this.arguments = arguments;
    }

    @NotNull
    public FqName getClassName() {
        return this.className;
    }

    @NotNull
    public List<JetTypeName> getArguments() {
        return this.arguments;
    }

    @NotNull
    public static JetTypeName fromJavaClass(@NotNull Class<?> clazz) {
        if (clazz.getTypeParameters().length != 0) {
            throw new IllegalArgumentException("cannot create type reference: actual type parameters unknown: " + clazz);
        }
        FqName fqName = new FqName(clazz.getName());
        return JetTypeName.withoutParameters(fqName);
    }

    @NotNull
    public static JetTypeName withoutParameters(@NotNull FqName fqName) {
        return new JetTypeName(fqName, Collections.<JetTypeName>emptyList());
    }

    @NotNull
    public static JetTypeName parse(@NotNull String value) {
        return JetTypeNameParser.parse(value);
    }
}

