/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.plugin;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;

public class JetMainDetector {
    private JetMainDetector() {
    }

    public static boolean hasMain(@NotNull List<JetDeclaration> declarations) {
        return JetMainDetector.findMainFunction(declarations) != null;
    }

    public static boolean isMain(@NotNull JetNamedFunction function) {
        JetTypeReference reference;
        List<JetParameter> parameters;
        return "main".equals(function.getName()) && (parameters = function.getValueParameters()).size() == 1 && (reference = parameters.get(0).getTypeReference()) != null && reference.getText().equals("Array<String>");
    }

    @Nullable
    public static JetNamedFunction getMainFunction(@NotNull Collection<JetFile> files) {
        for (JetFile file : files) {
            JetNamedFunction mainFunction = JetMainDetector.findMainFunction(file.getDeclarations());
            if (mainFunction == null) continue;
            return mainFunction;
        }
        return null;
    }

    @Nullable
    private static JetNamedFunction findMainFunction(@NotNull List<JetDeclaration> declarations) {
        for (JetDeclaration declaration : declarations) {
            JetNamedFunction candidateFunction;
            if (!(declaration instanceof JetNamedFunction) || !JetMainDetector.isMain(candidateFunction = (JetNamedFunction)declaration)) continue;
            return candidateFunction;
        }
        return null;
    }
}

