/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.util.lazy;

import org.jetbrains.jet.util.lazy.ReenteringLazyValueComputationException;

public abstract class RecursionIntolerantLazyValue<T> {
    private State state = State.NOT_COMPUTED;
    private T value;

    protected abstract T compute();

    protected T getValueOnErrorReentry() {
        throw new ReenteringLazyValueComputationException();
    }

    public boolean isComputed() {
        return this.state == State.ERROR || this.state == State.COMPUTED;
    }

    public final T get() {
        switch (this.state) {
            case NOT_COMPUTED: {
                this.state = State.BEING_COMPUTED;
                this.value = this.compute();
                this.state = State.COMPUTED;
                return this.value;
            }
            case BEING_COMPUTED: {
                this.state = State.ERROR;
                throw new ReenteringLazyValueComputationException();
            }
            case COMPUTED: {
                return this.value;
            }
            case ERROR: {
                return this.getValueOnErrorReentry();
            }
        }
        throw new IllegalStateException("Unreachable");
    }

    private static enum State {
        NOT_COMPUTED,
        BEING_COMPUTED,
        COMPUTED,
        ERROR;

    }
}

