/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.facade;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class MainCallParameters {
    @NotNull
    public static MainCallParameters noCall() {
        return new MainCallParameters(){

            @Override
            @NotNull
            public List<String> arguments() {
                throw new UnsupportedOperationException("#arguments");
            }

            @Override
            public boolean shouldBeGenerated() {
                return false;
            }
        };
    }

    @NotNull
    public static MainCallParameters mainWithoutArguments() {
        return new MainCallParameters(){

            @Override
            @NotNull
            public List<String> arguments() {
                return Collections.emptyList();
            }

            @Override
            public boolean shouldBeGenerated() {
                return true;
            }
        };
    }

    @NotNull
    public static MainCallParameters mainWithArguments(final @NotNull List<String> parameters) {
        return new MainCallParameters(){

            @Override
            @NotNull
            public List<String> arguments() {
                return parameters;
            }

            @Override
            public boolean shouldBeGenerated() {
                return true;
            }
        };
    }

    public abstract boolean shouldBeGenerated();

    @NotNull
    public abstract List<String> arguments();
}

