/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.k2js.translate.context.TemporaryVariable;

public final class DynamicContext {
    @NotNull
    private final JsScope currentScope;
    @NotNull
    private final JsBlock currentBlock;
    @Nullable
    private JsVars vars;

    @NotNull
    public static DynamicContext rootContext(@NotNull JsScope rootScope, @NotNull JsBlock globalBlock) {
        return new DynamicContext(rootScope, globalBlock);
    }

    @NotNull
    public static DynamicContext newContext(@NotNull JsScope scope, @NotNull JsBlock block) {
        return new DynamicContext(scope, block);
    }

    private DynamicContext(@NotNull JsScope scope, @NotNull JsBlock block) {
        this.currentScope = scope;
        this.currentBlock = block;
    }

    @NotNull
    public DynamicContext innerBlock(@NotNull JsBlock block) {
        return new DynamicContext(this.currentScope, block);
    }

    @NotNull
    public TemporaryVariable declareTemporary(@Nullable JsExpression initExpression) {
        if (this.vars == null) {
            this.vars = new JsVars();
            this.currentBlock.getStatements().add(this.vars);
        }
        JsName temporaryName = this.currentScope.declareTemporary();
        this.vars.add(new JsVars.JsVar(temporaryName, null));
        return TemporaryVariable.create(temporaryName, initExpression);
    }

    @NotNull
    public Pair<JsVars.JsVar, JsExpression> createTemporary(@Nullable JsExpression initExpression) {
        JsVars.JsVar var = new JsVars.JsVar(this.currentScope.declareTemporary(), initExpression);
        return Pair.create(var, new JsNameRef(var.getName()));
    }

    @NotNull
    public JsVars.JsVar createTemporaryVar(@NotNull JsExpression initExpression) {
        return new JsVars.JsVar(this.currentScope.declareTemporary(), initExpression);
    }

    @NotNull
    public JsScope getScope() {
        return this.currentScope;
    }

    @NotNull
    public JsBlock jsBlock() {
        return this.currentBlock;
    }
}

