/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.utils.DFS;
import org.jetbrains.k2js.translate.LabelGenerator;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassAliasingMap;
import org.jetbrains.k2js.translate.declaration.ClassTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.initializer.InitializerUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;

public final class ClassDeclarationTranslator
extends AbstractTranslator {
    private final LabelGenerator localLabelGenerator = new LabelGenerator('c');
    @NotNull
    private final THashMap<ClassDescriptor, OpenClassInfo> openClassDescriptorToItem = new THashMap();
    private final LinkedList<OpenClassInfo> openList = new LinkedList();
    private final List<Pair<JetClassOrObject, JsInvocation>> finalList = new ArrayList<Pair<JetClassOrObject, JsInvocation>>();
    @NotNull
    private final ClassDescriptorToLabel classDescriptorToLabel = new ClassDescriptorToLabel();
    @NotNull
    private final JsFunction dummyFunction;
    private final JsNameRef declarationsObjectRef;
    private final JsVars.JsVar classesVar;

    public ClassDeclarationTranslator(@NotNull TranslationContext context) {
        super(context);
        this.dummyFunction = new JsFunction(context.scope());
        JsName declarationsObject = this.context().scope().declareName(Namer.nameForClassesVariable());
        this.classesVar = new JsVars.JsVar(declarationsObject);
        this.declarationsObjectRef = declarationsObject.makeRef();
    }

    @NotNull
    public JsVars.JsVar getDeclaration() {
        return this.classesVar;
    }

    public void generateDeclarations() {
        SmartList<JsVars.JsVar> vars = new SmartList<JsVars.JsVar>();
        SmartList<JsPropertyInitializer> propertyInitializers = new SmartList<JsPropertyInitializer>();
        this.generateOpenClassDeclarations(vars, propertyInitializers);
        this.generateFinalClassDeclarations();
        if (vars.isEmpty()) {
            if (!propertyInitializers.isEmpty()) {
                this.classesVar.setInitExpression(new JsObjectLiteral(propertyInitializers));
            }
            return;
        }
        this.dummyFunction.setBody(new JsBlock(new JsVars(vars, true), new JsReturn(new JsObjectLiteral(propertyInitializers))));
        this.classesVar.setInitExpression(new JsInvocation(this.dummyFunction));
    }

    private void generateOpenClassDeclarations(@NotNull List<JsVars.JsVar> vars, @NotNull List<JsPropertyInitializer> propertyInitializers) {
        LinkedList sortedOpenClasses = (LinkedList)DFS.topologicalOrder(this.openList, new DFS.Neighbors<OpenClassInfo>(){

            @Override
            @NotNull
            public Iterable<OpenClassInfo> getNeighbors(OpenClassInfo current) {
                LinkedList<OpenClassInfo> parents = new LinkedList<OpenClassInfo>();
                ClassDescriptor classDescriptor = BindingUtils.getClassDescriptor(ClassDeclarationTranslator.this.context().bindingContext(), current.declaration);
                Collection<JetType> superTypes = classDescriptor.getTypeConstructor().getSupertypes();
                for (JetType type : superTypes) {
                    ClassDescriptor descriptor = DescriptorUtils.getClassDescriptorForType(type);
                    OpenClassInfo item = (OpenClassInfo)ClassDeclarationTranslator.this.openClassDescriptorToItem.get(descriptor);
                    if (item == null) continue;
                    parents.add(item);
                }
                return parents;
            }
        });
        assert (sortedOpenClasses.size() == this.openList.size());
        Iterator it = sortedOpenClasses.descendingIterator();
        while (it.hasNext()) {
            OpenClassInfo item = (OpenClassInfo)it.next();
            JsExpression translatedDeclaration = new ClassTranslator(item.declaration, item.descriptor, this.classDescriptorToLabel, this.context()).translate();
            ClassDeclarationTranslator.generate(item, propertyInitializers, translatedDeclaration, vars);
        }
    }

    private void generateFinalClassDeclarations() {
        ClassAliasingMap aliasingMap = new ClassAliasingMap(){

            @Override
            public JsNameRef get(ClassDescriptor descriptor, ClassDescriptor referencedDescriptor) {
                OpenClassInfo item = (OpenClassInfo)ClassDeclarationTranslator.this.openClassDescriptorToItem.get(descriptor);
                return item == null ? null : item.qualifiedLabel;
            }
        };
        for (Pair<JetClassOrObject, JsInvocation> item : this.finalList) {
            new ClassTranslator((JetClassOrObject)item.first, aliasingMap, this.context()).translate((JsInvocation)item.second);
        }
    }

    private static void generate(@NotNull OpenClassInfo item, @NotNull List<JsPropertyInitializer> propertyInitializers, @NotNull JsExpression definition, @NotNull List<JsVars.JsVar> vars) {
        JsExpression value;
        if (item.label.getName() == null) {
            value = definition;
        } else {
            assert (item.label.getName() != null);
            vars.add(new JsVars.JsVar(item.label.getName(), definition));
            value = item.label;
        }
        propertyInitializers.add(new JsPropertyInitializer(item.label, value));
    }

    @NotNull
    public JsPropertyInitializer translate(@NotNull JetClassOrObject declaration) {
        JsExpressionImpl value;
        ClassDescriptor descriptor = BindingUtils.getClassDescriptor(this.context().bindingContext(), declaration);
        if (descriptor.getModality() == Modality.FINAL) {
            JsInvocation invocation = this.context().namer().classCreateInvocation(descriptor);
            this.finalList.add(new Pair<JetClassOrObject, JsInvocation>(declaration, invocation));
            value = invocation;
        } else {
            String label = this.localLabelGenerator.generate();
            JsNameRef labelRef = this.dummyFunction.getScope().declareName(label).makeRef();
            OpenClassInfo item = new OpenClassInfo((JetClass)declaration, descriptor, labelRef, new JsNameRef(labelRef.getIdent(), (JsExpression)this.declarationsObjectRef));
            this.openList.add(item);
            this.openClassDescriptorToItem.put(descriptor, item);
            value = item.qualifiedLabel;
        }
        return InitializerUtils.createPropertyInitializer(descriptor, value, this.context());
    }

    private static class OpenClassInfo {
        private final ClassDescriptor descriptor;
        private final JetClass declaration;
        private final JsNameRef label;
        private final JsNameRef qualifiedLabel;

        private OpenClassInfo(JetClass declaration, ClassDescriptor descriptor, JsNameRef label, JsNameRef qualifiedLabel) {
            this.descriptor = descriptor;
            this.declaration = declaration;
            this.label = label;
            this.qualifiedLabel = qualifiedLabel;
        }
    }

    private final class ClassDescriptorToLabel
    implements ClassAliasingMap {
        private ClassDescriptorToLabel() {
        }

        @Override
        @Nullable
        public JsNameRef get(ClassDescriptor descriptor, ClassDescriptor referencedDescriptor) {
            OpenClassInfo item = (OpenClassInfo)ClassDeclarationTranslator.this.openClassDescriptorToItem.get(descriptor);
            if (item == null) {
                return null;
            }
            return item.label;
        }
    }
}

