/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.InnerDeclarationTranslator;

class InnerFunctionTranslator
extends InnerDeclarationTranslator {
    private final FunctionDescriptor descriptor;

    public InnerFunctionTranslator(@NotNull FunctionDescriptor descriptor, @NotNull TranslationContext context, @NotNull JsFunction fun) {
        super(context, fun);
        this.descriptor = descriptor;
    }

    @NotNull
    public JsExpression translate(@NotNull JsNameRef nameRef, @NotNull TranslationContext outerContext) {
        return this.translate(nameRef, this.getThis(outerContext));
    }

    @Override
    protected JsExpression createExpression(@NotNull JsNameRef nameRef, @Nullable JsExpression self) {
        return nameRef;
    }

    @Override
    protected JsInvocation createInvocation(@NotNull JsNameRef nameRef, @Nullable JsExpression self) {
        return new JsInvocation((JsExpression)new JsNameRef("bind", (JsExpression)nameRef), new SmartList<JsExpression>(self));
    }

    @NotNull
    private JsExpression getThis(TranslationContext outerContext) {
        ClassDescriptor outerClassDescriptor = this.context.usageTracker().getOuterClassDescriptor();
        if (outerClassDescriptor != null && this.descriptor.getReceiverParameter() == null) {
            return outerContext.getThisObject(outerClassDescriptor);
        }
        return JsLiteral.NULL;
    }
}

