/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class PatternTranslator
extends AbstractTranslator {
    @NotNull
    public static PatternTranslator newInstance(@NotNull TranslationContext context) {
        return new PatternTranslator(context);
    }

    private PatternTranslator(@NotNull TranslationContext context) {
        super(context);
    }

    @NotNull
    public JsExpression translateIsExpression(@NotNull JetIsExpression expression) {
        JsExpression left = Translation.translateAsExpression(expression.getLeftHandSide(), this.context());
        JetTypeReference typeReference = expression.getTypeRef();
        assert (typeReference != null);
        JsExpression result = this.translateIsCheck(left, typeReference);
        if (expression.isNegated()) {
            return JsAstUtils.negated(result);
        }
        return result;
    }

    @NotNull
    public JsExpression translateIsCheck(@NotNull JsExpression subject, @NotNull JetTypeReference typeReference) {
        JsExpression result = this.translateAsIntrinsicTypeCheck(subject, typeReference);
        if (result != null) {
            return result;
        }
        return this.translateAsIsCheck(subject, typeReference);
    }

    @NotNull
    private JsExpression translateAsIsCheck(@NotNull JsExpression expressionToMatch, @NotNull JetTypeReference typeReference) {
        JsInvocation isCheck = new JsInvocation(this.context().namer().isOperationReference(), expressionToMatch, this.getClassReference(typeReference));
        if (this.isNullable(typeReference)) {
            return PatternTranslator.addNullCheck(expressionToMatch, isCheck);
        }
        return isCheck;
    }

    @Nullable
    private JsExpression translateAsIntrinsicTypeCheck(@NotNull JsExpression expressionToMatch, @NotNull JetTypeReference typeReference) {
        JsBinaryOperation result = null;
        JsName className = this.getClassReference(typeReference).getName();
        if (className.getIdent().equals("String")) {
            result = JsAstUtils.typeof(expressionToMatch, this.program().getStringLiteral("string"));
        }
        if (className.getIdent().equals("Int")) {
            result = JsAstUtils.typeof(expressionToMatch, this.program().getStringLiteral("number"));
        }
        return result;
    }

    @NotNull
    private static JsExpression addNullCheck(@NotNull JsExpression expressionToMatch, @NotNull JsInvocation isCheck) {
        return JsAstUtils.or(TranslationUtils.isNullCheck(expressionToMatch), isCheck);
    }

    private boolean isNullable(JetTypeReference typeReference) {
        return BindingUtils.getTypeByReference(this.bindingContext(), typeReference).isNullable();
    }

    @NotNull
    private JsNameRef getClassReference(@NotNull JetTypeReference typeReference) {
        return this.getClassNameReferenceForTypeReference(typeReference);
    }

    @NotNull
    private JsNameRef getClassNameReferenceForTypeReference(@NotNull JetTypeReference typeReference) {
        ClassDescriptor referencedClass = BindingUtils.getClassDescriptorForTypeReference(this.bindingContext(), typeReference);
        return TranslationUtils.getQualifiedReference(this.context(), referencedClass);
    }

    @NotNull
    public JsExpression translateExpressionPattern(@NotNull JsExpression expressionToMatch, @NotNull JetExpression patternExpression) {
        JsExpression expressionToMatchAgainst = this.translateExpressionForExpressionPattern(patternExpression);
        return JsAstUtils.equality(expressionToMatch, expressionToMatchAgainst);
    }

    @NotNull
    public JsExpression translateExpressionForExpressionPattern(@NotNull JetExpression patternExpression) {
        return Translation.translateAsExpression(patternExpression, this.context());
    }
}

