/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions.patterns;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.DescriptorPredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.NamePredicate;

public final class PatternBuilder {
    @NotNull
    private static final NamePredicate JET = new NamePredicate("jet");
    @NotNull
    private static final Name KOTLIN_NAME = Name.identifier(Namer.KOTLIN_LOWER_NAME);

    private PatternBuilder() {
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull NamePredicate checker, @NotNull String stringWithPattern) {
        ArrayList<NamePredicate> checkers = Lists.newArrayList(checker);
        checkers.addAll(PatternBuilder.parseStringAsCheckerList(stringWithPattern));
        return PatternBuilder.pattern(checkers);
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull String stringWithPattern, @NotNull NamePredicate checker) {
        ArrayList<NamePredicate> checkers = Lists.newArrayList(PatternBuilder.parseStringAsCheckerList(stringWithPattern));
        checkers.add(checker);
        return PatternBuilder.pattern(checkers);
    }

    @NotNull
    public static DescriptorPredicate pattern(@NotNull String string) {
        List<NamePredicate> checkers = PatternBuilder.parseStringAsCheckerList(string);
        return PatternBuilder.pattern(checkers);
    }

    @NotNull
    private static List<NamePredicate> parseStringAsCheckerList(@NotNull String stringWithPattern) {
        String[] subPatterns = stringWithPattern.split("\\.");
        ArrayList<NamePredicate> checkers = Lists.newArrayList();
        for (String subPattern : subPatterns) {
            String[] validNames = subPattern.split("\\|");
            checkers.add(new NamePredicate(validNames));
        }
        return checkers;
    }

    @NotNull
    private static DescriptorPredicate pattern(@NotNull List<NamePredicate> checkers) {
        assert (!checkers.isEmpty());
        final ArrayList<NamePredicate> checkersWithPrefixChecker = Lists.newArrayList();
        if (!checkers.get(0).apply(KOTLIN_NAME)) {
            checkersWithPrefixChecker.add(JET);
        }
        checkersWithPrefixChecker.addAll(checkers);
        assert (checkersWithPrefixChecker.size() > 1);
        return new DescriptorPredicate(){

            @Override
            public boolean apply(@NotNull FunctionDescriptor descriptor) {
                try {
                    return this.doApply(descriptor);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }

            private boolean doApply(@NotNull FunctionDescriptor descriptor) {
                List<Name> nameParts = DescriptorUtils.getFQName(descriptor).pathSegments();
                if (nameParts.size() != checkersWithPrefixChecker.size()) {
                    return false;
                }
                return this.allNamePartsValid(nameParts);
            }

            private boolean allNamePartsValid(@NotNull List<Name> nameParts) {
                for (int i = 0; i < nameParts.size(); ++i) {
                    Name namePart = nameParts.get(i);
                    NamePredicate correspondingPredicate = (NamePredicate)checkersWithPrefixChecker.get(i);
                    if (correspondingPredicate.apply(namePart)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @NotNull
    public static DescriptorPredicate pattern(NamePredicate ... checkers) {
        return PatternBuilder.pattern(Arrays.asList(checkers));
    }

    @NotNull
    public static DescriptorPredicateImpl pattern(String ... names) {
        return new DescriptorPredicateImpl(names);
    }

    @NotNull
    public static DescriptorPredicateImpl pattern(@NotNull String[] root, String ... names) {
        return new DescriptorPredicateImpl(names).root(root);
    }

    private static boolean isRootNamespace(DeclarationDescriptor declarationDescriptor) {
        return declarationDescriptor instanceof NamespaceDescriptor && DescriptorUtils.isRootNamespace((NamespaceDescriptor)declarationDescriptor);
    }

    public static class DescriptorPredicateImpl
    implements DescriptorPredicate {
        private final String[] names;
        private boolean receiverParameterExists;
        private String[] root;
        private boolean checkOverridden;

        public DescriptorPredicateImpl(String ... names) {
            this.names = names;
        }

        public DescriptorPredicateImpl receiverExists() {
            this.receiverParameterExists = true;
            return this;
        }

        public DescriptorPredicateImpl root(String ... root) {
            this.root = root;
            return this;
        }

        public DescriptorPredicateImpl checkOverridden() {
            this.checkOverridden = true;
            return this;
        }

        private boolean check(FunctionDescriptor functionDescriptor) {
            int nameIndex;
            String[] list;
            DeclarationDescriptor descriptor = functionDescriptor.getContainingDeclaration();
            if (this.root == null) {
                list = this.names;
                nameIndex = list.length - 2;
            } else {
                assert (this.names.length == 1);
                list = this.root;
                nameIndex = list.length - 1;
            }
            do {
                if (nameIndex == -1) {
                    return PatternBuilder.isRootNamespace(descriptor);
                }
                if (PatternBuilder.isRootNamespace(descriptor)) {
                    return false;
                }
                if (descriptor.getName().asString().equals(list[nameIndex--])) continue;
                return false;
            } while ((descriptor = descriptor.getContainingDeclaration()) != null);
            return false;
        }

        @Override
        public boolean apply(@NotNull FunctionDescriptor functionDescriptor) {
            DeclarationDescriptor descriptor;
            if (functionDescriptor.getReceiverParameter() == null == this.receiverParameterExists) {
                return false;
            }
            int nameIndex = this.names.length - 1;
            if (!functionDescriptor.getName().asString().equals(this.names[nameIndex--])) {
                return false;
            }
            if (functionDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                assert (functionDescriptor.getOverriddenDescriptors().size() > 0);
                descriptor = functionDescriptor.getOverriddenDescriptors().iterator().next();
            } else {
                descriptor = functionDescriptor;
            }
            String[] list = this.names;
            while ((descriptor = descriptor.getContainingDeclaration()) != null) {
                if (nameIndex == -1) {
                    if (PatternBuilder.isRootNamespace(descriptor)) {
                        return list == this.root || this.root == null;
                    }
                    if (this.root == null) {
                        return false;
                    }
                    nameIndex = this.root.length - 1;
                    list = this.root;
                } else if (PatternBuilder.isRootNamespace(descriptor)) {
                    return false;
                }
                if (descriptor.getName().asString().equals(list[nameIndex--])) continue;
                return this.checkOverridden && this.checkOverridden(functionDescriptor);
            }
            return false;
        }

        private boolean checkOverridden(FunctionDescriptor functionDescriptor) {
            Set<? extends FunctionDescriptor> overriddenDescriptors = functionDescriptor.getOverriddenDescriptors();
            if (overriddenDescriptors.isEmpty()) {
                return false;
            }
            for (FunctionDescriptor functionDescriptor2 : overriddenDescriptors) {
                if (functionDescriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                    for (FunctionDescriptor functionDescriptor3 : functionDescriptor2.getOverriddenDescriptors()) {
                        if (!this.check(functionDescriptor3) && !this.checkOverridden(functionDescriptor3)) continue;
                        return true;
                    }
                    continue;
                }
                if (!this.check(functionDescriptor2) && !this.checkOverridden(functionDescriptor2)) continue;
                return true;
            }
            return false;
        }
    }
}

