/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSafeQualifiedExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public abstract class CallType
extends Enum<CallType> {
    public static final /* enum */ CallType SAFE = new CallType(){

        @Override
        @NotNull
        JsExpression constructCall(@Nullable JsExpression receiver, @NotNull CallConstructor constructor, @NotNull TranslationContext context) {
            assert (receiver != null);
            JsConditional expression = TranslationUtils.notNullConditional(receiver, JsLiteral.NULL, context);
            expression.setThenExpression(constructor.construct(expression.getThenExpression()));
            return expression;
        }
    };
    public static final /* enum */ CallType NORMAL = new CallType(){

        @Override
        @NotNull
        JsExpression constructCall(@Nullable JsExpression receiver, @NotNull CallConstructor constructor, @NotNull TranslationContext context) {
            return constructor.construct(receiver);
        }
    };
    private static final /* synthetic */ CallType[] $VALUES;

    public static CallType[] values() {
        return (CallType[])$VALUES.clone();
    }

    public static CallType valueOf(String name) {
        return Enum.valueOf(CallType.class, name);
    }

    @NotNull
    abstract JsExpression constructCall(@Nullable JsExpression var1, @NotNull CallConstructor var2, @NotNull TranslationContext var3);

    @NotNull
    public static CallType getCallTypeForQualifiedExpression(@NotNull JetQualifiedExpression expression) {
        if (expression instanceof JetSafeQualifiedExpression) {
            return SAFE;
        }
        assert (expression instanceof JetDotQualifiedExpression);
        return NORMAL;
    }

    static {
        $VALUES = new CallType[]{SAFE, NORMAL};
    }

    public static interface CallConstructor {
        @NotNull
        public JsExpression construct(@Nullable JsExpression var1);
    }
}

