/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils;

import com.google.common.collect.Lists;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class TemporariesUtils {
    private TemporariesUtils() {
    }

    @NotNull
    public static List<TemporaryVariable> fromExpressionList(@NotNull List<JsExpression> expressions, @NotNull TranslationContext context) {
        ArrayList<TemporaryVariable> result = Lists.newArrayList();
        for (JsExpression expression : expressions) {
            result.add(context.declareTemporary(expression));
        }
        return result;
    }

    @NotNull
    public static List<JsExpression> toExpressionList(@NotNull List<TemporaryVariable> temporaries) {
        ArrayList<JsExpression> result = Lists.newArrayList();
        for (TemporaryVariable temp : temporaries) {
            result.add(temp.reference());
        }
        return result;
    }

    @NotNull
    public static JsExpression temporariesInitialization(TemporaryVariable ... temporaries) {
        ArrayList<JsExpression> result = Lists.newArrayList();
        for (TemporaryVariable temporary : temporaries) {
            result.add(temporary.assignmentExpression());
        }
        return JsAstUtils.newSequence(result);
    }

    @NotNull
    public static List<JsExpression> temporariesInitialization(@NotNull List<TemporaryVariable> temporaries) {
        ArrayList<JsExpression> result = Lists.newArrayList();
        for (TemporaryVariable temporary : temporaries) {
            result.add(temporary.assignmentExpression());
        }
        return result;
    }
}

