/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils.dangerous;

import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.utils.dangerous.FindDangerousVisitor;
import org.jetbrains.k2js.translate.utils.dangerous.FindPreviousVisitor;

public class DangerousData {
    @NotNull
    private final List<JetExpression> nodesToBeGeneratedBefore = Lists.newArrayList();
    private static final DangerousData EMPTY = new DangerousData(){

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public boolean shouldBeTranslated() {
            return false;
        }
    };
    @Nullable
    private JetExpression dangerousNode = null;
    @Nullable
    private JetExpression rootNode = null;

    @NotNull
    public static DangerousData collect(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        if (DangerousData.cantContainDangerousElements(expression)) {
            return DangerousData.emptyData();
        }
        return DangerousData.doCollectData(expression, context);
    }

    private static boolean cantContainDangerousElements(@NotNull JetElement element) {
        return element instanceof JetBlockExpression;
    }

    @NotNull
    private static DangerousData doCollectData(@NotNull JetExpression expression, @NotNull TranslationContext context) {
        DangerousData data = new DangerousData();
        FindDangerousVisitor visitor = new FindDangerousVisitor(context);
        expression.accept(visitor, data);
        if (!data.exists()) {
            return DangerousData.emptyData();
        }
        data.setRootNode(expression);
        FindPreviousVisitor findPreviousVisitor = new FindPreviousVisitor(data);
        expression.accept(findPreviousVisitor, data);
        return data;
    }

    @NotNull
    public static DangerousData emptyData() {
        return EMPTY;
    }

    public void setDangerousNode(@NotNull JetExpression dangerousNode) {
        assert (this.dangerousNode == null) : "Should be assigned only once";
        this.dangerousNode = dangerousNode;
    }

    @NotNull
    public List<JetExpression> getNodesToBeGeneratedBefore() {
        return this.nodesToBeGeneratedBefore;
    }

    public boolean exists() {
        return this.dangerousNode != null;
    }

    public boolean shouldBeTranslated() {
        return this.exists() && !this.nodesToBeGeneratedBefore.isEmpty();
    }

    @NotNull
    public JetExpression getDangerousNode() {
        assert (this.dangerousNode != null);
        return this.dangerousNode;
    }

    @NotNull
    public JetExpression getRootNode() {
        assert (this.rootNode != null);
        return this.rootNode;
    }

    public void setRootNode(@NotNull JetExpression rootNode) {
        this.rootNode = rootNode;
    }
}

