/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils.dangerous;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsVars;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.dangerous.DangerousData;

public final class DangerousTranslator
extends AbstractTranslator {
    @NotNull
    private final DangerousData data;

    @NotNull
    public static JsNode translate(@NotNull DangerousData data, @NotNull TranslationContext context) {
        assert (data.exists());
        return new DangerousTranslator(data, context).translate();
    }

    private DangerousTranslator(@NotNull DangerousData data, @NotNull TranslationContext context) {
        super(context);
        this.data = data;
    }

    @NotNull
    private JsNode translate() {
        Map<JetExpression, JsName> aliasesForExpressions = this.translateAllExpressionsAndCreateAliasesForThem(this.data.getNodesToBeGeneratedBefore());
        TranslationContext contextWithAliases = this.context().innerContextWithAliasesForExpressions(aliasesForExpressions);
        return Translation.doTranslateExpression(this.data.getRootNode(), contextWithAliases);
    }

    @NotNull
    private Map<JetExpression, JsName> translateAllExpressionsAndCreateAliasesForThem(@NotNull List<JetExpression> expressions) {
        THashMap<JetExpression, JsName> aliasesForExpressions = new THashMap<JetExpression, JsName>(expressions.size());
        ArrayList<JsVars.JsVar> vars = new ArrayList<JsVars.JsVar>(expressions.size());
        for (JetExpression expression : expressions) {
            JsExpression translatedExpression = Translation.translateAsExpression(expression, this.context());
            JsVars.JsVar aliasForExpression = this.context().dynamicContext().createTemporaryVar(translatedExpression);
            vars.add(aliasForExpression);
            aliasesForExpressions.put(expression, aliasForExpression.getName());
        }
        this.context().addStatementToCurrentBlock(new JsVars(vars, true));
        return aliasesForExpressions;
    }
}

