/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.utils.dangerous;

import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetTreeVisitor;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.dangerous.DangerousData;

public final class FindPreviousVisitor
extends JetTreeVisitor<DangerousData> {
    @NotNull
    private final Map<JetElement, Void> hasDangerous = Maps.newHashMap();

    public FindPreviousVisitor(@NotNull DangerousData data) {
        JetElement node = data.getDangerousNode();
        PsiElement last = data.getRootNode().getParent();
        while (node != last) {
            this.hasDangerous.put(node, null);
            PsiElement parent = node.getParent();
            assert (parent instanceof JetElement);
            node = (JetElement)parent;
        }
    }

    @Override
    public Void visitJetElement(JetElement element, DangerousData data) {
        if (data.getDangerousNode() == element) {
            return null;
        }
        if (!this.hasDangerous(element)) {
            FindPreviousVisitor.addElement(element, data);
        } else {
            this.acceptChildrenThatAreBeforeTheDangerousNode(element, data);
        }
        return null;
    }

    private static boolean addElement(@NotNull JetElement element, @NotNull DangerousData data) {
        if (element instanceof JetExpression) {
            data.getNodesToBeGeneratedBefore().add((JetExpression)element);
            return true;
        }
        return false;
    }

    private void acceptChildrenThatAreBeforeTheDangerousNode(@NotNull JetElement element, @NotNull DangerousData data) {
        for (PsiElement current = element.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (!(current instanceof JetElement)) continue;
            ((JetElement)current).accept(this, data);
            if (this.hasDangerous(element)) break;
        }
    }

    @Override
    public Void visitPrefixExpression(@NotNull JetPrefixExpression expression, @NotNull DangerousData data) {
        if (data.getDangerousNode() == expression) {
            return null;
        }
        if (!this.hasDangerous(expression)) {
            FindPreviousVisitor.addElement(expression, data);
            return null;
        }
        if (this.hasDangerous(PsiUtils.getBaseExpression(expression))) {
            return null;
        }
        throw new IllegalStateException();
    }

    @Override
    public Void visitCallExpression(@NotNull JetCallExpression expression, @NotNull DangerousData data) {
        if (data.getDangerousNode() == expression) {
            return null;
        }
        if (!this.hasDangerous(expression)) {
            data.getNodesToBeGeneratedBefore().add(expression);
        } else {
            this.acceptArgumentsThatAreBeforeDangerousNode(expression, data);
        }
        return null;
    }

    private void acceptArgumentsThatAreBeforeDangerousNode(@NotNull JetCallExpression expression, @NotNull DangerousData data) {
        for (ValueArgument valueArgument : expression.getValueArguments()) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            assert (argumentExpression != null);
            argumentExpression.accept(this, data);
            if (!this.hasDangerous(argumentExpression)) continue;
            break;
        }
    }

    private boolean hasDangerous(@NotNull JetElement element) {
        return this.hasDangerous.containsKey(element);
    }
}

