/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiResolveHelper;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationUtil {
    public static final Set<String> ALL_ANNOTATIONS;
    @NonNls
    private static final String[] SIMPLE_NAMES;

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        return AnnotationUtil.findAnnotation(listOwner, false, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, boolean skipExternal, String ... annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        if (annotationNames.length == 0) {
            return null;
        }
        Set<String> set = annotationNames.length == 1 ? Collections.singleton(annotationNames[0]) : new HashSet<String>(Arrays.asList(annotationNames));
        return AnnotationUtil.findAnnotation(listOwner, set, skipExternal);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, Collection<String> annotationNames) {
        return AnnotationUtil.findAnnotation(listOwner, annotationNames, false);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        PsiAnnotation[] allAnnotations;
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/AnnotationUtil", "findAnnotation"));
        }
        if (listOwner == null) {
            return null;
        }
        PsiModifierList list2 = listOwner.getModifierList();
        if (list2 == null) {
            return null;
        }
        for (PsiAnnotation annotation : allAnnotations = list2.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (!annotationNames.contains(qualifiedName)) continue;
            return annotation;
        }
        if (!skipExternal) {
            ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance(listOwner.getProject());
            for (String annotationName : annotationNames) {
                PsiAnnotation annotation;
                annotation = annotationsManager.findExternalAnnotation(listOwner, annotationName);
                if (annotation == null) continue;
                return annotation;
            }
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        PsiAnnotation directAnnotation = AnnotationUtil.findAnnotation(listOwner, annotationNames);
        if (directAnnotation != null) {
            return directAnnotation;
        }
        if (listOwner instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)listOwner;
            PsiClass aClass = method2.getContainingClass();
            if (aClass == null) {
                return null;
            }
            HierarchicalMethodSignature methodSignature = method2.getHierarchicalMethodSignature();
            return AnnotationUtil.findAnnotationInHierarchy(methodSignature, annotationNames, method2, null, JavaPsiFacade.getInstance(method2.getProject()).getResolveHelper());
        }
        if (listOwner instanceof PsiClass) {
            return AnnotationUtil.findAnnotationInHierarchy((PsiClass)listOwner, annotationNames, null);
        }
        if (listOwner instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)listOwner;
            return AnnotationUtil.doFindAnnotationInHierarchy(parameter, annotationNames, null);
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation doFindAnnotationInHierarchy(PsiParameter parameter, Set<String> annotationNames, @Nullable Set<PsiModifierListOwner> visited) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, annotationNames);
        if (annotation != null) {
            return annotation;
        }
        PsiElement scope = parameter.getDeclarationScope();
        if (!(scope instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method2 = (PsiMethod)scope;
        PsiClass aClass = method2.getContainingClass();
        PsiElement parent = parameter.getParent();
        if (aClass == null || !(parent instanceof PsiParameterList)) {
            return null;
        }
        int index = ((PsiParameterList)parent).getParameterIndex(parameter);
        HierarchicalMethodSignature methodSignature = method2.getHierarchicalMethodSignature();
        List<HierarchicalMethodSignature> superSignatures = methodSignature.getSuperSignatures();
        PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance(aClass.getProject());
        for (HierarchicalMethodSignature superSignature : superSignatures) {
            PsiAnnotation insuper;
            PsiParameter[] superParameters;
            PsiMethod superMethod = superSignature.getMethod();
            if (visited == null) {
                visited = new THashSet<PsiModifierListOwner>();
            }
            if (!visited.add(superMethod) || !resolveHelper.isAccessible(superMethod, parameter, null) || index >= (superParameters = superMethod.getParameterList().getParameters()).length || (insuper = AnnotationUtil.doFindAnnotationInHierarchy(superParameters[index], annotationNames, visited)) == null) continue;
            return insuper;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findAnnotationInHierarchy(@NotNull PsiClass psiClass, Set<String> annotationNames, @Nullable Set<PsiClass> processed) {
        PsiClass[] superClasses;
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        for (PsiClass superClass : superClasses = psiClass.getSupers()) {
            if (processed == null) {
                processed = new THashSet<PsiClass>();
            }
            if (!processed.add(superClass)) {
                return null;
            }
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)superClass, annotationNames);
            if (annotation != null) {
                return annotation;
            }
            PsiAnnotation annotationInHierarchy = AnnotationUtil.findAnnotationInHierarchy(superClass, annotationNames, processed);
            if (annotationInHierarchy == null) continue;
            return annotationInHierarchy;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findAnnotationInHierarchy(@NotNull HierarchicalMethodSignature signature, @NotNull Set<String> annotationNames, @NotNull PsiElement place, @Nullable Set<PsiMethod> processed, @NotNull PsiResolveHelper resolveHelper) {
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        if (annotationNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        if (resolveHelper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInsight/AnnotationUtil", "findAnnotationInHierarchy"));
        }
        List<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
        for (HierarchicalMethodSignature superSignature : superSignatures) {
            PsiMethod superMethod = superSignature.getMethod();
            if (processed == null) {
                processed = new THashSet<PsiMethod>();
            }
            if (!processed.add(superMethod) || !resolveHelper.isAccessible(superMethod, place, null)) continue;
            PsiAnnotation direct = AnnotationUtil.findAnnotation((PsiModifierListOwner)superMethod, annotationNames);
            if (direct != null) {
                return direct;
            }
            PsiAnnotation superResult = AnnotationUtil.findAnnotationInHierarchy(superSignature, annotationNames, place, processed, resolveHelper);
            if (superResult == null) continue;
            return superResult;
        }
        return null;
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, Collection<String> annotations, boolean checkHierarchy, boolean skipExternal) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        for (String annotation : annotations) {
            if (!AnnotationUtil.isAnnotated(listOwner, annotation, checkHierarchy, skipExternal)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls String annotationFQN, boolean checkHierarchy, boolean skipExternal) {
        if (listOwner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, checkHierarchy, skipExternal, null);
    }

    private static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls String annotationFQN, boolean checkHierarchy, boolean skipExternal, @Nullable Set<PsiMember> processed) {
        block11: {
            PsiClass[] superClasses;
            block12: {
                PsiMethod[] superMethods;
                if (listOwner == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/AnnotationUtil", "isAnnotated"));
                }
                if (!listOwner.isValid()) {
                    return false;
                }
                PsiModifierList modifierList = listOwner.getModifierList();
                if (modifierList == null) {
                    return false;
                }
                PsiAnnotation annotation = modifierList.findAnnotation(annotationFQN);
                if (annotation != null) {
                    return true;
                }
                if (!skipExternal && ExternalAnnotationsManager.getInstance(listOwner.getProject()).findExternalAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (!checkHierarchy) break block11;
                if (!(listOwner instanceof PsiMethod)) break block12;
                PsiMethod method2 = (PsiMethod)listOwner;
                if (processed == null) {
                    processed = new THashSet<PsiMember>();
                }
                if (!processed.add(method2)) {
                    return false;
                }
                for (PsiMethod superMethod : superMethods = method2.findSuperMethods()) {
                    if (!AnnotationUtil.isAnnotated(superMethod, annotationFQN, checkHierarchy, skipExternal, processed)) continue;
                    return true;
                }
                break block11;
            }
            if (!(listOwner instanceof PsiClass)) break block11;
            PsiClass clazz = (PsiClass)listOwner;
            if (processed == null) {
                processed = new THashSet<PsiMember>();
            }
            if (!processed.add(clazz)) {
                return false;
            }
            for (PsiClass superClass : superClasses = clazz.getSupers()) {
                if (!AnnotationUtil.isAnnotated(superClass, annotationFQN, checkHierarchy, skipExternal, processed)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        SIMPLE_NAMES = new String[]{"NotNull", "Nullable", "NonNls", "PropertyKey", "TestOnly", "Language", "Identifier", "Pattern", "PrintFormat", "RegExp", "Subst"};
        ALL_ANNOTATIONS = new HashSet<String>(2);
        ALL_ANNOTATIONS.add("org.jetbrains.annotations.Nullable");
        ALL_ANNOTATIONS.add("org.jetbrains.annotations.NotNull");
    }
}

