/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.ConcurrentHashSet;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.pico.IdeaPicoContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class MockComponentManager
extends UserDataHolderBase
implements ComponentManager {
    private final MessageBus myMessageBus;
    private final MutablePicoContainer myPicoContainer;
    private final Map<Class, Object> myComponents;

    public MockComponentManager(@Nullable PicoContainer parent, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/mock/MockComponentManager", "<init>"));
        }
        this.myMessageBus = MessageBusFactory.newMessageBus(this);
        this.myComponents = new HashMap<Class, Object>();
        this.myPicoContainer = new IdeaPicoContainer(parent){
            private Set<Object> myDisposableComponents;
            {
                this.myDisposableComponents = new ConcurrentHashSet<Object>();
            }

            @Override
            @Nullable
            public Object getComponentInstance(Object componentKey) {
                Object o = super.getComponentInstance(componentKey);
                if (o instanceof Disposable && o != MockComponentManager.this && this.myDisposableComponents.add(o)) {
                    Disposer.register(MockComponentManager.this, (Disposable)o);
                }
                return o;
            }
        };
        this.myPicoContainer.registerComponentInstance(this);
        Disposer.register(parentDisposable, this);
    }

    public <T> void registerService(Class<T> serviceInterface, Class<? extends T> serviceImplementation) {
        this.myPicoContainer.unregisterComponent(serviceInterface.getName());
        this.myPicoContainer.registerComponentImplementation(serviceInterface.getName(), serviceImplementation);
    }

    public <T> void registerService(Class<T> serviceInterface, T serviceImplementation) {
        this.myPicoContainer.registerComponentInstance(serviceInterface.getName(), serviceImplementation);
    }

    @Override
    public <T> T getComponent(@NotNull Class<T> interfaceClass) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockComponentManager", "getComponent"));
        }
        Object o = this.myPicoContainer.getComponentInstance(interfaceClass);
        return (T)(o != null ? o : this.myComponents.get(interfaceClass));
    }

    @Override
    @NotNull
    public MutablePicoContainer getPicoContainer() {
        MutablePicoContainer mutablePicoContainer = this.myPicoContainer;
        if (mutablePicoContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockComponentManager", "getPicoContainer"));
        }
        return mutablePicoContainer;
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        MessageBus messageBus = this.myMessageBus;
        if (messageBus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockComponentManager", "getMessageBus"));
        }
        return messageBus;
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public void dispose() {
    }

    @Override
    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/mock/MockComponentManager", "getExtensions"));
        }
        throw new UnsupportedOperationException("getExtensions()");
    }
}

