/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharsetToolkit {
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    public static final Charset UTF_16LE_CHARSET = Charset.forName("UTF-16LE");
    public static final Charset UTF_16BE_CHARSET = Charset.forName("UTF-16BE");
    public static final Charset UTF_32BE_CHARSET = Charset.forName("UTF-32BE");
    public static final Charset UTF_32LE_CHARSET = Charset.forName("UTF-32LE");
    public static final Charset UTF_16_CHARSET = Charset.forName("UTF-16");
    private final byte[] buffer;
    private final Charset defaultCharset;
    private boolean enforce8Bit;
    public static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    public static final byte[] UTF16LE_BOM = new byte[]{-1, -2};
    public static final byte[] UTF16BE_BOM = new byte[]{-2, -1};
    public static final byte[] UTF32BE_BOM = new byte[]{0, 0, -2, -1};
    public static final byte[] UTF32LE_BOM = new byte[]{-1, -2, 0, 0};
    @NonNls
    private static final Map<Charset, byte[]> CHARSET_TO_MANDATORY_BOM = new THashMap<Charset, byte[]>(2);

    public CharsetToolkit(@NotNull byte[] buffer, Charset defaultCharset) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/CharsetToolkit", "<init>"));
        }
        this.enforce8Bit = false;
        this.buffer = buffer;
        this.defaultCharset = defaultCharset == null ? CharsetToolkit.getDefaultSystemCharset() : defaultCharset;
    }

    public void setEnforce8Bit(boolean enforce) {
        this.enforce8Bit = enforce;
    }

    @NotNull
    public GuessedEncoding guessFromContent(int guess_length) {
        boolean highOrderBit = false;
        boolean validU8Char = true;
        int length = Math.min(this.buffer.length, guess_length);
        for (int i = 0; i < length; ++i) {
            byte b5;
            byte b0 = this.buffer[i];
            byte b1 = i + 1 >= length ? (byte)0 : this.buffer[i + 1];
            byte b2 = i + 2 >= length ? (byte)0 : this.buffer[i + 2];
            byte b3 = i + 3 >= length ? (byte)0 : this.buffer[i + 3];
            byte b4 = i + 4 >= length ? (byte)0 : this.buffer[i + 4];
            byte by = b5 = i + 5 >= length ? (byte)0 : this.buffer[i + 5];
            if (b0 < 0) {
                highOrderBit = true;
                if (CharsetToolkit.isTwoBytesSequence(b0)) {
                    if (!CharsetToolkit.isContinuationChar(b1)) {
                        validU8Char = false;
                    } else {
                        ++i;
                    }
                } else if (CharsetToolkit.isThreeBytesSequence(b0)) {
                    if (!CharsetToolkit.isContinuationChar(b1) || !CharsetToolkit.isContinuationChar(b2)) {
                        validU8Char = false;
                    } else {
                        i += 2;
                    }
                } else if (CharsetToolkit.isFourBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3))) {
                        validU8Char = false;
                    } else {
                        i += 3;
                    }
                } else if (CharsetToolkit.isFiveBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3) && CharsetToolkit.isContinuationChar(b4))) {
                        validU8Char = false;
                    } else {
                        i += 4;
                    }
                } else if (CharsetToolkit.isSixBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3) && CharsetToolkit.isContinuationChar(b4) && CharsetToolkit.isContinuationChar(b5))) {
                        validU8Char = false;
                    } else {
                        i += 5;
                    }
                } else {
                    validU8Char = false;
                }
            }
            if (!validU8Char) break;
        }
        if (!highOrderBit) {
            GuessedEncoding guessedEncoding = GuessedEncoding.SEVEN_BIT;
            if (guessedEncoding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "guessFromContent"));
            }
            return guessedEncoding;
        }
        if (validU8Char) {
            GuessedEncoding guessedEncoding = GuessedEncoding.VALID_UTF8;
            if (guessedEncoding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "guessFromContent"));
            }
            return guessedEncoding;
        }
        GuessedEncoding guessedEncoding = GuessedEncoding.INVALID_UTF8;
        if (guessedEncoding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "guessFromContent"));
        }
        return guessedEncoding;
    }

    @Nullable
    public Charset guessFromBOM() {
        return CharsetToolkit.guessFromBOM(this.buffer);
    }

    @Nullable
    public static Charset guessFromBOM(@NotNull byte[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/CharsetToolkit", "guessFromBOM"));
        }
        if (CharsetToolkit.hasUTF8Bom(buffer)) {
            return UTF8_CHARSET;
        }
        if (CharsetToolkit.hasUTF32BEBom(buffer)) {
            return UTF_32BE_CHARSET;
        }
        if (CharsetToolkit.hasUTF32LEBom(buffer)) {
            return UTF_32LE_CHARSET;
        }
        if (CharsetToolkit.hasUTF16LEBom(buffer)) {
            return UTF_16LE_CHARSET;
        }
        if (CharsetToolkit.hasUTF16BEBom(buffer)) {
            return UTF_16BE_CHARSET;
        }
        return null;
    }

    private static boolean isContinuationChar(byte b) {
        return -128 <= b && b <= -65;
    }

    private static boolean isTwoBytesSequence(byte b) {
        return -64 <= b && b <= -33;
    }

    private static boolean isThreeBytesSequence(byte b) {
        return -32 <= b && b <= -17;
    }

    private static boolean isFourBytesSequence(byte b) {
        return -16 <= b && b <= -9;
    }

    private static boolean isFiveBytesSequence(byte b) {
        return -8 <= b && b <= -5;
    }

    private static boolean isSixBytesSequence(byte b) {
        return -4 <= b && b <= -3;
    }

    @Nullable
    public static Charset getDefaultSystemCharset() {
        Charset charset = null;
        try {
            charset = Charset.forName(System.getProperty("file.encoding"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return charset;
    }

    public static boolean hasUTF8Bom(@NotNull byte[] bom) {
        if (bom == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/CharsetToolkit", "hasUTF8Bom"));
        }
        return ArrayUtil.startsWith(bom, UTF8_BOM);
    }

    public static boolean hasUTF16LEBom(@NotNull byte[] bom) {
        if (bom == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/CharsetToolkit", "hasUTF16LEBom"));
        }
        return ArrayUtil.startsWith(bom, UTF16LE_BOM);
    }

    public static boolean hasUTF16BEBom(@NotNull byte[] bom) {
        if (bom == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/CharsetToolkit", "hasUTF16BEBom"));
        }
        return ArrayUtil.startsWith(bom, UTF16BE_BOM);
    }

    public static boolean hasUTF32BEBom(@NotNull byte[] bom) {
        if (bom == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/CharsetToolkit", "hasUTF32BEBom"));
        }
        return ArrayUtil.startsWith(bom, UTF32BE_BOM);
    }

    public static boolean hasUTF32LEBom(@NotNull byte[] bom) {
        if (bom == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/CharsetToolkit", "hasUTF32LEBom"));
        }
        return ArrayUtil.startsWith(bom, UTF32LE_BOM);
    }

    @Nullable
    public static byte[] getMandatoryBom(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/CharsetToolkit", "getMandatoryBom"));
        }
        return CHARSET_TO_MANDATORY_BOM.get(charset);
    }

    public static boolean canHaveBom(@NotNull Charset charset, @NotNull byte[] bom) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/CharsetToolkit", "canHaveBom"));
        }
        if (bom == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/CharsetToolkit", "canHaveBom"));
        }
        return charset.equals(UTF8_CHARSET) && Arrays.equals(bom, UTF8_BOM) || Arrays.equals(CharsetToolkit.getMandatoryBom(charset), bom);
    }

    @Nullable
    public static Charset forName(@Nullable String name) {
        Charset charset = null;
        if (name != null) {
            try {
                charset = Charset.forName(name);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return charset;
    }

    static {
        CHARSET_TO_MANDATORY_BOM.put(UTF_16LE_CHARSET, UTF16LE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_16BE_CHARSET, UTF16BE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_32BE_CHARSET, UTF32BE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_32LE_CHARSET, UTF32LE_BOM);
    }

    public static enum GuessedEncoding {
        SEVEN_BIT,
        VALID_UTF8,
        INVALID_UTF8;

    }
}

