/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import java.util.LinkedHashSet;
import java.util.List;

public class InferenceIncorporationPhase {
    private static final Logger LOG = Logger.getInstance("#" + InferenceIncorporationPhase.class.getName());
    private final InferenceSession mySession;
    private PsiClassType myCapture;

    public InferenceIncorporationPhase(InferenceSession session) {
        this.mySession = session;
    }

    public void setCapture(PsiClassType capture) {
        this.myCapture = capture;
    }

    public boolean incorporate() {
        for (InferenceVariable inferenceVariable : this.mySession.getInferenceVariables()) {
            PsiSubstitutor substitutor;
            if (inferenceVariable.getInstantiation() != PsiType.NULL) continue;
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            List<PsiType> upperBounds = inferenceVariable.getBounds(InferenceBound.UPPER);
            List<PsiType> lowerBounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            this.eqEq(eqBounds);
            this.upDown(lowerBounds, upperBounds);
            this.upDown(eqBounds, upperBounds);
            this.upDown(lowerBounds, eqBounds);
            this.upUp(upperBounds);
            for (PsiType eqBound : eqBounds) {
                if (!this.mySession.isProperType(eqBound)) continue;
                substitutor = PsiSubstitutor.EMPTY.put(inferenceVariable.getParameter(), eqBound);
                for (PsiType upperBound : upperBounds) {
                    if (this.mySession.isProperType(upperBound)) continue;
                    this.addConstraint(new StrictSubtypingConstraint(substitutor.substitute(upperBound), eqBound));
                }
                for (PsiType lowerBound : lowerBounds) {
                    if (this.mySession.isProperType(lowerBound)) continue;
                    this.addConstraint(new StrictSubtypingConstraint(eqBound, substitutor.substitute(lowerBound)));
                }
                for (PsiType otherEqBound : eqBounds) {
                    if (eqBound == otherEqBound || this.mySession.isProperType(otherEqBound)) continue;
                    this.addConstraint(new TypeEqualityConstraint(substitutor.substitute(otherEqBound), eqBound));
                }
            }
            for (PsiType lowerBound : lowerBounds) {
                if (!this.mySession.isProperType(lowerBound)) continue;
                substitutor = PsiSubstitutor.EMPTY.put(inferenceVariable.getParameter(), lowerBound);
                for (PsiType upperBound : upperBounds) {
                    if (this.mySession.isProperType(upperBound)) continue;
                    this.addConstraint(new StrictSubtypingConstraint(substitutor.substitute(upperBound), lowerBound));
                }
            }
        }
        if (this.myCapture != null) {
            PsiClass gClass = this.myCapture.resolve();
            LOG.assertTrue(gClass != null);
            PsiTypeParameter[] parameters = gClass.getTypeParameters();
            PsiType[] typeArgs = this.myCapture.getParameters();
            LOG.assertTrue(parameters.length == typeArgs.length);
            for (int i = 0; i < typeArgs.length; ++i) {
                InferenceVariable inferenceVariable;
                PsiType aType = typeArgs[i];
                if (aType instanceof PsiCapturedWildcardType) {
                    aType = ((PsiCapturedWildcardType)aType).getWildcard();
                }
                LOG.assertTrue((inferenceVariable = this.mySession.getInferenceVariable(parameters[i])) != null);
                List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
                List<PsiType> upperBounds = inferenceVariable.getBounds(InferenceBound.UPPER);
                List<PsiType> lowerBounds = inferenceVariable.getBounds(InferenceBound.LOWER);
                if (aType instanceof PsiWildcardType) {
                    for (PsiType eqBound : eqBounds) {
                        if (!this.mySession.isProperType(eqBound)) continue;
                        return false;
                    }
                    PsiClassType[] paramBounds = parameters[i].getExtendsListTypes();
                    if (!((PsiWildcardType)aType).isBounded()) {
                        for (PsiType upperBound : upperBounds) {
                            if (!this.mySession.isProperType(upperBound)) continue;
                            for (PsiClassType paramBound : paramBounds) {
                                this.addConstraint(new StrictSubtypingConstraint(upperBound, paramBound));
                            }
                        }
                        for (PsiType lowerBound : lowerBounds) {
                            if (!this.mySession.isProperType(lowerBound)) continue;
                            return false;
                        }
                        continue;
                    }
                    if (((PsiWildcardType)aType).isExtends()) {
                        PsiType extendsBound = ((PsiWildcardType)aType).getExtendsBound();
                        for (PsiType upperBound : upperBounds) {
                            if (!this.mySession.isProperType(upperBound)) continue;
                            if (paramBounds.length == 1 && paramBounds[0].equalsToText("java.lang.Object") || paramBounds.length == 0) {
                                this.addConstraint(new StrictSubtypingConstraint(upperBound, extendsBound));
                                continue;
                            }
                            if (!extendsBound.equalsToText("java.lang.Object")) continue;
                            for (PsiClassType paramBound : paramBounds) {
                                this.addConstraint(new StrictSubtypingConstraint(upperBound, paramBound));
                            }
                        }
                        for (PsiType lowerBound : lowerBounds) {
                            if (!this.mySession.isProperType(lowerBound)) continue;
                            return false;
                        }
                        continue;
                    }
                    LOG.assertTrue(((PsiWildcardType)aType).isSuper());
                    PsiType superBound = ((PsiWildcardType)aType).getSuperBound();
                    for (PsiType upperBound : upperBounds) {
                        if (!this.mySession.isProperType(upperBound)) continue;
                        for (PsiClassType paramBound : paramBounds) {
                            this.addConstraint(new StrictSubtypingConstraint(paramBound, upperBound));
                        }
                    }
                    for (PsiType lowerBound : lowerBounds) {
                        if (!this.mySession.isProperType(lowerBound)) continue;
                        this.addConstraint(new StrictSubtypingConstraint(lowerBound, superBound));
                    }
                    continue;
                }
                inferenceVariable.addBound(aType, InferenceBound.EQ);
            }
        }
        return true;
    }

    boolean isFullyIncorporated() {
        boolean needFurtherIncorporation = false;
        for (InferenceVariable inferenceVariable : this.mySession.getInferenceVariables()) {
            if (inferenceVariable.getInstantiation() != PsiType.NULL) continue;
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            List<PsiType> upperBounds = inferenceVariable.getBounds(InferenceBound.UPPER);
            List<PsiType> lowerBounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            needFurtherIncorporation |= this.crossVariables(inferenceVariable, upperBounds, lowerBounds, InferenceBound.LOWER);
            needFurtherIncorporation |= this.crossVariables(inferenceVariable, lowerBounds, upperBounds, InferenceBound.UPPER);
            needFurtherIncorporation |= this.eqCrossVariables(inferenceVariable, eqBounds);
        }
        return !needFurtherIncorporation;
    }

    private boolean eqCrossVariables(InferenceVariable inferenceVariable, List<PsiType> eqBounds) {
        boolean needFurtherIncorporation = false;
        for (PsiType eqBound : eqBounds) {
            InferenceVariable inferenceVar = this.mySession.getInferenceVariable(eqBound);
            if (inferenceVar == null) continue;
            for (InferenceBound inferenceBound : InferenceBound.values()) {
                for (PsiType bound : inferenceVariable.getBounds(inferenceBound)) {
                    if (this.mySession.getInferenceVariable(bound) == inferenceVar) continue;
                    needFurtherIncorporation |= inferenceVar.addBound(bound, inferenceBound);
                }
                for (PsiType bound : inferenceVar.getBounds(inferenceBound)) {
                    if (this.mySession.getInferenceVariable(bound) == inferenceVariable) continue;
                    needFurtherIncorporation |= inferenceVariable.addBound(bound, inferenceBound);
                }
            }
        }
        return needFurtherIncorporation;
    }

    private boolean crossVariables(InferenceVariable inferenceVariable, List<PsiType> upperBounds, List<PsiType> lowerBounds, InferenceBound inferenceBound) {
        InferenceBound oppositeBound = inferenceBound == InferenceBound.LOWER ? InferenceBound.UPPER : InferenceBound.LOWER;
        boolean result = false;
        for (PsiType upperBound : upperBounds) {
            InferenceVariable inferenceVar = this.mySession.getInferenceVariable(upperBound);
            if (inferenceVar == null) continue;
            for (PsiType lowerBound : lowerBounds) {
                result |= inferenceVar.addBound(lowerBound, inferenceBound);
            }
            for (PsiType varUpperBound : inferenceVar.getBounds(oppositeBound)) {
                result |= inferenceVariable.addBound(varUpperBound, oppositeBound);
            }
        }
        return result;
    }

    private void upDown(List<PsiType> eqBounds, List<PsiType> upperBounds) {
        for (PsiType upperBound : upperBounds) {
            if (this.mySession.isProperType(upperBound)) continue;
            for (PsiType eqBound : eqBounds) {
                if (this.mySession.isProperType(eqBound)) continue;
                this.addConstraint(new StrictSubtypingConstraint(upperBound, eqBound));
            }
        }
    }

    private void eqEq(List<PsiType> eqBounds) {
        for (int i = 0; i < eqBounds.size(); ++i) {
            PsiType sBound = eqBounds.get(i);
            if (this.mySession.isProperType(sBound)) continue;
            for (int j = i + 1; j < eqBounds.size(); ++j) {
                PsiType tBound = eqBounds.get(j);
                if (this.mySession.isProperType(tBound)) continue;
                this.addConstraint(new TypeEqualityConstraint(tBound, sBound));
            }
        }
    }

    private boolean upUp(List<PsiType> upperBounds) {
        return InferenceIncorporationPhase.findParameterizationOfTheSameGenericClass(upperBounds, new Processor<Pair<PsiType, PsiType>>(){

            @Override
            public boolean process(Pair<PsiType, PsiType> pair) {
                PsiType sType = (PsiType)pair.first;
                PsiType tType = (PsiType)pair.second;
                if (!(InferenceIncorporationPhase.this.mySession.isProperType(sType) || InferenceIncorporationPhase.this.mySession.isProperType(tType) || sType instanceof PsiWildcardType || tType instanceof PsiWildcardType || sType == null || tType == null)) {
                    InferenceIncorporationPhase.this.addConstraint(new TypeEqualityConstraint(sType, tType));
                }
                return true;
            }
        });
    }

    public static boolean findParameterizationOfTheSameGenericClass(List<PsiType> upperBounds, Processor<Pair<PsiType, PsiType>> processor) {
        for (int i = 0; i < upperBounds.size(); ++i) {
            PsiType sBound = upperBounds.get(i);
            PsiClass sClass = PsiUtil.resolveClassInClassTypeOnly(sBound);
            if (sClass == null) continue;
            LinkedHashSet<PsiClass> superClasses = InheritanceUtil.getSuperClasses(sClass);
            superClasses.add(sClass);
            for (int j = i + 1; j < upperBounds.size(); ++j) {
                PsiType tBound = upperBounds.get(j);
                PsiClass tClass = PsiUtil.resolveClassInClassTypeOnly(tBound);
                if (tClass == null) continue;
                LinkedHashSet<PsiClass> tSupers = InheritanceUtil.getSuperClasses(tClass);
                tSupers.add(tClass);
                tSupers.retainAll(superClasses);
                for (PsiClass gClass : tSupers) {
                    PsiSubstitutor sSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(gClass, (PsiClassType)sBound);
                    PsiSubstitutor tSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(gClass, (PsiClassType)tBound);
                    for (PsiTypeParameter typeParameter : gClass.getTypeParameters()) {
                        PsiType tType;
                        PsiType sType = sSubstitutor.substitute(typeParameter);
                        if (processor.process(Pair.create(sType, tType = tSubstitutor.substitute(typeParameter)))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void addConstraint(ConstraintFormula constraint) {
        this.mySession.addConstraint(constraint);
    }
}

