/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariablesOrder;
import com.intellij.psi.impl.source.resolve.graphInference.LiftParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.CheckedExceptionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSession {
    private static final Logger LOG = Logger.getInstance("#" + InferenceSession.class.getName());
    private final Map<PsiTypeParameter, InferenceVariable> myInferenceVariables = new LinkedHashMap<PsiTypeParameter, InferenceVariable>();
    private final List<ConstraintFormula> myConstraints = new ArrayList<ConstraintFormula>();
    private PsiSubstitutor mySiteSubstitutor;
    private PsiManager myManager;
    private int myConstraintIdx = 0;
    private boolean myErased = false;
    private final InferenceIncorporationPhase myIncorporationPhase = new InferenceIncorporationPhase(this);
    private final PsiElement myContext;

    public InferenceSession(PsiTypeParameter[] typeParams, PsiType[] leftTypes, PsiType[] rightTypes, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.initBounds(typeParams);
        LOG.assertTrue(leftTypes.length == rightTypes.length);
        for (int i = 0; i < leftTypes.length; ++i) {
            PsiType rightType = this.mySiteSubstitutor.substitute(rightTypes[i]);
            if (rightType == null) continue;
            this.myConstraints.add(new TypeCompatibilityConstraint(leftTypes[i], rightType));
        }
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.initBounds(typeParams);
    }

    public void initExpressionConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiElement parent, PsiMethod method2) {
        Pair<PsiMethod, PsiCallExpression> pair;
        if (method2 == null && (pair = InferenceSession.getPair(parent)) != null) {
            method2 = (PsiMethod)pair.first;
        }
        if (parameters.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null || !InferenceSession.isPertinentToApplicability(args[i], method2)) continue;
                PsiType parameterType = InferenceSession.getParameterType(parameters, args, i, this.mySiteSubstitutor);
                this.myConstraints.add(new ExpressionCompatibilityConstraint(args[i], parameterType));
            }
        }
    }

    private static Pair<PsiMethod, PsiCallExpression> getPair(PsiElement parent) {
        Pair<PsiMethod, PsiSubstitutor> pair;
        if (parent instanceof PsiCallExpression && (pair = MethodCandidateInfo.getCurrentMethod(((PsiCallExpression)parent).getArgumentList())) != null) {
            return Pair.create(pair.first, (PsiCallExpression)parent);
        }
        return null;
    }

    public static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method2) {
        if (expr instanceof PsiLambdaExpression) {
            if (!((PsiLambdaExpression)expr).hasFormalParameterTypes()) {
                return false;
            }
            for (PsiExpression expression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)expr)) {
                if (InferenceSession.isPertinentToApplicability(expression, method2)) continue;
                return false;
            }
            if (method2 != null && method2.getTypeParameters().length > 0) {
                PsiElement gParent;
                PsiElement parent = PsiUtil.skipParenthesizedExprUp(expr.getParent());
                if (parent instanceof PsiExpressionList && (gParent = parent.getParent()) instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArgumentList().getTypeParameterElements().length == 0) {
                    PsiType paramType;
                    PsiParameter[] parameters;
                    int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)parent, expr);
                    if (idx > (parameters = method2.getParameterList().getParameters()).length - 1) {
                        PsiType lastParamType = parameters[parameters.length - 1].getType();
                        paramType = parameters[parameters.length - 1].isVarArgs() ? ((PsiEllipsisType)lastParamType).getComponentType() : lastParamType;
                    } else {
                        paramType = parameters[idx].getType();
                    }
                    PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(paramType);
                    if (psiClass instanceof PsiTypeParameter && ((PsiTypeParameter)psiClass).getOwner() == method2) {
                        return false;
                    }
                }
                for (PsiExpression expression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)expr)) {
                    if (!PsiPolyExpressionUtil.isPolyExpression(expression)) continue;
                    return false;
                }
            }
            return true;
        }
        if (expr instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)expr).isExact();
        }
        if (expr instanceof PsiParenthesizedExpression) {
            return InferenceSession.isPertinentToApplicability(((PsiParenthesizedExpression)expr).getExpression(), method2);
        }
        if (expr instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            if (!InferenceSession.isPertinentToApplicability(thenExpression, method2)) {
                return false;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            if (!InferenceSession.isPertinentToApplicability(elseExpression, method2)) {
                return false;
            }
        }
        return true;
    }

    private static PsiType getParameterType(PsiParameter[] parameters, PsiExpression[] args, int i, PsiSubstitutor substitutor) {
        PsiType parameterType = substitutor.substitute(parameters[i < parameters.length ? i : parameters.length - 1].getType());
        if (parameterType instanceof PsiEllipsisType && (args.length != parameters.length || PsiPolyExpressionUtil.isPolyExpression(args[i]) || args[i] != null && !(args[i].getType() instanceof PsiArrayType))) {
            parameterType = ((PsiEllipsisType)parameterType).getComponentType();
        }
        return parameterType;
    }

    @NotNull
    public PsiSubstitutor infer() {
        PsiSubstitutor psiSubstitutor = this.infer(null, null, null);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent) {
        PsiSubstitutor psiSubstitutor = this.infer(parameters, args, parent, DefaultParameterTypeInferencePolicy.INSTANCE);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent, ParameterTypeInferencePolicy policy) {
        PsiSubstitutor psiSubstitutor = this.infer(parameters, args, parent, false, policy);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent, boolean acceptNonPertinentArgs, ParameterTypeInferencePolicy policy) {
        if (!this.repeatInferencePhases(parameters == null || !policy.allowPostponeInference())) {
            PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
            }
            return psiSubstitutor;
        }
        this.resolveBounds(this.myInferenceVariables.values(), this.mySiteSubstitutor, !policy.allowPostponeInference());
        Pair<PsiMethod, PsiCallExpression> pair = InferenceSession.getPair(parent);
        if (pair != null) {
            this.initReturnTypeConstraint((PsiMethod)pair.first, (PsiCallExpression)parent);
            for (InferenceVariable inferenceVariable : this.myInferenceVariables.values()) {
                inferenceVariable.ignoreInstantiation();
            }
            if (!this.repeatInferencePhases(true)) {
                PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
                if (psiSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
                }
                return psiSubstitutor;
            }
            PsiSubstitutor substitutor = this.resolveBounds(this.myInferenceVariables.values(), this.mySiteSubstitutor, !policy.allowPostponeInference());
            LOG.assertTrue(parent != null);
            PsiExpressionList argumentList = ((PsiCallExpression)parent).getArgumentList();
            LOG.assertTrue(argumentList != null);
            MethodCandidateInfo.updateSubstitutor(argumentList, substitutor);
        }
        if (parameters != null && args != null && (acceptNonPertinentArgs || pair != null)) {
            HashSet<ConstraintFormula> additionalConstraints = new HashSet<ConstraintFormula>();
            if (parameters.length > 0) {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] == null) continue;
                    PsiType parameterType = InferenceSession.getParameterType(parameters, args, i, this.mySiteSubstitutor);
                    if (pair == null || !InferenceSession.isPertinentToApplicability(args[i], (PsiMethod)pair.first)) {
                        additionalConstraints.add(new ExpressionCompatibilityConstraint(args[i], parameterType));
                    }
                    additionalConstraints.add(new CheckedExceptionCompatibilityConstraint(args[i], parameterType));
                }
            }
            if (!additionalConstraints.isEmpty()) {
                for (InferenceVariable inferenceVariable : this.myInferenceVariables.values()) {
                    inferenceVariable.ignoreInstantiation();
                }
                if (!this.proceedWithAdditionalConstraints(additionalConstraints)) {
                    PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
                    if (psiSubstitutor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
                    }
                    return psiSubstitutor;
                }
            }
        }
        for (InferenceVariable inferenceVariable : this.myInferenceVariables.values()) {
            inferenceVariable.ignoreInstantiation();
        }
        this.mySiteSubstitutor = this.resolveBounds(this.myInferenceVariables.values(), this.mySiteSubstitutor, !policy.allowPostponeInference());
        PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    private PsiSubstitutor prepareSubstitution() {
        for (InferenceVariable inferenceVariable : this.myInferenceVariables.values()) {
            PsiTypeParameter typeParameter = inferenceVariable.getParameter();
            PsiType instantiation = inferenceVariable.getInstantiation();
            if (instantiation != PsiType.NULL) continue;
            this.mySiteSubstitutor = this.mySiteSubstitutor.put(typeParameter, JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(typeParameter));
        }
        return this.mySiteSubstitutor;
    }

    private boolean isInsideRecursiveCall(PsiTypeParameter parameter) {
        PsiModifierListOwner staticContainer;
        PsiTypeParameterListOwner parameterOwner = parameter.getOwner();
        return this.myContext != null && PsiTreeUtil.isAncestor(parameterOwner, this.myContext, true) && ((staticContainer = PsiUtil.getEnclosingStaticElement(this.myContext, null)) == null || PsiTreeUtil.isAncestor(staticContainer, parameterOwner, false));
    }

    public void initBounds(PsiTypeParameter ... typeParameters) {
        for (PsiTypeParameter parameter : typeParameters) {
            PsiClassType[] extendsListTypes;
            if (this.myInferenceVariables.containsKey(parameter)) continue;
            InferenceVariable variable = new InferenceVariable(parameter);
            boolean added = false;
            for (PsiType classType : extendsListTypes = parameter.getExtendsListTypes()) {
                if (this.isProperType(classType = this.mySiteSubstitutor.substitute(classType))) {
                    added = true;
                }
                variable.addBound(classType, InferenceBound.UPPER);
            }
            if (!added) {
                variable.addBound(PsiType.getJavaLangObject(parameter.getManager(), parameter.getResolveScope()), InferenceBound.UPPER);
            }
            this.myInferenceVariables.put(parameter, variable);
        }
    }

    public void addCapturedVariable(PsiTypeParameter param) {
        this.initBounds(param);
    }

    private void initReturnTypeConstraint(PsiMethod method2, final PsiCallExpression context) {
        PsiType returnType2;
        if ((PsiPolyExpressionUtil.isMethodCallPolyExpression(context, method2) || context instanceof PsiNewExpression && PsiDiamondType.ourDiamondGuard.currentStack().contains(context)) && !PsiType.VOID.equals(returnType2 = method2.getReturnType()) && returnType2 != null) {
            returnType2 = PsiImplUtil.normalizeWildcardTypeByPosition(returnType2, context);
            PsiType targetType = PsiTypesUtil.getExpectedTypeByParent(context);
            if (targetType == null) {
                final PsiType finalReturnType = returnType2;
                targetType = PsiResolveHelper.ourGraphGuard.doPreventingRecursion(context, false, new Computable<PsiType>(){

                    @Override
                    public PsiType compute() {
                        return InferenceSession.this.getTargetType(context, finalReturnType);
                    }
                });
            }
            if (targetType != null) {
                this.registerConstraints(returnType2, targetType);
            }
        }
        for (PsiClassType thrownType : method2.getThrowsList().getReferencedTypes()) {
            InferenceVariable variable = this.getInferenceVariable(thrownType);
            if (variable == null) continue;
            variable.setThrownBound();
        }
    }

    public void registerConstraints(PsiType returnType2, PsiType targetType) {
        InferenceVariable inferenceVariable = this.shouldResolveAndInstantiate(returnType2, targetType);
        if (inferenceVariable != null) {
            this.resolveBounds(Collections.singletonList(inferenceVariable), this.mySiteSubstitutor, true);
            this.myConstraints.add(new TypeCompatibilityConstraint(inferenceVariable.getInstantiation(), returnType2));
        } else {
            if (targetType instanceof PsiClassType && ((PsiClassType)targetType).isRaw()) {
                this.setErased();
            }
            this.myConstraints.add(new TypeCompatibilityConstraint(this.myErased ? TypeConversionUtil.erasure(targetType) : GenericsUtil.eliminateWildcards(targetType, false), returnType2));
        }
    }

    private InferenceVariable shouldResolveAndInstantiate(PsiType returnType2, PsiType targetType) {
        InferenceVariable inferenceVariable = this.getInferenceVariable(returnType2);
        if (inferenceVariable != null) {
            if (targetType instanceof PsiPrimitiveType && InferenceSession.hasPrimitiveWrapperBound(inferenceVariable)) {
                return inferenceVariable;
            }
            if (targetType instanceof PsiClassType && (this.myErased || InferenceSession.hasUncheckedBounds(inferenceVariable, (PsiClassType)targetType) || InferenceSession.hasWildcardParameterization(inferenceVariable, (PsiClassType)targetType))) {
                return inferenceVariable;
            }
        }
        return null;
    }

    private static boolean hasPrimitiveWrapperBound(InferenceVariable inferenceVariable) {
        InferenceBound[] boundTypes;
        for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.UPPER, InferenceBound.LOWER}) {
            List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
            for (PsiType bound : bounds) {
                if (PsiPrimitiveType.getUnboxedType(bound) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasUncheckedBounds(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!targetType.isRaw()) {
            InferenceBound[] boundTypes;
            for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.EQ, InferenceBound.LOWER}) {
                List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
                for (PsiType bound : bounds) {
                    if (!TypeCompatibilityConstraint.isUncheckedConversion(targetType, bound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasWildcardParameterization(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (FunctionalInterfaceParameterizationUtil.isWildcardParameterized(targetType)) {
            Processor<Pair<PsiType, PsiType>> differentParameterizationProcessor;
            List<PsiType> bounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            if (InferenceIncorporationPhase.findParameterizationOfTheSameGenericClass(bounds, differentParameterizationProcessor = new Processor<Pair<PsiType, PsiType>>(){

                @Override
                public boolean process(Pair<PsiType, PsiType> pair) {
                    return pair.first == null || pair.second == null || ((PsiType)pair.first).equals(pair.second);
                }
            })) {
                return true;
            }
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            for (PsiType lowBound : bounds) {
                if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(lowBound)) continue;
                for (PsiType bound : eqBounds) {
                    if (!lowBound.equals(bound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private PsiType getTargetType(final PsiExpression context, PsiType returnType2) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(context.getParent());
        if (parent instanceof PsiExpressionList) {
            PsiExpressionList argumentList;
            PsiElement gParent = parent.getParent();
            if (gParent instanceof PsiCallExpression && (argumentList = ((PsiCallExpression)gParent).getArgumentList()) != null) {
                Pair<PsiMethod, PsiSubstitutor> pair = MethodCandidateInfo.getCurrentMethod(argumentList);
                if (pair == null) {
                    MethodResolverProcessor processor = new MethodResolverProcessor((PsiCallExpression)gParent, argumentList, context.getContainingFile()){

                        @Override
                        protected PsiType[] getExpressionTypes(PsiExpressionList argumentList) {
                            if (argumentList != null) {
                                PsiExpression[] expressions = argumentList.getExpressions();
                                int idx = LambdaUtil.getLambdaIdx(argumentList, context);
                                PsiType[] types = PsiType.createArray(expressions.length);
                                for (int i = 0; i < expressions.length; ++i) {
                                    types[i] = i != idx ? expressions[i].getType() : PsiType.NULL;
                                }
                                return types;
                            }
                            return null;
                        }
                    };
                    try {
                        PsiScopesUtil.setupAndRunProcessor(processor, (PsiCallExpression)gParent, false);
                    }
                    catch (MethodProcessorSetupFailedException e) {
                        return null;
                    }
                    JavaResolveResult[] results = processor.getResult();
                    return results.length == 1 ? this.getTypeByMethod(context, argumentList, null, results[0], results[0].getElement()) : null;
                }
                return this.getTypeByMethod(context, argumentList, pair, null, (PsiElement)pair.first);
            }
        } else {
            if (parent instanceof PsiConditionalExpression) {
                PsiType targetType = PsiTypesUtil.getExpectedTypeByParent((PsiExpression)parent);
                if (targetType == null) {
                    targetType = this.getTargetType((PsiExpression)parent, returnType2);
                }
                return targetType;
            }
            if (parent instanceof PsiLambdaExpression) {
                return LambdaUtil.getFunctionalInterfaceReturnType(((PsiLambdaExpression)parent).getFunctionalInterfaceType());
            }
        }
        return null;
    }

    private PsiType getTypeByMethod(PsiExpression context, PsiExpressionList argumentList, Pair<PsiMethod, PsiSubstitutor> pair, JavaResolveResult result, PsiElement parentMethod) {
        if (parentMethod instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)parentMethod).getParameterList().getParameters();
            if (parameters.length == 0) {
                return null;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (!((PsiMethod)parentMethod).isVarArgs() && parameters.length != args.length) {
                return null;
            }
            PsiElement arg = context;
            while (arg.getParent() instanceof PsiParenthesizedExpression) {
                arg = arg.getParent();
            }
            int i = ArrayUtilRt.find(args, arg);
            if (i < 0) {
                return null;
            }
            if (pair != null) {
                return InferenceSession.getParameterType(parameters, args, i, (PsiSubstitutor)pair.second);
            }
            args[i] = null;
            PsiSubstitutor substitutor = ((MethodCandidateInfo)result).inferSubstitutorFromArgs(LiftParameterTypeInferencePolicy.INSTANCE, args);
            Set<PsiTypeParameter> typeParameters = substitutor.getSubstitutionMap().keySet();
            this.initBounds(typeParameters.toArray(new PsiTypeParameter[typeParameters.size()]));
            return InferenceSession.getParameterType(parameters, args, i, substitutor);
        }
        return null;
    }

    public InferenceVariable getInferenceVariable(PsiType psiType) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(psiType);
        if (psiClass instanceof PsiTypeParameter) {
            return this.myInferenceVariables.get(psiClass);
        }
        return null;
    }

    public boolean isProperType(@Nullable PsiType type) {
        return this.collectDependencies(type, null);
    }

    public boolean collectDependencies(@Nullable PsiType type, final @Nullable Set<InferenceVariable> dependencies) {
        if (type == null) {
            return true;
        }
        Boolean isProper = type.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitType(PsiType type) {
                return true;
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }

            @Override
            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound == null) {
                    return true;
                }
                return bound.accept(this);
            }

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                InferenceVariable inferenceVariable = InferenceSession.this.getInferenceVariable(classType);
                if (inferenceVariable != null) {
                    if (dependencies != null) {
                        dependencies.add(inferenceVariable);
                        return true;
                    }
                    return false;
                }
                for (PsiType psiType : classType.getParameters()) {
                    if (psiType.accept(this).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        });
        return dependencies != null ? !dependencies.isEmpty() : isProper;
    }

    public boolean repeatInferencePhases(boolean incorporate) {
        do {
            if (this.reduceConstraints()) continue;
            return false;
        } while (this.myConstraintIdx < this.myConstraints.size());
        do {
            if (!this.reduceConstraints()) {
                return false;
            }
            if (!incorporate || this.myIncorporationPhase.incorporate()) continue;
            return false;
        } while (incorporate && !this.myIncorporationPhase.isFullyIncorporated() || this.myConstraintIdx < this.myConstraints.size());
        return true;
    }

    private boolean reduceConstraints() {
        ArrayList<ConstraintFormula> newConstraints = new ArrayList<ConstraintFormula>();
        for (int i = this.myConstraintIdx; i < this.myConstraints.size(); ++i) {
            ConstraintFormula constraint = this.myConstraints.get(i);
            if (constraint.reduce(this, newConstraints)) continue;
            return false;
        }
        this.myConstraintIdx = this.myConstraints.size();
        for (ConstraintFormula constraint : newConstraints) {
            this.addConstraint(constraint);
        }
        return true;
    }

    protected PsiSubstitutor resolveBounds(boolean acceptInitialUpperBound) {
        return this.resolveBounds(this.getInferenceVariables(), this.mySiteSubstitutor, acceptInitialUpperBound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PsiSubstitutor resolveBounds(Collection<InferenceVariable> inferenceVariables, PsiSubstitutor substitutor, boolean acceptInitialUpperBound) {
        List<List<InferenceVariable>> independentVars = InferenceVariablesOrder.resolveOrder(inferenceVariables, this);
        for (List<InferenceVariable> variables : independentVars) {
            for (InferenceVariable inferenceVariable : variables) {
                PsiTypeParameter typeParameter = inferenceVariable.getParameter();
                try {
                    if (inferenceVariable.getInstantiation() != PsiType.NULL) continue;
                    List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
                    List<PsiType> lowerBounds = inferenceVariable.getBounds(InferenceBound.LOWER);
                    List<PsiType> upperBounds = inferenceVariable.getBounds(InferenceBound.UPPER);
                    if (this.myErased && eqBounds.contains(null) || upperBounds.contains(null)) {
                        inferenceVariable.setInstantiation(null);
                        continue;
                    }
                    PsiType bound = null;
                    if (eqBounds.size() > 1) {
                        Iterator<PsiType> iterator2 = eqBounds.iterator();
                        while (iterator2.hasNext()) {
                            PsiType unsubstBound = iterator2.next();
                            PsiType eqBound = this.substituteNonProperBound(unsubstBound, substitutor);
                            if (PsiUtil.resolveClassInType(eqBound) == typeParameter || (!(bound instanceof PsiCapturedWildcardType) || !bound.equals(unsubstBound)) && Comparing.equal(bound, eqBound)) {
                                iterator2.remove();
                                continue;
                            }
                            if (bound != null) continue;
                            bound = eqBound;
                        }
                        if (eqBounds.size() > 1) continue;
                    }
                    PsiType psiType = bound = eqBounds.isEmpty() ? null : this.substituteNonProperBound(eqBounds.get(0), substitutor);
                    if (bound != null) {
                        inferenceVariable.setInstantiation(bound);
                        continue;
                    }
                    PsiType lub = null;
                    for (PsiType lowerBound : lowerBounds) {
                        if (!this.isProperType(lowerBound = this.substituteNonProperBound(lowerBound, substitutor))) continue;
                        if (lub == null) {
                            lub = lowerBound;
                            continue;
                        }
                        lub = GenericsUtil.getLeastUpperBound(lub, lowerBound, this.myManager);
                    }
                    if (lub != null) {
                        inferenceVariable.setInstantiation(lub instanceof PsiCapturedWildcardType ? ((PsiCapturedWildcardType)lub).getWildcard() : lub);
                        continue;
                    }
                    boolean inferred = false;
                    PsiType glb = null;
                    if (inferenceVariable.isThrownBound() && InferenceSession.isThrowable(upperBounds)) {
                        glb = PsiType.getJavaLangRuntimeException(this.myManager, GlobalSearchScope.allScope(this.myManager.getProject()));
                        inferred = true;
                    } else {
                        int boundCandidatesNumber = 0;
                        for (PsiType upperBound : upperBounds) {
                            PsiType substitutedBound = this.substituteNonProperBound(upperBound, substitutor);
                            if (!this.isProperType(substitutedBound)) continue;
                            ++boundCandidatesNumber;
                            if (!upperBound.equals(substitutedBound)) {
                                inferred = true;
                            }
                            if (glb == null) {
                                glb = substitutedBound;
                                continue;
                            }
                            glb = GenericsUtil.getGreatestLowerBound(glb, substitutedBound);
                        }
                        if (!inferred) {
                            boolean bl = inferred = boundCandidatesNumber > typeParameter.getExtendsListTypes().length && (typeParameter.getExtendsListTypes().length > 0 || boundCandidatesNumber > 1);
                        }
                    }
                    if (glb == null || (!acceptInitialUpperBound || this.isInsideRecursiveCall(typeParameter)) && !inferred) continue;
                    inferenceVariable.setInstantiation(glb);
                }
                finally {
                    PsiType instantiation = inferenceVariable.getInstantiation();
                    if (instantiation == PsiType.NULL) continue;
                    substitutor = substitutor.put(typeParameter, instantiation);
                }
            }
        }
        return substitutor;
    }

    private static boolean isThrowable(List<PsiType> upperBounds) {
        boolean commonThrowable = false;
        for (PsiType upperBound : upperBounds) {
            if (upperBound.equalsToText("java.lang.Object")) continue;
            if (upperBound.equalsToText("java.lang.Exception") || upperBound.equalsToText("java.lang.Throwable")) {
                commonThrowable = true;
                continue;
            }
            return false;
        }
        return commonThrowable;
    }

    private PsiType substituteNonProperBound(PsiType bound, PsiSubstitutor substitutor) {
        return this.isProperType(bound) ? bound : substitutor.substitute(bound);
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public GlobalSearchScope getScope() {
        return GlobalSearchScope.allScope(this.myManager.getProject());
    }

    public Collection<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables.values();
    }

    public void addConstraint(ConstraintFormula constraint) {
        if (!this.myConstraints.contains(constraint)) {
            this.myConstraints.add(constraint);
        }
    }

    public Collection<PsiTypeParameter> getTypeParams() {
        return this.myInferenceVariables.keySet();
    }

    private boolean proceedWithAdditionalConstraints(Set<ConstraintFormula> additionalConstraints) {
        while (!additionalConstraints.isEmpty()) {
            HashSet<InferenceVariable> varsToResolve = new HashSet<InferenceVariable>();
            Set<ConstraintFormula> subset = this.buildSubset(additionalConstraints, varsToResolve);
            PsiSubstitutor substitutor = this.resolveBounds(varsToResolve, this.mySiteSubstitutor, true);
            if (this.myContext instanceof PsiCallExpression) {
                PsiExpressionList argumentList = ((PsiCallExpression)this.myContext).getArgumentList();
                LOG.assertTrue(argumentList != null);
                MethodCandidateInfo.updateSubstitutor(argumentList, substitutor);
            }
            for (ConstraintFormula additionalConstraint : subset) {
                additionalConstraint.apply(substitutor);
            }
            this.myConstraints.addAll(subset);
            if (this.repeatInferencePhases(true)) continue;
            return false;
        }
        return true;
    }

    private Set<ConstraintFormula> buildSubset(Set<ConstraintFormula> additionalConstraints, Set<InferenceVariable> varsToResolve) {
        Set<InferenceVariable> inputVariables;
        HashSet<ConstraintFormula> subset = new HashSet<ConstraintFormula>();
        HashSet<InferenceVariable> outputVariables = new HashSet<InferenceVariable>();
        for (ConstraintFormula constraint : additionalConstraints) {
            Set<InferenceVariable> outputVars;
            if (!(constraint instanceof InputOutputConstraintFormula) || (outputVars = ((InputOutputConstraintFormula)constraint).getOutputVariables(inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this), this)) == null) continue;
            outputVariables.addAll(outputVars);
        }
        for (ConstraintFormula constraint : additionalConstraints) {
            if (constraint instanceof InputOutputConstraintFormula) {
                inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this);
                if (inputVariables != null) {
                    boolean dependsOnOutput = false;
                    for (InferenceVariable inputVariable : inputVariables) {
                        Set<InferenceVariable> dependencies = inputVariable.getDependencies(this);
                        dependencies.add(inputVariable);
                        dependencies.retainAll(outputVariables);
                        if (dependencies.isEmpty()) continue;
                        dependsOnOutput = true;
                        break;
                    }
                    if (dependsOnOutput) continue;
                    subset.add(constraint);
                    for (InferenceVariable variable : inputVariables) {
                        varsToResolve.addAll(variable.getDependencies(this));
                        varsToResolve.add(variable);
                    }
                    continue;
                }
                subset.add(constraint);
                continue;
            }
            subset.add(constraint);
        }
        if (subset.isEmpty()) {
            subset.add(additionalConstraints.iterator().next());
        }
        additionalConstraints.removeAll(subset);
        return subset;
    }

    public void setErased() {
        this.myErased = true;
    }

    public InferenceVariable getInferenceVariable(PsiTypeParameter parameter) {
        return this.myInferenceVariables.get(parameter);
    }

    public static boolean isMoreSpecific(PsiMethod m1, PsiMethod m2, PsiSubstitutor siteSubstitutor2, PsiExpression[] args, PsiElement context, boolean varargs) {
        PsiParameter[] parameters2;
        PsiTypeParameter[] typeParameters = m2.getTypeParameters();
        InferenceSession session = new InferenceSession(typeParameters, siteSubstitutor2, m2.getManager(), context);
        PsiParameter[] parameters1 = m1.getParameterList().getParameters();
        LOG.assertTrue(parameters1.length == (parameters2 = m2.getParameterList().getParameters()).length);
        int paramsLength = !varargs ? parameters1.length : parameters1.length - 1;
        for (int i = 0; i < paramsLength; ++i) {
            PsiType sType = siteSubstitutor2.substitute(parameters1[i].getType());
            PsiType tType = siteSubstitutor2.substitute(parameters2[i].getType());
            if (session.isProperType(sType) && session.isProperType(tType)) {
                if (TypeConversionUtil.isAssignable(tType, sType)) continue;
                return false;
            }
            if (LambdaUtil.isFunctionalType(sType) && LambdaUtil.isFunctionalType(tType) && !InferenceSession.relates(sType, tType)) {
                if (InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, session, args)) continue;
                return false;
            }
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        if (varargs) {
            PsiType sType = siteSubstitutor2.substitute(parameters1[paramsLength].getType());
            PsiType tType = siteSubstitutor2.substitute(parameters2[paramsLength].getType());
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        return session.repeatInferencePhases(true);
    }

    public static boolean isFunctionalTypeMoreSpecificOnExpression(PsiType sType, PsiType tType, PsiExpression arg) {
        return InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, null, arg);
    }

    private static boolean isFunctionalTypeMoreSpecific(PsiType sType, PsiType tType, @Nullable InferenceSession session, PsiExpression ... args) {
        PsiClassType.ClassResolveResult sResult = PsiUtil.resolveGenericsClassInType(sType);
        PsiMethod sInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(sResult);
        LOG.assertTrue(sInterfaceMethod != null);
        PsiSubstitutor sSubstitutor = LambdaUtil.getSubstitutor(sInterfaceMethod, sResult);
        PsiClassType.ClassResolveResult tResult = PsiUtil.resolveGenericsClassInType(tType);
        PsiMethod tInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(tResult);
        LOG.assertTrue(tInterfaceMethod != null);
        PsiSubstitutor tSubstitutor = LambdaUtil.getSubstitutor(tInterfaceMethod, tResult);
        for (PsiExpression arg : args) {
            if (InferenceSession.argConstraints(arg, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor)) continue;
            return false;
        }
        return true;
    }

    protected static boolean argConstraints(PsiExpression arg, @Nullable InferenceSession session, PsiMethod sInterfaceMethod, PsiSubstitutor sSubstitutor, PsiMethod tInterfaceMethod, PsiSubstitutor tSubstitutor) {
        if (arg instanceof PsiLambdaExpression && ((PsiLambdaExpression)arg).hasFormalParameterTypes()) {
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (tReturnType == PsiType.VOID) {
                return true;
            }
            if (sReturnType == PsiType.VOID && session != null) {
                return false;
            }
            if (LambdaUtil.isFunctionalType(sReturnType) && LambdaUtil.isFunctionalType(tReturnType) && !TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(sReturnType), TypeConversionUtil.erasure(tReturnType)) && !TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(tReturnType), TypeConversionUtil.erasure(sReturnType))) {
                List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)arg);
                if (!InferenceSession.isFunctionalTypeMoreSpecific(sReturnType, tReturnType, session, returnExpressions.toArray(new PsiExpression[returnExpressions.size()]))) {
                    return false;
                }
            } else {
                boolean sPrimitive = sReturnType instanceof PsiPrimitiveType;
                boolean tPrimitive = tReturnType instanceof PsiPrimitiveType;
                if (sPrimitive ^ tPrimitive) {
                    for (PsiExpression returnExpression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)arg)) {
                        if (PsiPolyExpressionUtil.isPolyExpression(returnExpression)) continue;
                        PsiType returnExpressionType = returnExpression.getType();
                        if (!(sPrimitive ? !(returnExpressionType instanceof PsiPrimitiveType) : !(returnExpressionType instanceof PsiClassType))) continue;
                        return false;
                    }
                    return true;
                }
                if (session != null) {
                    session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                    return true;
                }
                return TypeConversionUtil.isAssignable(sReturnType, tReturnType);
            }
        }
        if (arg instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)arg).isExact()) {
            PsiParameter[] tParameters;
            PsiParameter[] sParameters = sInterfaceMethod.getParameterList().getParameters();
            LOG.assertTrue(sParameters.length == (tParameters = tInterfaceMethod.getParameterList().getParameters()).length);
            if (session != null) {
                for (int i = 0; i < tParameters.length; ++i) {
                    session.addConstraint(new TypeEqualityConstraint(tSubstitutor.substitute(tParameters[i].getType()), sSubstitutor.substitute(sParameters[i].getType())));
                }
            }
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (tReturnType == PsiType.VOID) {
                return true;
            }
            if (sReturnType == PsiType.VOID && session != null) {
                return false;
            }
            boolean sPrimitive = sReturnType instanceof PsiPrimitiveType;
            boolean tPrimitive = tReturnType instanceof PsiPrimitiveType;
            if (sPrimitive ^ tPrimitive) {
                PsiMember member = ((PsiMethodReferenceExpression)arg).getPotentiallyApplicableMember();
                LOG.assertTrue(member != null);
                if (member instanceof PsiMethod) {
                    PsiType methodReturnType = ((PsiMethod)member).getReturnType();
                    if (sPrimitive && methodReturnType instanceof PsiPrimitiveType || tPrimitive && methodReturnType instanceof PsiClassType) {
                        return true;
                    }
                }
                return false;
            }
            if (session != null) {
                session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                return true;
            }
            return TypeConversionUtil.isAssignable(sReturnType, tReturnType);
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return InferenceSession.argConstraints(((PsiParenthesizedExpression)arg).getExpression(), session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        if (arg instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)arg).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)arg).getElseExpression();
            return InferenceSession.argConstraints(thenExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor) && InferenceSession.argConstraints(elseExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        return false;
    }

    private static boolean relates(PsiType sType, PsiType tType) {
        PsiType sTypeErasure;
        PsiType erasedType = TypeConversionUtil.erasure(tType);
        LOG.assertTrue(erasedType != null);
        if (sType instanceof PsiIntersectionType) {
            boolean superRelation = true;
            boolean subRelation = false;
            for (PsiType sConjunct : ((PsiIntersectionType)sType).getConjuncts()) {
                PsiType sConjunctErasure = TypeConversionUtil.erasure(sConjunct);
                if (sConjunctErasure == null) continue;
                superRelation &= TypeConversionUtil.isAssignable(sConjunctErasure, erasedType);
                subRelation |= TypeConversionUtil.isAssignable(erasedType, sConjunctErasure);
            }
            return superRelation || subRelation;
        }
        if (sType instanceof PsiClassType && (sTypeErasure = TypeConversionUtil.erasure(sType)) != null) {
            return TypeConversionUtil.isAssignable(sTypeErasure, erasedType) || TypeConversionUtil.isAssignable(erasedType, sTypeErasure);
        }
        return false;
    }
}

