/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiMatcherExpression;
import com.intellij.util.ArrayUtil;

public class PsiMatchers {
    private PsiMatchers() {
    }

    public static PsiMatcherExpression hasName(final String name) {
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (element instanceof PsiNamedElement && name.equals(((PsiNamedElement)element).getName())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    public static PsiMatcherExpression hasText(final String text) {
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (element.getTextLength() != text.length()) {
                    return Boolean.FALSE;
                }
                return text.equals(element.getText());
            }
        };
    }

    public static PsiMatcherExpression hasText(final String ... texts) {
        if (texts == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/PsiMatchers", "hasText"));
        }
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                String text = element.getText();
                return ArrayUtil.find(texts, text) != -1;
            }
        };
    }

    public static PsiMatcherExpression hasClass(final Class aClass) {
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (aClass.isAssignableFrom(element.getClass())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    public static PsiMatcherExpression hasClass(final Class ... classes2) {
        return new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                for (Class aClass : classes2) {
                    if (!aClass.isAssignableFrom(element.getClass())) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }
}

