/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EventDispatcher<T extends EventListener> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.EventDispatcher");
    private final T myMulticaster;
    private final List<T> myListeners;

    public static <T extends EventListener> EventDispatcher<T> create(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/EventDispatcher", "create"));
        }
        return new EventDispatcher<T>(listenerClass);
    }

    private EventDispatcher(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/EventDispatcher", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            @NonNls
            public Object invoke(Object proxy, Method method2, Object[] args) throws Throwable {
                if (method2.getDeclaringClass().getName().equals("java.lang.Object")) {
                    String methodName = method2.getName();
                    if (methodName.equals("toString")) {
                        return "Multicaster";
                    }
                    if (methodName.equals("hashCode")) {
                        return System.identityHashCode(proxy);
                    }
                    if (methodName.equals("equals")) {
                        return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
                    }
                    LOG.error("Incorrect Object's method invoked for proxy:" + methodName);
                    return null;
                }
                EventDispatcher.this.dispatch(method2, args);
                return null;
            }
        };
        this.myMulticaster = (EventListener)Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
    }

    @NotNull
    public T getMulticaster() {
        T t = this.myMulticaster;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/EventDispatcher", "getMulticaster"));
        }
        return t;
    }

    private void dispatch(Method method2, Object[] args) {
        method2.setAccessible(true);
        for (EventListener listener : this.myListeners) {
            try {
                method2.invoke((Object)listener, args);
            }
            catch (AbstractMethodError abstractMethodError) {
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                LOG.error(cause);
            }
        }
    }

    public void addListener(@NotNull T listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/EventDispatcher", "addListener"));
        }
        this.myListeners.add(listener);
    }
}

