/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ReflectionUtil");

    private ReflectionUtil() {
    }

    @NotNull
    public static Field findAssignableField(@NotNull Class<?> clazz, final @NotNull Class<?> fieldType, final @NotNull String fieldName) throws NoSuchFieldException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ReflectionUtil", "findAssignableField"));
        }
        if (fieldType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ReflectionUtil", "findAssignableField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/ReflectionUtil", "findAssignableField"));
        }
        Field result = ReflectionUtil.processFields(clazz, new Condition<Field>(){

            @Override
            public boolean value(Field field) {
                return fieldName.equals(field.getName()) && fieldType.isAssignableFrom(field.getType());
            }
        });
        if (result != null) {
            Field field = result;
            if (field == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "findAssignableField"));
            }
            return field;
        }
        throw new NoSuchFieldException("Class: " + clazz + " fieldName: " + fieldName + " fieldType: " + fieldType);
    }

    private static Field processFields(@NotNull Class clazz, @NotNull Condition<Field> checker) {
        Class<?>[] interfaces;
        Field result;
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ReflectionUtil", "processFields"));
        }
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ReflectionUtil", "processFields"));
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!checker.value(field)) continue;
            return field;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && (result = ReflectionUtil.processFields(superClass, checker)) != null) {
            return result;
        }
        for (Class<?> each : interfaces = clazz.getInterfaces()) {
            Field result2 = ReflectionUtil.processFields(each, checker);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static Method findMethod(@NotNull Method[] methods2, @NonNls @NotNull String name, Class ... parameters) {
        if (methods2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ReflectionUtil", "findMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ReflectionUtil", "findMethod"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/ReflectionUtil", "findMethod"));
        }
        for (Method method2 : methods2) {
            if (!name.equals(method2.getName()) || !Arrays.equals(parameters, method2.getParameterTypes())) continue;
            return method2;
        }
        return null;
    }

    @Nullable
    public static Method getMethod(@NotNull Class aClass, @NonNls @NotNull String name, Class ... parameters) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ReflectionUtil", "getMethod"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ReflectionUtil", "getMethod"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/ReflectionUtil", "getMethod"));
        }
        return ReflectionUtil.findMethod(aClass.getMethods(), name, parameters);
    }

    @Nullable
    public static Class getMethodDeclaringClass(@NotNull Class<?> instanceClass, @NonNls @NotNull String name, Class ... parameters) {
        if (instanceClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ReflectionUtil", "getMethodDeclaringClass"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ReflectionUtil", "getMethodDeclaringClass"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/ReflectionUtil", "getMethodDeclaringClass"));
        }
        Method method2 = ReflectionUtil.getMethod(instanceClass, name, parameters);
        return method2 == null ? null : method2.getDeclaringClass();
    }

    public static <T> T getField(@NotNull Class objectClass, Object object2, @NotNull Class<T> fieldType, @NotNull @NonNls String fieldName) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ReflectionUtil", "getField"));
        }
        if (fieldType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/ReflectionUtil", "getField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/util/ReflectionUtil", "getField"));
        }
        try {
            Field field = ReflectionUtil.findAssignableField(objectClass, fieldType, fieldName);
            field.setAccessible(true);
            return (T)field.get(object2);
        }
        catch (NoSuchFieldException e) {
            LOG.debug(e);
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.debug(e);
            return null;
        }
    }

    @NotNull
    public static <T> Constructor<T> getDefaultConstructor(@NotNull Class<T> aClass) {
        Constructor<T> constructor;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ReflectionUtil", "getDefaultConstructor"));
        }
        try {
            Constructor<T> constructor2 = aClass.getConstructor(new Class[0]);
            constructor2.setAccessible(true);
            constructor = constructor2;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No default constructor in " + aClass, e);
        }
        if (constructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "getDefaultConstructor"));
        }
        return constructor;
    }

    @NotNull
    public static <T> T createInstance(@NotNull Constructor<T> constructor, Object ... args) {
        T t;
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ReflectionUtil", "createInstance"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ReflectionUtil", "createInstance"));
        }
        try {
            t = constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ReflectionUtil", "createInstance"));
        }
        return t;
    }

    @Nullable
    public static Class findCallerClass(int framesToSkip) {
        try {
            Class[] stack = MySecurityManager.INSTANCE.getStack();
            int indexFromTop = 1 + framesToSkip;
            return stack.length > indexFromTop ? stack[indexFromTop] : null;
        }
        catch (Exception e) {
            LOG.warn(e);
            return null;
        }
    }

    public static boolean isAssignable(@NotNull Class<?> ancestor, Class<?> descendant) {
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ReflectionUtil", "isAssignable"));
        }
        return ancestor == descendant || ancestor.isAssignableFrom(descendant);
    }

    private static class MySecurityManager
    extends SecurityManager {
        private static final MySecurityManager INSTANCE = new MySecurityManager();

        private MySecurityManager() {
        }

        public Class[] getStack() {
            return this.getClassContext();
        }
    }
}

