/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class UnsafeWeakList<T>
extends AbstractList<T> {
    protected final List<MyReference<T>> myList;
    private final ReferenceQueue<T> myQueue = new ReferenceQueue();
    private int myAlive;
    private static final Function<MyReference<Object>, Object> DEREF = new Function<MyReference<Object>, Object>(){

        @Override
        public Object fun(MyReference<Object> reference) {
            return SoftReference.dereference(reference);
        }
    };
    private static final Condition<MyReference<Object>> NOT_NULL = new Condition<MyReference<Object>>(){

        @Override
        public boolean value(MyReference<Object> reference) {
            return SoftReference.dereference(reference) != null;
        }
    };

    public UnsafeWeakList() {
        this.myList = new ArrayList<MyReference<T>>();
    }

    boolean processQueue() {
        MyReference reference;
        boolean processed = false;
        while ((reference = (MyReference)this.myQueue.poll()) != null) {
            int index = reference.index;
            if (index < this.myList.size() && reference == this.myList.get(index)) {
                this.nullizeAt(index);
            }
            processed = true;
        }
        if (this.myAlive < this.myList.size() / 2) {
            this.reduceCapacity();
        }
        return processed;
    }

    private void nullizeAt(int index) {
        this.myList.set(index, null);
        --this.myAlive;
    }

    private void reduceCapacity() {
        int toSaveAlive = 0;
        for (int i = 0; i < this.myList.size(); ++i) {
            MyReference<T> reference = this.myList.get(i);
            if (reference == null) continue;
            Object t = reference.get();
            if (t == null) {
                --this.myAlive;
                continue;
            }
            if (toSaveAlive != i) {
                this.myList.set(toSaveAlive, new MyReference(toSaveAlive, t, this.myQueue));
            }
            ++toSaveAlive;
        }
        if (toSaveAlive != this.myList.size()) {
            this.myList.subList(toSaveAlive, this.myList.size()).clear();
            ++this.modCount;
        }
        this.myAlive = toSaveAlive;
    }

    private void append(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/UnsafeWeakList", "append"));
        }
        this.myList.add(new MyReference<T>(this.myList.size(), element, this.myQueue));
        ++this.myAlive;
        ++this.modCount;
    }

    @Override
    public boolean add(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/UnsafeWeakList", "add"));
        }
        this.processQueue();
        this.append(element);
        return true;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myList.clear();
        this.myAlive = 0;
        ++this.modCount;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        MyIterator myIterator = new MyIterator();
        if (myIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/UnsafeWeakList", "iterator"));
        }
        return myIterator;
    }

    @Override
    public boolean remove(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/UnsafeWeakList", "remove"));
        }
        this.processQueue();
        for (int i = 0; i < this.myList.size(); ++i) {
            Object t = SoftReference.dereference(this.myList.get(i));
            if (t == null || !t.equals(o)) continue;
            this.nullizeAt(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/UnsafeWeakList", "addAll"));
        }
        this.processQueue();
        return super.addAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/UnsafeWeakList", "removeAll"));
        }
        this.processQueue();
        return super.removeAll(c);
    }

    private static <X> Function<MyReference<X>, X> deref() {
        return DEREF;
    }

    @NotNull
    public List<T> toStrongList() {
        Function deref = UnsafeWeakList.deref();
        List list2 = ContainerUtil.mapNotNull(this.myList, deref);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/UnsafeWeakList", "toStrongList"));
        }
        return list2;
    }

    @Override
    public int size() {
        this.throwNotRandomAccess();
        return -1;
    }

    @Override
    public boolean isEmpty() {
        if (this.myList.isEmpty()) {
            return true;
        }
        Condition<MyReference<T>> notNull = UnsafeWeakList.notNull();
        return ContainerUtil.find(this.myList, notNull) == null;
    }

    private static <T> Condition<MyReference<T>> notNull() {
        return NOT_NULL;
    }

    @Override
    public T set(int index, T element) {
        return this.throwNotRandomAccess();
    }

    @Override
    public int indexOf(Object o) {
        this.throwNotRandomAccess();
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        this.throwNotRandomAccess();
        return -1;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.throwNotRandomAccess();
        return false;
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        this.throwNotRandomAccess();
        UnsafeWeakList unsafeWeakList = this;
        if (unsafeWeakList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/UnsafeWeakList", "subList"));
        }
        return unsafeWeakList;
    }

    @Override
    public void add(int index, T element) {
        this.throwNotRandomAccess();
    }

    @Override
    public T remove(int index) {
        return this.throwNotRandomAccess();
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.throwNotRandomAccess();
    }

    @Override
    public T get(int index) {
        return this.throwNotRandomAccess();
    }

    private T throwNotRandomAccess() {
        throw new IncorrectOperationException("UnsafeWeakList is not RandomAccess, use list.iterator()");
    }

    private class MyIterator
    implements Iterator<T> {
        private final int startModCount;
        int curIndex;
        T curElement;
        int nextIndex = -1;
        T nextElement;

        private MyIterator() {
            this.startModCount = UnsafeWeakList.this.modCount;
            this.findNext();
        }

        private boolean findNext() {
            if (UnsafeWeakList.this.modCount != this.startModCount) {
                throw new ConcurrentModificationException();
            }
            this.curIndex = this.nextIndex;
            this.curElement = this.nextElement;
            this.nextElement = null;
            this.nextIndex = -1;
            for (int i = this.curIndex + 1; i < UnsafeWeakList.this.myList.size(); ++i) {
                Object t = SoftReference.dereference(UnsafeWeakList.this.myList.get(i));
                if (t == null) continue;
                this.nextElement = t;
                this.nextIndex = i;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.findNext();
            return this.curElement;
        }

        @Override
        public void remove() {
            if (this.curElement == null) {
                throw new NoSuchElementException();
            }
            int index = this.curIndex;
            UnsafeWeakList.this.nullizeAt(index);
        }
    }

    private static class MyReference<T>
    extends WeakReference<T> {
        private final int index;

        MyReference(int index, T referent, ReferenceQueue<? super T> queue) {
            super(referent, queue);
            this.index = index;
        }
    }
}

