/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CharArrayExternalizable;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.ImmutableCharSequence;
import org.jetbrains.annotations.NotNull;

public final class ImmutableText
extends ImmutableCharSequence
implements CharArrayExternalizable {
    private final char[] _data;
    private final int _count;
    private final ImmutableText _head;
    private final ImmutableText _tail;
    private static final ImmutableText TRUE = ImmutableText.valueOf("true");
    private static final ImmutableText FALSE = ImmutableText.valueOf("false");
    private static final ImmutableText EMPTY = ImmutableText.valueOf("");
    private volatile InnerLeaf myLastLeaf;

    private ImmutableText(char[] data2) {
        this._data = data2;
        this._count = data2.length;
        this._tail = null;
        this._head = null;
    }

    private ImmutableText(ImmutableText head, ImmutableText tail) {
        this._count = head._count + tail._count;
        this._data = null;
        this._head = head;
        this._tail = tail;
    }

    public static ImmutableText valueOf(@NotNull Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/ImmutableText", "valueOf"));
        }
        if (obj instanceof ImmutableText) {
            return (ImmutableText)obj;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0 ? EMPTY : ImmutableText.valueOf((CharSequence)obj);
        }
        return ImmutableText.valueOf(String.valueOf(obj));
    }

    private static ImmutableText valueOf(@NotNull CharSequence str2) {
        if (str2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/ImmutableText", "valueOf"));
        }
        return ImmutableText.valueOf(str2, 0, str2.length());
    }

    private static ImmutableText valueOf(@NotNull CharSequence str2, int start, int end) {
        if (str2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/text/ImmutableText", "valueOf"));
        }
        int length = end - start;
        if (length <= 64) {
            return new ImmutableText(CharArrayUtil.fromSequence(str2, start, end));
        }
        int half = length + 64 >> 1 & 0xFFFFFFC0;
        return new ImmutableText(ImmutableText.valueOf(str2, start, start + half), ImmutableText.valueOf(str2, start + half, end));
    }

    @Override
    public int length() {
        return this._count;
    }

    public ImmutableText concat(ImmutableText that) {
        if (that.length() == 0) {
            return this;
        }
        int length = this._count + that._count;
        if (length <= 64) {
            char[] chars = new char[length];
            this.getChars(0, this._count, chars, 0);
            that.getChars(0, that._count, chars, this._count);
            return new ImmutableText(chars);
        }
        ImmutableText head = this;
        ImmutableText tail = that;
        if (head._count << 1 < tail._count && tail._data == null) {
            if (tail._head._count > tail._tail._count) {
                tail = tail.rightRotation();
            }
            head = head.concat(tail._head);
            tail = tail._tail;
        } else if (tail._count << 1 < head._count && head._data == null) {
            if (head._tail._count > head._head._count) {
                head = head.leftRotation();
            }
            tail = head._tail.concat(tail);
            head = head._head;
        }
        return new ImmutableText(head, tail);
    }

    private ImmutableText rightRotation() {
        ImmutableText P = this._head;
        if (P._data != null) {
            return this;
        }
        ImmutableText A = P._head;
        ImmutableText B = P._tail;
        ImmutableText C = this._tail;
        return new ImmutableText(A, new ImmutableText(B, C));
    }

    private ImmutableText leftRotation() {
        ImmutableText Q = this._tail;
        if (Q._data != null) {
            return this;
        }
        ImmutableText B = Q._head;
        ImmutableText C = Q._tail;
        ImmutableText A = this._head;
        return new ImmutableText(new ImmutableText(A, B), C);
    }

    public ImmutableText subtext(int start) {
        return this.subtext(start, this.length());
    }

    public ImmutableText insert(int index, ImmutableText txt) {
        return this.subtext(0, index).concat(txt).concat(this.subtext(index));
    }

    public ImmutableText insert(int index, CharSequence seq) {
        return this.insert(index, ImmutableText.valueOf(seq));
    }

    public ImmutableText delete(int start, int end) {
        if (start == end) {
            return this;
        }
        if (start > end) {
            throw new IndexOutOfBoundsException();
        }
        return this.subtext(0, start).concat(this.subtext(end));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == 0 && end == this.length()) {
            return this;
        }
        return new CharSequenceSubSequence(this, start, end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImmutableText)) {
            return false;
        }
        ImmutableText that = (ImmutableText)obj;
        if (this._count != that._count) {
            return false;
        }
        int i = 0;
        while (i < this._count) {
            if (this.charAt(i) == that.charAt(i++)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        int length = this.length();
        int i = 0;
        while (i < length) {
            h = 31 * h + this.charAt(i++);
        }
        return h;
    }

    @Override
    public char charAt(int index) {
        InnerLeaf leaf = this.myLastLeaf;
        if (leaf == null || index < leaf.offset || index >= leaf.offset + leaf.leafText._count) {
            this.myLastLeaf = leaf = this.findLeaf(index, 0);
        }
        return leaf.leafText._data[index - leaf.offset];
    }

    private InnerLeaf findLeaf(int index, int offset) {
        ImmutableText node = this;
        while (true) {
            if (index >= node._count) {
                throw new IndexOutOfBoundsException();
            }
            if (node._data != null) {
                return new InnerLeaf(node, offset);
            }
            if (index < node._head._count) {
                node = node._head;
                continue;
            }
            offset += node._head._count;
            index -= node._head._count;
            node = node._tail;
        }
    }

    public ImmutableText subtext(int start, int end) {
        if (this._data != null) {
            if (start < 0 || start > end || end > this._count) {
                throw new IndexOutOfBoundsException();
            }
            if (start == 0 && end == this._count) {
                return this;
            }
            if (start == end) {
                return EMPTY;
            }
            int length = end - start;
            char[] chars = new char[length];
            System.arraycopy(this._data, start, chars, 0, length);
            return new ImmutableText(chars);
        }
        int cesure = this._head._count;
        if (end <= cesure) {
            return this._head.subtext(start, end);
        }
        if (start >= cesure) {
            return this._tail.subtext(start - cesure, end - cesure);
        }
        if (start == 0 && end == this._count) {
            return this;
        }
        return this._head.subtext(start, cesure).concat(this._tail.subtext(0, end - cesure));
    }

    @Override
    public void getChars(int start, int end, @NotNull char[] dest, int destPos) {
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/text/ImmutableText", "getChars"));
        }
        if (this._data != null) {
            if (start < 0 || end > this._count || start > end) {
                throw new IndexOutOfBoundsException();
            }
            System.arraycopy(this._data, start, dest, destPos, end - start);
        } else {
            int cesure = this._head._count;
            if (end <= cesure) {
                this._head.getChars(start, end, dest, destPos);
            } else if (start >= cesure) {
                this._tail.getChars(start - cesure, end - cesure, dest, destPos);
            } else {
                this._head.getChars(start, cesure, dest, destPos);
                this._tail.getChars(0, end - cesure, dest, destPos + cesure - start);
            }
        }
    }

    @Override
    @NotNull
    public String toString() {
        if (this._data != null) {
            String string = new String(this._data, 0, this._count);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/ImmutableText", "toString"));
            }
            return string;
        }
        char[] data2 = new char[this._count];
        this.getChars(0, this._count, data2, 0);
        String string = new String(data2, 0, this._count);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/ImmutableText", "toString"));
        }
        return string;
    }

    private static class InnerLeaf {
        final ImmutableText leafText;
        final int offset;

        private InnerLeaf(ImmutableText leafText, int offset) {
            this.leafText = leafText;
            this.offset = offset;
        }
    }
}

