/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.IsRetina;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.swing.GrayFilter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class UIUtil {
    private static final AtomicNotNullLazyValue<Boolean> X_RENDER_ACTIVE = new AtomicNotNullLazyValue<Boolean>(){

        @Override
        @NotNull
        protected Boolean compute() {
            Boolean bl;
            if (!SystemInfo.isXWindow) {
                Boolean bl2 = false;
                if (bl2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$1", "compute"));
                }
                return bl2;
            }
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("sun.awt.X11GraphicsEnvironment");
                Method method2 = clazz.getMethod("isXRenderAvailable", new Class[0]);
                bl = (Boolean)method2.invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                Boolean bl3 = false;
                if (bl3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$1", "compute"));
                }
                return bl3;
            }
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/UIUtil$1", "compute"));
            }
            return bl;
        }
    };
    private static final String[] STANDARD_FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    private static final GrayFilter DEFAULT_GRAY_FILTER = new GrayFilter(true, 65);
    private static final GrayFilter DARCULA_GRAY_FILTER = new GrayFilter(true, 30);
    public static final Pattern CLOSE_TAG_PATTERN = Pattern.compile("<\\s*([^<>/ ]+)([^<>]*)/\\s*>", 2);
    public static Key<Integer> KEEP_BORDER_SIDES = Key.create("keepBorderSides");
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.UIUtil");
    private static final Color UNFOCUSED_SELECTION_COLOR = Gray._212;
    private static final Color ACTIVE_HEADER_COLOR = new Color(160, 186, 213);
    private static final Color INACTIVE_HEADER_COLOR = Gray._128;
    private static final Color BORDER_COLOR = Color.LIGHT_GRAY;
    public static final Color AQUA_SEPARATOR_FOREGROUND_COLOR = Gray._190;
    public static final Color AQUA_SEPARATOR_BACKGROUND_COLOR = Gray._240;
    public static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    public static final Insets PANEL_REGULAR_INSETS = new Insets(8, 12, 8, 12);
    public static final Insets PANEL_SMALL_INSETS = new Insets(5, 8, 5, 8);
    public static final Border DEBUG_MARKER_BORDER = new Border(){
        private final Insets empty = new Insets(0, 0, 0, 0);

        @Override
        public Insets getBorderInsets(Component c) {
            return this.empty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics g2 = g.create();
            try {
                g2.setColor(JBColor.RED);
                UIUtil.drawDottedRectangle(g2, x, y, x + width - 1, y + height - 1);
            }
            finally {
                g2.dispose();
            }
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    };
    private static final HashMap<Color, BufferedImage> ourAppleDotSamples = new HashMap();
    private static volatile Pair<String, Integer> ourSystemFontData = null;
    private static final Ref<Boolean> ourRetina = Ref.create(SystemInfo.isMac ? null : Boolean.valueOf(false));
    public static final Color GTK_AMBIANCE_TEXT_COLOR = new Color(223, 219, 210);
    public static final Color GTK_AMBIANCE_BACKGROUND_COLOR = new Color(67, 66, 63);
    private static final Color DECORATED_ROW_BG_COLOR = new JBColor(new Color(242, 245, 249), new Color(65, 69, 71));

    private UIUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRetina() {
        if ("true".equalsIgnoreCase(System.getProperty("is.hidpi"))) {
            return true;
        }
        Ref<Boolean> ref = ourRetina;
        synchronized (ref) {
            if (ourRetina.isNull()) {
                ourRetina.set(false);
                if (SystemInfo.isJavaVersionAtLeast("1.6.0_33") && SystemInfo.isAppleJvm) {
                    if (!"false".equals(System.getProperty("ide.mac.retina"))) {
                        ourRetina.set(IsRetina.isRetina());
                        return ourRetina.get();
                    }
                } else if (SystemInfo.isJavaVersionAtLeast("1.7.0_40") && SystemInfo.isOracleJvm) {
                    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice device = env.getDefaultScreenDevice();
                    try {
                        Field field = device.getClass().getDeclaredField("scale");
                        if (field != null) {
                            field.setAccessible(true);
                            Object scale = field.get(device);
                            if (scale instanceof Integer && (Integer)scale == 2) {
                                ourRetina.set(true);
                                return true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ourRetina.set(false);
            }
            return ourRetina.get();
        }
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
    }

    public static Color getTreeTextBackground() {
        return UIManager.getColor("Tree.textBackground");
    }

    public static Color getListBackground() {
        if (UIUtil.isUnderNimbusLookAndFeel()) {
            Color color = UIManager.getColor("List.background");
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        return UIUtil.isUnderGTKLookAndFeel() ? UIUtil.getTreeTextBackground() : UIManager.getColor("List.background");
    }

    public static Color getListForeground() {
        return UIManager.getColor("List.foreground");
    }

    public static boolean isUnderNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("Nimbus");
    }

    public static boolean isUnderDarcula() {
        return UIManager.getLookAndFeel().getName().contains("Darcula");
    }

    public static boolean isUnderGTKLookAndFeel() {
        return UIManager.getLookAndFeel().getName().contains("GTK");
    }

    public static void drawDottedRectangle(Graphics g, int x, int y, int x1, int y1) {
        int i1;
        for (i1 = x; i1 <= x1; i1 += 2) {
            UIUtil.drawLine(g, i1, y, i1, y);
        }
        int n = i1 = i1 != x1 + 1 ? y + 2 : y + 1;
        while (i1 <= y1) {
            UIUtil.drawLine(g, x1, i1, x1, i1);
            i1 += 2;
        }
        int n2 = i1 = i1 != y1 + 1 ? x1 - 2 : x1 - 1;
        while (i1 >= x) {
            UIUtil.drawLine(g, i1, y1, i1, y1);
            i1 -= 2;
        }
        int n3 = i1 = i1 != x - 1 ? y1 - 2 : y1 - 1;
        while (i1 >= y) {
            UIUtil.drawLine(g, x, i1, x, i1);
            i1 -= 2;
        }
    }

    public static BufferedImage createImage(int width, int height, int type) {
        if (UIUtil.isRetina()) {
            return RetinaImage.create(width, height, type);
        }
        return new BufferedImage(width, height, type);
    }

    public static void drawImage(Graphics g, Image image, int x, int y, ImageObserver observer) {
        if (image instanceof JBHiDPIScaledImage) {
            Graphics2D newG = (Graphics2D)g.create(x, y, image.getWidth(observer), image.getHeight(observer));
            newG.scale(0.5, 0.5);
            Image img = ((JBHiDPIScaledImage)image).getDelegate();
            if (img == null) {
                img = image;
            }
            newG.drawImage(img, 0, 0, observer);
            newG.scale(1.0, 1.0);
            newG.dispose();
        } else {
            g.drawImage(image, x, y, observer);
        }
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ui/UIUtil", "invokeLaterIfNeeded"));
        }
        if (SwingUtilities.isEventDispatchThread()) {
            runnable2.run();
        } else {
            SwingUtilities.invokeLater(runnable2);
        }
    }
}

