/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.asJava;

import com.intellij.lang.Language;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.asJava.KotlinLightModifierList;
import org.jetbrains.jet.asJava.light.LightParameter;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.jet.lang.resolve.java.jetAsJava.KotlinLightElement;
import org.jetbrains.jet.lang.resolve.java.jetAsJava.KotlinLightMethod;
import org.jetbrains.jet.plugin.JetLanguage;

public class KotlinLightParameter
extends LightParameter
implements KotlinLightElement<JetParameter, PsiParameter> {
    private final PsiModifierList modifierList;
    private final PsiParameter delegate;
    private final int index;
    private final KotlinLightMethod method;

    private static String getName(PsiParameter delegate, int index) {
        String name = delegate.getName();
        return name != null ? name : "p" + index;
    }

    public KotlinLightParameter(final PsiParameter delegate, int index, KotlinLightMethod method2) {
        super(KotlinLightParameter.getName(delegate, index), delegate.getType(), method2, (Language)JetLanguage.INSTANCE);
        this.delegate = delegate;
        this.index = index;
        this.method = method2;
        this.modifierList = new KotlinLightModifierList(method2.getManager(), ArrayUtil.EMPTY_STRING_ARRAY){

            @Override
            public PsiAnnotationOwner getDelegate() {
                return delegate.getModifierList();
            }
        };
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = this.modifierList;
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinLightParameter", "getModifierList"));
        }
        return psiModifierList;
    }

    @Override
    @NotNull
    public PsiParameter getDelegate() {
        PsiParameter psiParameter = this.delegate;
        if (psiParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/KotlinLightParameter", "getDelegate"));
        }
        return psiParameter;
    }

    @Override
    @Nullable
    public JetParameter getOrigin() {
        int jetIndex;
        Object declaration = this.method.getOrigin();
        if (declaration == null) {
            return null;
        }
        int n = jetIndex = PsiUtilPackage.isExtensionDeclaration(declaration) ? this.index - 1 : this.index;
        if (jetIndex < 0) {
            return null;
        }
        if (declaration instanceof JetNamedFunction) {
            List<JetParameter> paramList = ((JetNamedFunction)declaration).getValueParameters();
            return jetIndex < paramList.size() ? paramList.get(jetIndex) : null;
        }
        if (declaration instanceof JetClass) {
            List<JetParameter> paramList = ((JetClass)declaration).getPrimaryConstructorParameters();
            return jetIndex < paramList.size() ? paramList.get(jetIndex) : null;
        }
        if (jetIndex != 0) {
            return null;
        }
        JetPropertyAccessor setter = null;
        if (declaration instanceof JetPropertyAccessor) {
            JetPropertyAccessor accessor = (JetPropertyAccessor)declaration;
            setter = accessor.isSetter() ? accessor : null;
        } else if (declaration instanceof JetProperty) {
            setter = ((JetProperty)declaration).getSetter();
        }
        return setter != null ? setter.getParameter() : null;
    }
}

