/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class FunctionTypesUtil {
    private static final List<ClassDescriptor> FUNCTIONS;
    private static final List<ClassDescriptor> EXTENSION_FUNCTIONS;
    private static final List<ClassDescriptor> K_FUNCTIONS;
    private static final List<ClassDescriptor> K_MEMBER_FUNCTIONS;
    private static final List<ClassDescriptor> K_EXTENSION_FUNCTIONS;
    private static final ImmutableMap<ClassDescriptor, ClassDescriptor> FUNCTION_TO_IMPL;

    private FunctionTypesUtil() {
    }

    @Nullable
    public static ClassDescriptor functionTypeToImpl(@NotNull JetType functionType) {
        if (functionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "org/jetbrains/jet/codegen/FunctionTypesUtil", "functionTypeToImpl"));
        }
        return FUNCTION_TO_IMPL.get(functionType.getConstructor().getDeclarationDescriptor());
    }

    @NotNull
    public static JetType getSuperTypeForClosure(@NotNull FunctionDescriptor descriptor, boolean kFunction) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/FunctionTypesUtil", "getSuperTypeForClosure"));
        }
        int arity = descriptor.getValueParameters().size();
        ReceiverParameterDescriptor receiverParameter = descriptor.getReceiverParameter();
        ReceiverParameterDescriptor expectedThisObject = descriptor.getExpectedThisObject();
        ArrayList<TypeProjectionImpl> typeArguments = new ArrayList<TypeProjectionImpl>(arity + 2);
        if (receiverParameter != null) {
            typeArguments.add(new TypeProjectionImpl(receiverParameter.getType()));
        } else if (kFunction && expectedThisObject != null) {
            typeArguments.add(new TypeProjectionImpl(expectedThisObject.getType()));
        }
        for (ValueParameterDescriptor parameter : descriptor.getValueParameters()) {
            typeArguments.add(new TypeProjectionImpl(parameter.getType()));
        }
        typeArguments.add(new TypeProjectionImpl(descriptor.getReturnType()));
        ClassDescriptor classDescriptor = kFunction ? (expectedThisObject != null ? K_MEMBER_FUNCTIONS.get(arity) : (receiverParameter != null ? K_EXTENSION_FUNCTIONS.get(arity) : K_FUNCTIONS.get(arity))) : (receiverParameter != null ? EXTENSION_FUNCTIONS.get(arity) : FUNCTIONS.get(arity));
        JetTypeImpl jetTypeImpl = new JetTypeImpl(classDescriptor.getDefaultType().getAnnotations(), classDescriptor.getTypeConstructor(), false, typeArguments, classDescriptor.getMemberScope(typeArguments));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionTypesUtil", "getSuperTypeForClosure"));
        }
        return jetTypeImpl;
    }

    @NotNull
    private static ClassDescriptor createFunctionImplDescriptor(@NotNull Name name, @NotNull ClassDescriptor functionInterface) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/FunctionTypesUtil", "createFunctionImplDescriptor"));
        }
        if (functionInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionInterface", "org/jetbrains/jet/codegen/FunctionTypesUtil", "createFunctionImplDescriptor"));
        }
        PackageFragmentDescriptor builtinsFragment = KotlinBuiltIns.getInstance().getBuiltInsPackageFragment();
        MutableClassDescriptor functionImpl = new MutableClassDescriptor(builtinsFragment, builtinsFragment.getMemberScope(), ClassKind.CLASS, false, name);
        functionImpl.setModality(Modality.FINAL);
        functionImpl.setVisibility(Visibilities.PUBLIC);
        functionImpl.setTypeParameterDescriptors(functionInterface.getDefaultType().getConstructor().getParameters());
        functionImpl.createTypeConstructor();
        MutableClassDescriptor mutableClassDescriptor = functionImpl;
        if (mutableClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionTypesUtil", "createFunctionImplDescriptor"));
        }
        return mutableClassDescriptor;
    }

    @NotNull
    public static Type getFunctionTraitClassName(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/FunctionTypesUtil", "getFunctionTraitClassName"));
        }
        int paramCount = descriptor.getValueParameters().size();
        if (descriptor.getReceiverParameter() != null) {
            Type type = Type.getObjectType("jet/ExtensionFunction" + paramCount);
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionTypesUtil", "getFunctionTraitClassName"));
            }
            return type;
        }
        Type type = Type.getObjectType("jet/Function" + paramCount);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionTypesUtil", "getFunctionTraitClassName"));
        }
        return type;
    }

    @NotNull
    public static Type getFunctionImplType(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/FunctionTypesUtil", "getFunctionImplType"));
        }
        int paramCount = descriptor.getValueParameters().size();
        if (descriptor.getReceiverParameter() != null) {
            Type type = Type.getObjectType("jet/ExtensionFunctionImpl" + paramCount);
            if (type == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionTypesUtil", "getFunctionImplType"));
            }
            return type;
        }
        Type type = Type.getObjectType("jet/FunctionImpl" + paramCount);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionTypesUtil", "getFunctionImplType"));
        }
        return type;
    }

    static {
        int n = 23;
        FUNCTIONS = new ArrayList<ClassDescriptor>(n);
        EXTENSION_FUNCTIONS = new ArrayList<ClassDescriptor>(n);
        K_FUNCTIONS = new ArrayList<ClassDescriptor>(n);
        K_MEMBER_FUNCTIONS = new ArrayList<ClassDescriptor>(n);
        K_EXTENSION_FUNCTIONS = new ArrayList<ClassDescriptor>(n);
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        for (int i = 0; i < n; ++i) {
            Name functionImpl = Name.identifier("FunctionImpl" + i);
            FUNCTIONS.add(FunctionTypesUtil.createFunctionImplDescriptor(functionImpl, builtIns.getFunction(i)));
            Name extensionFunctionImpl = Name.identifier("ExtensionFunctionImpl" + i);
            EXTENSION_FUNCTIONS.add(FunctionTypesUtil.createFunctionImplDescriptor(extensionFunctionImpl, builtIns.getExtensionFunction(i)));
            Name kFunctionImpl = Name.identifier("KFunctionImpl" + i);
            K_FUNCTIONS.add(FunctionTypesUtil.createFunctionImplDescriptor(kFunctionImpl, builtIns.getKFunction(i)));
            Name kMemberFunctionImpl = Name.identifier("KMemberFunctionImpl" + i);
            K_MEMBER_FUNCTIONS.add(FunctionTypesUtil.createFunctionImplDescriptor(kMemberFunctionImpl, builtIns.getKMemberFunction(i)));
            Name kExtensionFunctionImpl = Name.identifier("KExtensionFunctionImpl" + i);
            K_EXTENSION_FUNCTIONS.add(FunctionTypesUtil.createFunctionImplDescriptor(kExtensionFunctionImpl, builtIns.getKExtensionFunction(i)));
        }
        ImmutableMap.Builder<ClassDescriptor, ClassDescriptor> builder = ImmutableMap.builder();
        for (int i = 0; i < n; ++i) {
            builder.put(builtIns.getKFunction(i), K_FUNCTIONS.get(i));
            builder.put(builtIns.getKMemberFunction(i), K_MEMBER_FUNCTIONS.get(i));
            builder.put(builtIns.getKExtensionFunction(i), K_EXTENSION_FUNCTIONS.get(i));
        }
        FUNCTION_TO_IMPL = builder.build();
    }
}

