/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.intrinsics;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.RangeCodegenUtil;
import org.jetbrains.jet.codegen.intrinsics.ArrayGet;
import org.jetbrains.jet.codegen.intrinsics.ArrayIndices;
import org.jetbrains.jet.codegen.intrinsics.ArrayIterator;
import org.jetbrains.jet.codegen.intrinsics.ArraySet;
import org.jetbrains.jet.codegen.intrinsics.ArraySize;
import org.jetbrains.jet.codegen.intrinsics.BinaryOp;
import org.jetbrains.jet.codegen.intrinsics.CompareTo;
import org.jetbrains.jet.codegen.intrinsics.Concat;
import org.jetbrains.jet.codegen.intrinsics.CopyToArray;
import org.jetbrains.jet.codegen.intrinsics.EnumValueOf;
import org.jetbrains.jet.codegen.intrinsics.EnumValues;
import org.jetbrains.jet.codegen.intrinsics.Equals;
import org.jetbrains.jet.codegen.intrinsics.HashCode;
import org.jetbrains.jet.codegen.intrinsics.IdentityEquals;
import org.jetbrains.jet.codegen.intrinsics.Increment;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicsMap;
import org.jetbrains.jet.codegen.intrinsics.Inv;
import org.jetbrains.jet.codegen.intrinsics.IteratorIterator;
import org.jetbrains.jet.codegen.intrinsics.IteratorNext;
import org.jetbrains.jet.codegen.intrinsics.JavaClassArray;
import org.jetbrains.jet.codegen.intrinsics.JavaClassFunction;
import org.jetbrains.jet.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.jet.codegen.intrinsics.NewArray;
import org.jetbrains.jet.codegen.intrinsics.Not;
import org.jetbrains.jet.codegen.intrinsics.NumberCast;
import org.jetbrains.jet.codegen.intrinsics.PropertyOfProgressionOrRange;
import org.jetbrains.jet.codegen.intrinsics.RangeTo;
import org.jetbrains.jet.codegen.intrinsics.StaticField;
import org.jetbrains.jet.codegen.intrinsics.StringGetChar;
import org.jetbrains.jet.codegen.intrinsics.StringLength;
import org.jetbrains.jet.codegen.intrinsics.StringPlus;
import org.jetbrains.jet.codegen.intrinsics.StupidSync;
import org.jetbrains.jet.codegen.intrinsics.ToString;
import org.jetbrains.jet.codegen.intrinsics.UnaryMinus;
import org.jetbrains.jet.codegen.intrinsics.UnaryPlus;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.CompileTimeConstantUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;

public class IntrinsicMethods {
    private static final IntrinsicMethod UNARY_MINUS = new UnaryMinus();
    private static final IntrinsicMethod UNARY_PLUS = new UnaryPlus();
    private static final IntrinsicMethod NUMBER_CAST = new NumberCast();
    private static final IntrinsicMethod INV = new Inv();
    private static final IntrinsicMethod RANGE_TO = new RangeTo();
    private static final IntrinsicMethod INC = new Increment(1);
    private static final IntrinsicMethod DEC = new Increment(-1);
    private static final IntrinsicMethod HASH_CODE = new HashCode();
    private static final IntrinsicMethod ARRAY_SIZE = new ArraySize();
    private static final IntrinsicMethod ARRAY_INDICES = new ArrayIndices();
    private static final Equals EQUALS = new Equals();
    private static final IdentityEquals IDENTITY_EQUALS = new IdentityEquals();
    private static final IteratorNext ITERATOR_NEXT = new IteratorNext();
    private static final ArraySet ARRAY_SET = new ArraySet();
    private static final ArrayGet ARRAY_GET = new ArrayGet();
    private static final StringPlus STRING_PLUS = new StringPlus();
    public static final String KOTLIN_JAVA_CLASS_FUNCTION = "kotlin.javaClass.function";
    public static final String KOTLIN_ARRAYS_ARRAY = "kotlin.arrays.array";
    public static final String KOTLIN_COPY_TO_ARRAY = "kotlin.collections.copyToArray";
    private static final EnumValues ENUM_VALUES = new EnumValues();
    private static final EnumValueOf ENUM_VALUE_OF = new EnumValueOf();
    private static final ToString TO_STRING = new ToString();
    private final Map<String, IntrinsicMethod> namedMethods = new HashMap<String, IntrinsicMethod>();
    private static final IntrinsicMethod ARRAY_ITERATOR = new ArrayIterator();
    private final IntrinsicsMap intrinsicsMap = new IntrinsicsMap();

    @PostConstruct
    public void init() {
        this.namedMethods.put(KOTLIN_JAVA_CLASS_FUNCTION, new JavaClassFunction());
        this.namedMethods.put("kotlin.javaClass.property", new JavaClassProperty());
        this.namedMethods.put(KOTLIN_ARRAYS_ARRAY, new JavaClassArray());
        this.namedMethods.put(KOTLIN_COPY_TO_ARRAY, new CopyToArray());
        this.namedMethods.put("kotlin.hashCode", HASH_CODE);
        this.namedMethods.put("kotlin.toString", TO_STRING);
        ImmutableList primitiveCastMethods = OperatorConventions.NUMBER_CONVERSIONS.asList();
        for (Name method2 : primitiveCastMethods) {
            this.declareIntrinsicFunction(Name.identifier("Number"), method2, 0, NUMBER_CAST);
            for (PrimitiveType type : PrimitiveType.NUMBER_TYPES) {
                this.declareIntrinsicFunction(type.getTypeName(), method2, 0, NUMBER_CAST);
            }
        }
        for (PrimitiveType type : PrimitiveType.NUMBER_TYPES) {
            Name typeName = type.getTypeName();
            this.declareIntrinsicFunction(typeName, Name.identifier("plus"), 0, UNARY_PLUS);
            this.declareIntrinsicFunction(typeName, Name.identifier("minus"), 0, UNARY_MINUS);
            this.declareIntrinsicFunction(typeName, Name.identifier("inv"), 0, INV);
            this.declareIntrinsicFunction(typeName, Name.identifier("rangeTo"), 1, RANGE_TO);
            this.declareIntrinsicFunction(typeName, Name.identifier("inc"), 0, INC);
            this.declareIntrinsicFunction(typeName, Name.identifier("dec"), 0, DEC);
            this.declareIntrinsicFunction(typeName, Name.identifier("hashCode"), 0, HASH_CODE);
            this.declareIntrinsicFunction(typeName, Name.identifier("equals"), 1, EQUALS);
        }
        this.declareBinaryOp(Name.identifier("plus"), 96);
        this.declareBinaryOp(Name.identifier("minus"), 100);
        this.declareBinaryOp(Name.identifier("times"), 104);
        this.declareBinaryOp(Name.identifier("div"), 108);
        this.declareBinaryOp(Name.identifier("mod"), 112);
        this.declareBinaryOp(Name.identifier("shl"), 120);
        this.declareBinaryOp(Name.identifier("shr"), 122);
        this.declareBinaryOp(Name.identifier("ushr"), 124);
        this.declareBinaryOp(Name.identifier("and"), 126);
        this.declareBinaryOp(Name.identifier("or"), 128);
        this.declareBinaryOp(Name.identifier("xor"), 130);
        this.declareIntrinsicFunction(Name.identifier("Boolean"), Name.identifier("not"), 0, new Not());
        this.declareIntrinsicFunction(Name.identifier("Boolean"), Name.identifier("equals"), 1, EQUALS);
        this.declareIntrinsicFunction(Name.identifier("String"), Name.identifier("plus"), 1, new Concat());
        this.declareIntrinsicFunction(Name.identifier("CharSequence"), Name.identifier("get"), 1, new StringGetChar());
        this.declareIntrinsicFunction(Name.identifier("String"), Name.identifier("get"), 1, new StringGetChar());
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, Name.identifier("toString"), 0, (IntrinsicMethod)TO_STRING);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, Name.identifier("equals"), 1, (IntrinsicMethod)EQUALS);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, Name.identifier("identityEquals"), 1, (IntrinsicMethod)IDENTITY_EQUALS);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, Name.identifier("plus"), 1, (IntrinsicMethod)STRING_PLUS);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, Name.identifier("arrayOfNulls"), 1, (IntrinsicMethod)new NewArray());
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, Name.identifier("synchronized"), 2, (IntrinsicMethod)new StupidSync());
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, Name.identifier("iterator"), 0, (IntrinsicMethod)new IteratorIterator());
        for (PrimitiveType type : PrimitiveType.values()) {
            this.declareIntrinsicFunction(type.getTypeName(), Name.identifier("compareTo"), 1, new CompareTo());
            this.declareIntrinsicFunction(Name.identifier(type.getTypeName() + "Iterator"), Name.identifier("next"), 0, ITERATOR_NEXT);
        }
        this.declareIntrinsicProperty(Name.identifier("CharSequence"), Name.identifier("length"), new StringLength());
        this.declareIntrinsicProperty(Name.identifier("String"), Name.identifier("length"), new StringLength());
        this.registerStaticField(DescriptorUtils.getFqNameSafe(KotlinBuiltIns.getInstance().getUnit()), Name.identifier("VALUE"));
        for (PrimitiveType type : PrimitiveType.NUMBER_TYPES) {
            FqName rangeClassFqName = RangeCodegenUtil.getRangeClassFqName(type);
            FqName progressionClassFqName = RangeCodegenUtil.getProgressionClassFqName(type);
            this.registerStaticField(rangeClassFqName, Name.identifier("EMPTY"));
            this.registerRangeOrProgressionProperty(rangeClassFqName, Name.identifier("start"));
            this.registerRangeOrProgressionProperty(rangeClassFqName, Name.identifier("end"));
            this.registerRangeOrProgressionProperty(progressionClassFqName, Name.identifier("start"));
            this.registerRangeOrProgressionProperty(progressionClassFqName, Name.identifier("end"));
            this.registerRangeOrProgressionProperty(progressionClassFqName, Name.identifier("increment"));
        }
        this.declareArrayMethods();
    }

    private void registerStaticField(@NotNull FqName classFqName, @NotNull Name propertyName) {
        if (classFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classFqName", "org/jetbrains/jet/codegen/intrinsics/IntrinsicMethods", "registerStaticField"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/jet/codegen/intrinsics/IntrinsicMethods", "registerStaticField"));
        }
        FqNameUnsafe classObjectFqName = classFqName.toUnsafe().child(SpecialNames.getClassObjectName(classFqName.shortName()));
        this.intrinsicsMap.registerIntrinsic(classObjectFqName, propertyName, -1, (IntrinsicMethod)new StaticField(classFqName, propertyName));
    }

    private void registerRangeOrProgressionProperty(@NotNull FqName ownerClass, @NotNull Name propertyName) {
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "org/jetbrains/jet/codegen/intrinsics/IntrinsicMethods", "registerRangeOrProgressionProperty"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/jet/codegen/intrinsics/IntrinsicMethods", "registerRangeOrProgressionProperty"));
        }
        this.intrinsicsMap.registerIntrinsic(ownerClass, propertyName, -1, (IntrinsicMethod)new PropertyOfProgressionOrRange(ownerClass, propertyName));
    }

    private void declareArrayMethods() {
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            this.declareArrayMethodsForPrimitive(jvmPrimitiveType);
        }
        this.declareIntrinsicProperty(Name.identifier("Array"), Name.identifier("size"), ARRAY_SIZE);
        this.declareIntrinsicProperty(Name.identifier("Array"), Name.identifier("indices"), ARRAY_INDICES);
        this.declareIntrinsicFunction(Name.identifier("Array"), Name.identifier("set"), 2, ARRAY_SET);
        this.declareIntrinsicFunction(Name.identifier("Array"), Name.identifier("get"), 1, ARRAY_GET);
        this.declareIterator(Name.identifier("Array"));
    }

    private void declareArrayMethodsForPrimitive(JvmPrimitiveType jvmPrimitiveType) {
        PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
        this.declareIntrinsicProperty(primitiveType.getArrayTypeName(), Name.identifier("size"), ARRAY_SIZE);
        this.declareIntrinsicProperty(primitiveType.getArrayTypeName(), Name.identifier("indices"), ARRAY_INDICES);
        this.declareIntrinsicFunction(primitiveType.getArrayTypeName(), Name.identifier("set"), 2, ARRAY_SET);
        this.declareIntrinsicFunction(primitiveType.getArrayTypeName(), Name.identifier("get"), 1, ARRAY_GET);
        this.declareIterator(primitiveType.getArrayTypeName());
    }

    private void declareIterator(@NotNull Name arrayClassName) {
        if (arrayClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayClassName", "org/jetbrains/jet/codegen/intrinsics/IntrinsicMethods", "declareIterator"));
        }
        this.declareIntrinsicFunction(arrayClassName, Name.identifier("iterator"), 0, ARRAY_ITERATOR);
    }

    private void declareBinaryOp(Name methodName, int opcode) {
        BinaryOp op = new BinaryOp(opcode);
        for (PrimitiveType type : PrimitiveType.values()) {
            this.declareIntrinsicFunction(type.getTypeName(), methodName, 1, op);
        }
    }

    private void declareIntrinsicProperty(Name className, Name methodName, IntrinsicMethod implementation) {
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.child(className), methodName, -1, implementation);
    }

    private void declareIntrinsicFunction(Name className, Name functionName, int arity, IntrinsicMethod implementation) {
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.child(className), functionName, arity, implementation);
    }

    @Nullable
    public IntrinsicMethod getIntrinsic(@NotNull CallableMemberDescriptor descriptor) {
        String value;
        SimpleFunctionDescriptor functionDescriptor;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/intrinsics/IntrinsicMethods", "getIntrinsic"));
        }
        IntrinsicMethod intrinsicMethod = this.intrinsicsMap.getIntrinsic(descriptor);
        if (intrinsicMethod != null) {
            return intrinsicMethod;
        }
        if (descriptor instanceof SimpleFunctionDescriptor && DescriptorUtils.isEnumClassObject((functionDescriptor = (SimpleFunctionDescriptor)descriptor).getContainingDeclaration())) {
            if (DescriptorUtils.isEnumValuesMethod(functionDescriptor)) {
                return ENUM_VALUES;
            }
            if (DescriptorUtils.isEnumValueOfMethod(functionDescriptor)) {
                return ENUM_VALUE_OF;
            }
        }
        if ((value = CompileTimeConstantUtils.getIntrinsicAnnotationArgument(descriptor)) == null) {
            return null;
        }
        return this.namedMethods.get(value);
    }
}

