/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.signature;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterSignature;

public class JvmMethodSignature {
    private final Method asmMethod;
    private final String genericsSignature;
    private final List<JvmMethodParameterSignature> valueParameters;

    JvmMethodSignature(@NotNull Method asmMethod, @Nullable String genericsSignature, @NotNull List<JvmMethodParameterSignature> valueParameters) {
        if (asmMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmMethod", "org/jetbrains/jet/codegen/signature/JvmMethodSignature", "<init>"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/jet/codegen/signature/JvmMethodSignature", "<init>"));
        }
        this.asmMethod = asmMethod;
        this.genericsSignature = genericsSignature;
        this.valueParameters = valueParameters;
    }

    @NotNull
    public Method getAsmMethod() {
        Method method2 = this.asmMethod;
        if (method2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/signature/JvmMethodSignature", "getAsmMethod"));
        }
        return method2;
    }

    @Nullable
    public String getGenericsSignature() {
        return this.genericsSignature;
    }

    @NotNull
    public List<JvmMethodParameterSignature> getValueParameters() {
        List<JvmMethodParameterSignature> list2 = this.valueParameters;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/signature/JvmMethodSignature", "getValueParameters"));
        }
        return list2;
    }

    @NotNull
    public Type getReturnType() {
        Type type = this.asmMethod.getReturnType();
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/signature/JvmMethodSignature", "getReturnType"));
        }
        return type;
    }

    @NotNull
    public JvmMethodSignature replaceName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/jet/codegen/signature/JvmMethodSignature", "replaceName"));
        }
        JvmMethodSignature jvmMethodSignature = newName.equals(this.asmMethod.getName()) ? this : new JvmMethodSignature(new Method(newName, this.asmMethod.getDescriptor()), this.genericsSignature, this.valueParameters);
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/signature/JvmMethodSignature", "replaceName"));
        }
        return jvmMethodSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JvmMethodSignature)) {
            return false;
        }
        JvmMethodSignature that = (JvmMethodSignature)o;
        return this.asmMethod.equals(that.asmMethod) && (this.genericsSignature == null ? that.genericsSignature == null : this.genericsSignature.equals(that.genericsSignature)) && ((Object)this.valueParameters).equals(that.valueParameters);
    }

    public int hashCode() {
        int result = this.asmMethod.hashCode();
        result = 31 * result + (this.genericsSignature != null ? this.genericsSignature.hashCode() : 0);
        result = 31 * result + ((Object)this.valueParameters).hashCode();
        return result;
    }

    public String toString() {
        return this.asmMethod.toString();
    }
}

