/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import com.google.protobuf.ExtensionRegistryLite;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.NameSerializationUtil;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.utils.UtilsPackage;

public final class PackageData {
    private final NameResolver nameResolver;
    private final ProtoBuf.Package packageProto;

    @NotNull
    public static PackageData read(@NotNull byte[] bytes, @NotNull ExtensionRegistryLite registry) {
        PackageData packageData;
        block4: {
            if (bytes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "org/jetbrains/jet/descriptors/serialization/PackageData", "read"));
            }
            if (registry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registry", "org/jetbrains/jet/descriptors/serialization/PackageData", "read"));
            }
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                NameResolver nameResolver = NameSerializationUtil.deserializeNameResolver(in);
                ProtoBuf.Package packageProto = ProtoBuf.Package.parseFrom(in, registry);
                packageData = new PackageData(nameResolver, packageProto);
                if (packageData != null) break block4;
            }
            catch (IOException e) {
                throw UtilsPackage.rethrow(e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/PackageData", "read"));
        }
        return packageData;
    }

    public PackageData(@NotNull NameResolver nameResolver, @NotNull ProtoBuf.Package packageProto) {
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/descriptors/serialization/PackageData", "<init>"));
        }
        if (packageProto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageProto", "org/jetbrains/jet/descriptors/serialization/PackageData", "<init>"));
        }
        this.nameResolver = nameResolver;
        this.packageProto = packageProto;
    }

    @NotNull
    public NameResolver getNameResolver() {
        NameResolver nameResolver = this.nameResolver;
        if (nameResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/PackageData", "getNameResolver"));
        }
        return nameResolver;
    }

    @NotNull
    public ProtoBuf.Package getPackageProto() {
        ProtoBuf.Package package_ = this.packageProto;
        if (package_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/PackageData", "getPackageProto"));
        }
        return package_;
    }

    @NotNull
    public byte[] toBytes() {
        byte[] byArray;
        try {
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            NameSerializationUtil.serializeNameResolver(result, this.nameResolver);
            this.packageProto.writeTo(result);
            byArray = result.toByteArray();
        }
        catch (IOException e) {
            throw UtilsPackage.rethrow(e);
        }
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/PackageData", "toBytes"));
        }
        return byArray;
    }
}

