/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.annotations;

import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class AnnotationsImpl
implements Annotations {
    private final List<AnnotationDescriptor> annotations;

    public AnnotationsImpl(@NotNull List<AnnotationDescriptor> annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/descriptors/annotations/AnnotationsImpl", "<init>"));
        }
        this.annotations = annotations;
    }

    @NotNull
    public List<AnnotationDescriptor> getAnnotationDescriptors() {
        List<AnnotationDescriptor> list2 = this.annotations;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/annotations/AnnotationsImpl", "getAnnotationDescriptors"));
        }
        return list2;
    }

    @Override
    public boolean isEmpty() {
        return this.getAnnotationDescriptors().isEmpty();
    }

    @Override
    @Nullable
    public AnnotationDescriptor findAnnotation(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/descriptors/annotations/AnnotationsImpl", "findAnnotation"));
        }
        for (AnnotationDescriptor annotation : this.annotations) {
            ClassifierDescriptor descriptor = annotation.getType().getConstructor().getDeclarationDescriptor();
            if (!(descriptor instanceof ClassDescriptor) || !fqName.toUnsafe().equals(DescriptorUtils.getFqName(descriptor))) continue;
            return annotation;
        }
        return null;
    }

    @Override
    @NotNull
    public Iterator<AnnotationDescriptor> iterator() {
        Iterator<AnnotationDescriptor> iterator2 = this.getAnnotationDescriptors().iterator();
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/annotations/AnnotationsImpl", "iterator"));
        }
        return iterator2;
    }
}

